# Incremental Implementation Instructions

**Key principle:** Every commit to main should be deployable. No "work in progress" merges.

## Process

1. **List all changes** - Database, models, APIs, UI
2. **Find dependencies** - What needs what?
3. **Order by dependencies** - Bottom-up
4. **Size increments** - Target <500 lines per PR
5. **Verify each** - Tests pass, deployable, no breakage

## Mandatory Checks

Each increment must:
- [ ] All tests pass
- [ ] Can be deployed independently
- [ ] Doesn't break existing functionality

## Should NOT Do

- PRs >500 lines without explicit approval
- "Part 1 of N" where parts aren't independently deployable
- Horizontal slicing (all UI, then all API, then all DB)
- Breaking changes without migration path

## Escalate When

- Feature cannot be sliced without breaking API contracts
- Increment requires data migration affecting >10% of production
- Dependencies form a cycle preventing clean ordering
- Smallest viable increment exceeds 500 lines

For vertical slicing patterns, backward compatibility, and examples, see SKILL.md.
