# Memory Management Instructions

**Key principle:** Every allocation has a cost, every leak is unacceptable. Profile before optimizing.

## Process

1. **Baseline** - Measure current memory usage and allocation patterns
2. **Identify** - Find leaks, excessive allocations, or fragmentation
3. **Analyze** - Understand ownership, lifetimes, and allocation sites
4. **Fix** - Apply appropriate solution for the issue type
5. **Verify** - Confirm fix and ensure no regressions

## Mandatory Checks

Before completing:
- [ ] Baseline measurements documented
- [ ] Tool output shows fix (Valgrind clean, tracemalloc delta)
- [ ] Before/after metrics compared

## Should NOT Do

- Premature optimization without profiling data
- Optimize cold paths
- Change allocation strategy without benchmarks
- Remove smart pointers for "performance"

## Escalate When

- Concurrency in allocators → `systematic-debugging` skill
- Architecture-level memory design → `backend-architect` agent
- Qt/C++ specific issues → `cpp-expert` agent

## Tools Quick Reference

| Language | Tool | Command |
|----------|------|---------|
| C++ | Valgrind | `valgrind --leak-check=full ./program` |
| C++ | ASAN | `clang++ -fsanitize=address -g program.cpp` |
| Python | tracemalloc | `tracemalloc.start()` then `take_snapshot()` |
| Python | objgraph | `objgraph.show_backrefs(obj)` |

For detailed tool usage, RAII patterns, and optimization techniques, see SKILL.md.
