# Receiving Code Review Instructions (Tier 2)

**Core principle:** Verify before implementing. Code works until proven otherwise.

## Response Pattern (R-U-V-E-R-I)

1. **READ** - Complete feedback without reacting
2. **UNDERSTAND** - Restate requirement (or ask)
3. **VERIFY** - Check against codebase reality
4. **EVALUATE** - Technically sound for THIS codebase?
5. **RESPOND** - Technical acknowledgment or reasoned pushback
6. **IMPLEMENT** - One item at a time, test each

## Should NOT Do

- Performative agreement ("You're absolutely right!")
- Implement without understanding
- Batch implement without testing each
- Accept feedback that breaks working code
- Silently ignore feedback you disagree with

## When to Push Back

- Breaks existing functionality
- Reviewer lacks context
- Technically incorrect
- Violates YAGNI
- Conflicts with architectural decisions

## If Any Item Unclear: STOP. Ask First.

```
WRONG: Implement clear items, ask about unclear later
RIGHT: "Need clarification on items 4 and 5 before proceeding."
```

## Escalate When

- Reviewer insists on change that breaks tests
- Conflicting feedback from multiple reviewers
- Feedback requires architecture change
- >10 items of feedback (request prioritization)

For response templates, see `resources/templates.md`.
For anti-patterns to avoid, see `resources/anti-patterns.md`.
