# Anti-Patterns to Avoid

Things to actively avoid when receiving code review:

## 1. Defensive Responses

**Bad:** "But it works in production, we've never had issues"
**Why:** Dismisses valid concerns about edge cases, maintainability, or future issues
**Better:** Verify if the concern is valid for known use cases, then decide

## 2. Superficial Fixes

**Bad:** Changing variable names without understanding why reviewer suggested it
**Why:** Doesn't address underlying issue, may introduce inconsistency
**Better:** Ask "What problem does this name solve?" then apply that principle consistently

## 3. Selective Implementation

**Bad:** Implementing easy feedback (typos, formatting) while ignoring hard feedback (architectural concerns)
**Why:** Gives false impression of completion, leaves critical issues unresolved
**Better:** Clarify ALL feedback first, prioritize blocking/critical items, communicate timeline for complex changes

## 4. Over-Agreeing Without Verification

**Bad:** "You're absolutely right! I'll change everything you mentioned immediately!"
**Why:** Feedback may be based on incomplete context, may conflict with other requirements
**Better:** Verify each piece of feedback against codebase reality before committing

## 5. Arguing Style Without Checking Standards

**Bad:** "I prefer snake_case because it's more readable"
**Why:** Personal preference is irrelevant if project has established conventions
**Better:** Check project style guide, defer to existing patterns, only discuss if genuinely ambiguous

## 6. Silent Disagreement

**Bad:** Ignoring feedback you disagree with, hoping reviewer won't notice
**Why:** Wastes everyone's time, damages trust, feedback will resurface
**Better:** State disagreement with technical reasoning, propose alternatives, escalate if needed

## 7. Batch Changes Without Verification

**Bad:** Implementing 10 feedback items in one commit without testing
**Why:** Can't isolate which change broke tests, hard to revert, compounds errors
**Better:** One change at a time, verify each, commit incrementally

## 8. Explaining Instead of Fixing

**Bad:** Long comment explaining why confusing code is actually correct
**Why:** If it needs explanation, it needs simplification
**Better:** Refactor for clarity, add comment only if genuinely complex domain logic

## 9. Scope Creep from Feedback

**Bad:** Reviewer suggests null check, you refactor entire module
**Why:** Increases review burden, mixes concerns, delays merge
**Better:** Address specific feedback, note broader improvements for separate PR

## 10. Taking It Personally

**Bad:** "Why do you always criticize my code?"
**Why:** Code review is about the code, not the person
**Better:** Separate ego from work, view feedback as investment in code quality
