# Response Templates

## Template 1: Acknowledging Valid Feedback

Use when feedback is technically correct and actionable:

```
"Fixed. [What changed and where]"
"Good catch. [Brief explanation of issue]. Fixed in [file:line]."
"Done. Added [specific change] to handle [edge case]."
```

**Example:**
```
"Good catch. Null pointer possible if API returns empty array. Added null check at parser.ts:45."
```

## Template 2: Pushing Back with Evidence

Use when feedback conflicts with requirements, tests, or technical constraints:

```
"[Current implementation] is needed because [technical reason].
Evidence: [test output / documentation / performance data]
Alternative: [if applicable]"
```

**Example:**
```
"The callback pattern is required for the stream API's backpressure mechanism.
Evidence: Tests for large file handling fail with async/await (see tests/stream.test.ts:67)
Alternative: Could document why callbacks are used here?"
```

## Template 3: Requesting Clarification

Use when feedback is ambiguous or could refer to multiple things:

```
"Which [specific aspect] - the [option A] at line X or [option B] at line Y?
[Brief context why it matters]"
```

**Example:**
```
"Which validation - the input validation (line 30) or the output sanitization (line 52)?
They serve different purposes (XSS vs data integrity)."
```

## Template 4: Agreeing with Concerns, Proposing Alternative

Use when feedback identifies real issue but suggested solution isn't optimal:

```
"Agree [the concern is valid].
However, [constraint that prevents suggested solution].
Proposing: [alternative approach]
Tradeoffs: [brief comparison]"
```

**Example:**
```
"Agree this function is too long and hard to test.
However, extracting to separate file would break the plugin API (needs closure over private state).
Proposing: Extract pure logic to helper methods, keep stateful logic in main function.
Tradeoffs: Less extraction than suggested, but maintains API compatibility."
```

## Template 5: Seeking Prioritization

Use when facing multiple feedback items or architectural changes:

```
"[Number] items total. Breaking down:
- Blocking: [items that prevent merge]
- Important: [items that improve quality]
- Nice-to-have: [items that are optional]

Proposing: Address blocking + important in this PR, create tickets for nice-to-have.
Timeline: [estimate for each category]"
```

**Example:**
```
"8 items total. Breaking down:
- Blocking: #2 (security), #5 (breaks tests)
- Important: #1, #3, #7 (readability, edge cases)
- Nice-to-have: #4, #6, #8 (refactoring, future-proofing)

Proposing: Address blocking + important in this PR (~2 hours), create tickets for nice-to-have.
OK to proceed?"
```

## Template 6: Escalating Disagreement

Use when technical impasse with reviewer:

```
"We have different perspectives on [specific issue]:
- Your concern: [restate their point accurately]
- My concern: [state your technical reasoning]
- Impact: [what breaks either way]

Requesting [tech lead / architect] input on [specific decision needed]."
```

**Example:**
```
"We have different perspectives on error handling strategy:
- Your concern: Errors should propagate to caller for flexibility
- My concern: Current API contract promises no exceptions (documented in v1.0)
- Impact: Changing error handling is breaking change for 40+ consumers

Requesting tech lead input on whether to:
1. Make breaking change with major version bump
2. Add new method with exception handling, deprecate old
3. Keep current behavior"
```

## Template 7: Acknowledging but Deferring

Use when feedback is valid but out of scope for current PR:

```
"Valid point. [Acknowledge the concern]
Current PR scope: [what this PR does]
This change would: [expand scope / affect other areas]

Created ticket #[number] to [address concern separately].
OK to defer?"
```

**Example:**
```
"Valid point. The entire auth module could use a refactor to use modern patterns.
Current PR scope: Fix OAuth token expiration bug
This change would: Affect 12 other files, require security re-review

Created ticket #456 to audit auth module in Q2.
OK to defer?"
```
