# Subagent-Driven Development Instructions

**Key principle:** Fresh subagent per task + review between tasks = high quality, fast iteration.

## Process

### Sequential (default)
1. **Load plan** - Read plan file, create TodoWrite
2. **Execute task** - Dispatch subagent with focused prompt
3. **Review work** - Dispatch `code-reviewer` agent
4. **Apply feedback** - Fix critical/important issues before next task
5. **Mark complete** - Update TodoWrite, proceed to next

### Parallel (independent tasks only)
1. **Apply decision framework** - Check file overlap, shared state, dependencies
2. **Determine wave size** - Simple: 5-8, Medium: 3-4, Complex: 1-2
3. **Execute wave** - Multiple Task calls in single message
4. **Review wave** - Code review all changes together

## Mandatory Checks

- [ ] Code review after each task (sequential) or wave (parallel)
- [ ] Critical issues fixed before proceeding
- [ ] No manual fixes (use fix subagent instead)

## Should NOT Do

- Skip code review between tasks
- Proceed with unfixed Critical issues
- Dispatch parallel implementation subagents on same files
- Fix manually after subagent fails (context pollution)

## Escalate When

- Subagent fails same task 2x → user for approach change
- Code review finds architectural issues → `backend-architect` agent
- Parallel agents conflict → stop parallel, switch to sequential

For execution types, checkpoint patterns, and prompt templates, see SKILL.md.
