# 目录概要文件模板

## 文件命名规则

原文件名：`python_tutorial.md`
概要文件名：`python_tutorial_overview.md`
存储位置：`knowledge_base/contents_overview/`

## 模板格式

```markdown
# [文件名] - 目录概要

> 文件路径：knowledge_base/path/to/file.md
> 文件大小：XXX KB
> 生成时间：YYYY-MM-DD

## 章节目录

- [第1章 标题](起始行号: 10)
- [第2章 标题](起始行号: 150)
  - [2.1 小节标题](起始行号: 180)
  - [2.2 小节标题](起始行号: 250)
- [第3章 标题](起始行号: 400)
  - [3.1 小节标题](起始行号: 420)
  - [3.2 小节标题](起始行号: 500)
```

## 生成步骤

### 1. 提取标题和行号

```bash
# 使用 Grep 工具
grep -n '^#+' knowledge_base/path/to/file.md
```

输出示例：
```
10:# 第1章 介绍
150:## 1.1 背景
180:## 1.2 目标
400:# 第2章 方法
420:## 2.1 数据收集
500:## 2.2 数据分析
```

### 2. 解析标题层级

- `#` → 一级标题（无缩进）
- `##` → 二级标题（缩进2空格）
- `###` → 三级标题（缩进4空格）
- 以此类推

### 3. 生成目录结构

根据 `#` 数量判断层级，使用行号作为定位锚点。

### 4. 获取文件大小

```bash
ls -lh knowledge_base/path/to/file.md | awk '{print $5}'
```

### 5. 获取当前时间

```bash
date '+%Y-%m-%d'
```

## 示例输出

```markdown
# Python入门教程 - 目录概要

> 文件路径：knowledge_base/技术文档/编程语言/python_tutorial.md
> 文件大小：85 KB
> 生成时间：2025-01-06

## 章节目录

- [第1章 Python简介](起始行号: 10)
  - [1.1 什么是Python](起始行号: 25)
  - [1.2 安装Python](起始行号: 80)
  - [1.3 第一个程序](起始行号: 150)
- [第2章 基础语法](起始行号: 200)
  - [2.1 变量和数据类型](起始行号: 220)
  - [2.2 运算符](起始行号: 350)
  - [2.3 控制流程](起始行号: 450)
- [第3章 函数](起始行号: 600)
  - [3.1 定义函数](起始行号: 620)
  - [3.2 参数和返回值](起始行号: 720)
- [第4章 面向对象](起始行号: 900)
  - [4.1 类和对象](起始行号: 920)
  - [4.2 继承](起始行号: 1100)
```

## 用途

用户查询大文件时：
1. 先读取目录概要，了解整体结构
2. 根据行号范围精准定位到相关章节
3. 使用 `Read` 工具读取指定行范围

```python
# 例如读取第2章内容（行号200-599）
Read("knowledge_base/技术文档/编程语言/python_tutorial.md", offset=200, limit=400)
```
