---
name: satisfaction-feedback
description: 处理用户满意度反馈。用户回复"满意"/"不满意"时，更新 FAQ 使用计数或记录 BADCASE。触发词：满意/不满意/解决了/���解决/谢谢。
---

# 满意度反馈处理

处理用户的满意度反馈，根据答案来源更新 FAQ 或记录问题。

## 触发词

**满意**：满意、解决了、谢谢、明白了、好的、懂了、清楚了、知道了
**不满意**：不满意、没解决、不对、错了、不行

## 处理逻辑

根据**上一轮答案来源**（元数据 `answer_source`）分类处理：

| 答案来源 | 满意反馈 | 不满意反馈 |
|---------|---------|-----------|
| FAQ | 增加使用计数 | 移除条目 + 记录 BADCASE |
| 知识库文件 | 添加到 FAQ | 记录 BADCASE |

## 关键原则

1. **使用文件锁**：更新 FAQ.md 和 BADCASE.md 时必须使用 `SharedKBAccess` 文件锁
2. **并发安全**：多用户同时操作时避免数据冲突
3. **状态更新**：满意反馈后 session_status 设为 "resolved"

## 详细操作

FAQ 增删改操作详情，见 [FAQ_OPERATIONS.md](FAQ_OPERATIONS.md)
