---
name: ai-research
description: Automates AI briefing preparation and technology research. Use for regular updates on AI trends, tools, and models relevant to the job search.
---

# AI Research and Intelligence

<workflow>

## Step 1: Define Research Scope

1. Determine parameters from the user request:
   - **Topic Scope:** AI models, tools, platforms, trends.
   - **Time Horizon:** Last 24 hours, 7 days, 30 days.
   - **Depth:** Quick overview vs. deep analysis.

## Step 2: Data Collection

1. Systematically gather information:
   - **Models & Research:** New architectures, papers, breakthroughs.
   - **Tools & Platforms:** Software updates, new features.
   - **Industry News:** Funding, acquisitions, launches.
   - **Community:** Hot topics, debates, insights.

## Step 3: Analysis and Synthesis

1. Identify key insights:
   - What is truly relevant for the Candidate?
   - Which trends impact the job search?
   - Which skills are becoming more valuable?

2. Assess relevance:
   - **High Impact:** Direct impact on career.
   - **Medium Impact:** Trends worth knowing.
   - **Low Impact:** Interesting but non-essential.

## Step 4: Briefing Creation

1. Create a structured briefing using the template in `references/templates.md`.
2. Save to: `/04-Application-Tools/AI-Workflows/YYYY-MM-DD-AI-Briefing.md`.

## Step 5: System Integration

1. Update related files:
   - Add insights to `Candidate-Profile.md` (if relevant).
   - Update style guides with new terminology.
   - Connect with active leads and applications.

</workflow>
