---
name: research-company
description: Conducts deep company research and creates a dossier to support applications. Use before applying, interviewing, or for cultural fit assessment.
---

# Research Company

<rules>

- Dossiers MUST be saved to `03-Job-Market-Research/Company-Research/`.
- Files MUST use naming convention `YYYY-MM-DD - Title.md`.
- The agent MUST NOT guess. Mark missing data as unverified.
- A sources section MUST be included.

</rules>

<workflow>

## Step 1: Basic Information Gathering

1. Identify the company from the user request (name, URL, sector).
2. Collect basic data: locations, size, sector, products, history.

## Step 2: Deep Analysis

1. **Business:** Model, revenue, tech stack, finances, growth.
2. **Culture:** Values, mission, work style, leadership, reputation.
3. **Market:** Position, competitors, trends, regulations.

## Step 3: Recruitment Context

1. Analyze open positions and hiring patterns.
2. Identify business needs and strategic priorities.
3. Determine the opportunity window for the Candidate.

## Step 4: Dossier Preparation

1. Create a dossier using the template in `references/templates.md`.
2. Save to: `/03-Job-Market-Research/Company-Research/YYYY-MM-DD - Company Name.md`.

## Step 5: System Update

1. Update the list of researched companies.
2. Link to existing leads/applications.
3. Prepare key insights for potential interviews.

</workflow>
