# Credits & Acknowledgments

This skill was built upon the collective wisdom of the Salesforce developer community. We gratefully acknowledge the following authors and resources whose ideas, patterns, and best practices have shaped this skill.

---

## Authors & Contributors

### James Simone
**[Joys of Apex](https://www.jamessimone.net/blog/)**

Key contributions:
- Factory Pattern for dependency injection
- Repository Pattern for data access abstraction
- Singleton Pattern implementation
- Performant Apex testing strategies
- Naming conventions and code organization

### Pablo Gonzalez
**[Clean Apex Code](https://www.pablogonzalez.io/)**

Key contributions:
- SOLID principles applied to Apex
- Clean code refactoring techniques
- Boolean clarity and self-documenting code
- Software design principles for Salesforce

### Mitch Spano
**[Trigger Actions Framework](https://github.com/mitchspano/trigger-actions-framework)**

Key contributions:
- Metadata-driven trigger management
- One trigger per object pattern
- Bypass mechanisms (global, transaction, permission-based)
- Unified Apex and Flow action execution

### Beyond the Cloud (Salesforce Blog)
**[blog.beyondthecloud.dev](https://blog.beyondthecloud.dev/)**

Key contributions:
- Code review red flags and anti-patterns
- Common mistakes checklist
- Best practices for sharing modes
- Test data factory recommendations

### Justus van den Berg
**[Medium @justusvandenberg](https://medium.com/@justusvandenberg)**

Key contributions:
- Heap size optimization techniques
- CPU time optimization
- Maps vs Arrays performance analysis
- Large string handling strategies

### Coding With The Force
**[codingwiththeforce.com](https://codingwiththeforce.com/)** | **[YouTube](https://www.youtube.com/@CodingWithTheForce)**

Key contributions:
- Separation of Concerns tutorial series
- Apex Common Library guidance
- SOLID design principles tutorials
- Unit testing with Apex Mocks

### Saurabh Samir
**[Medium @saurabh.samirs](https://medium.com/@saurabh.samirs)**

Key contributions:
- Decorator Pattern for adding behavior without modification
- Observer Pattern for event-driven architecture
- Command Pattern for operation queuing and undo
- Facade Pattern for simplifying complex subsystems

### César Parra
**[ApexDocs](https://github.com/cesarParra/apexdocs)**

Key contributions:
- ApexDoc documentation standards
- Documentation generation best practices
- OpenAPI spec generation for REST classes

---

## Frameworks & Libraries

### Trigger Actions Framework
- **Author**: Mitch Spano
- **Repository**: https://github.com/mitchspano/trigger-actions-framework
- **License**: MIT

### Apex Common Library (fflib)
- **Original Author**: Andy Fawcett (FinancialForce)
- **Maintainer**: John Daniel & Community
- **Repository**: https://github.com/apex-enterprise-patterns/fflib-apex-common

### Apex Mockery
- **Author**: Salesforce
- **Repository**: https://github.com/salesforce/apex-mockery

---

## Official Salesforce Resources

- **Salesforce Developer Blog**: https://developer.salesforce.com/blogs
- **Trailhead**: https://trailhead.salesforce.com
- **Apex Developer Guide**: https://developer.salesforce.com/docs/atlas.en-us.apexcode.meta/apexcode/

---

## Community Resources

### Apex Hours
**[apexhours.com](https://www.apexhours.com/)**
- Test class best practices
- Trigger framework patterns
- Security best practices
- Governor limits guidance

### Salesforce Ben
**[salesforceben.com](https://www.salesforceben.com/)**
- Apex best practices articles
- Trigger handler framework guides

### Salesforce Stack Exchange
**[salesforce.stackexchange.com](https://salesforce.stackexchange.com/)**
- Community Q&A and solutions
- Design pattern discussions

---

## Books

### Salesforce Lightning Platform Enterprise Architecture
- **Author**: Andy Fawcett
- **Topics**: Enterprise patterns, Service Layer, Domain Layer, Selector Layer, Unit of Work

### Clean Apex Code: Software Design for Salesforce Developers
- **Author**: Pablo Gonzalez
- **Publisher**: Apress
- **Topics**: SOLID principles, refactoring, clean code, testing

---

## Special Thanks

To the entire Salesforce developer community for sharing knowledge, writing blogs, creating open-source tools, and helping each other build better solutions.

---

*If we've missed anyone whose work influenced this skill, please let us know so we can add proper attribution.*
