# Credits & Acknowledgments

This skill was built upon the collective wisdom of the Salesforce security and OAuth community. We gratefully acknowledge the following authors and resources whose ideas, patterns, and best practices have shaped this skill.

---

## Official Salesforce Resources

### Salesforce Documentation
- **Connected Apps Developer Guide**: https://developer.salesforce.com/docs/atlas.en-us.api_rest.meta/api_rest/intro_oauth_and_connected_apps.htm
- **External Client Apps Guide**: https://help.salesforce.com/s/articleView?id=sf.external_client_apps.htm
- **OAuth 2.0 Flows**: https://help.salesforce.com/s/articleView?id=sf.remoteaccess_oauth_flows.htm
- **JWT Bearer Flow**: https://help.salesforce.com/s/articleView?id=sf.remoteaccess_oauth_jwt_flow.htm

### Salesforce Trailhead
- **Build Integrations with Connected Apps**: https://trailhead.salesforce.com/en/content/learn/modules/connected-app-basics
- **Security for External Client Apps**: https://trailhead.salesforce.com/en/content/learn/modules/external-client-apps

---

## Authors & Contributors

### Salesforce Identity Team
Key contributions:
- OAuth 2.0 implementation patterns
- Security best practices for Connected Apps
- External Client App architecture

### Salesforce Security Blog
**[security.salesforce.com](https://security.salesforce.com/)**

Key contributions:
- OAuth security best practices
- Token management guidance
- Certificate authentication patterns

---

## Community Resources

### Salesforce Ben
**[salesforceben.com](https://www.salesforceben.com/)**
- Connected App configuration guides
- OAuth flow selection tutorials
- Security review checklists

### Apex Hours
**[apexhours.com](https://www.apexhours.com/)**
- JWT Bearer flow implementation
- Connected App security patterns
- Integration authentication guides

### Salesforce Stack Exchange
**[salesforce.stackexchange.com](https://salesforce.stackexchange.com/)**
- Community Q&A on OAuth issues
- Best practice discussions
- Troubleshooting solutions

---

## Key Concepts Credited

### OAuth 2.0 Flow Selection
The decision matrix for selecting appropriate OAuth flows is based on official Salesforce documentation and community best practices.

### External Client App Architecture
The separation of concerns pattern (Authentication vs Authorization) comes from Salesforce's modern security architecture introduced in API 60+.

### JWT Bearer Flow Implementation
Certificate-based authentication patterns are documented by Salesforce and refined by community implementations.

---

## Special Thanks

To the Salesforce Identity and Security teams for continuously improving OAuth patterns and providing comprehensive documentation for secure integration development.

---

*If we've missed anyone whose work influenced this skill, please let us know so we can add proper attribution.*
