#!/bin/bash
#
# Multi-Step Deployment Script
# Generated by sf-deploy skill
#
# Usage: ./scripts/deploy.sh <target-org-alias>

set -e  # Exit on error

TARGET_ORG=${1:-"myorg"}
PROJECT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}/..")" && pwd)"

echo "═══════════════════════════════════════════════════════════════════"
echo "  DEPLOYMENT TO: $TARGET_ORG"
echo "═══════════════════════════════════════════════════════════════════"

# Step 0: Pre-flight checks
echo "📋 Pre-flight checks..."
sf --version || { echo "❌ sf CLI not found"; exit 1; }
sf org display --target-org "$TARGET_ORG" || { echo "❌ Cannot connect to org"; exit 1; }

# Step 1: Deploy Custom Objects/Fields
echo "📦 Step 1: Deploying objects and fields..."
sf project deploy start \
    --source-dir "$PROJECT_DIR/force-app/main/default/objects" \
    --target-org "$TARGET_ORG" \
    --wait 10

# Step 2: Deploy Permission Sets
echo "📦 Step 2: Deploying permission sets..."
sf project deploy start \
    --source-dir "$PROJECT_DIR/force-app/main/default/permissionsets" \
    --target-org "$TARGET_ORG" \
    --wait 10

# Step 3: Deploy Apex (with tests)
echo "📦 Step 3: Deploying Apex..."
sf project deploy start \
    --source-dir "$PROJECT_DIR/force-app/main/default/classes" \
    --source-dir "$PROJECT_DIR/force-app/main/default/triggers" \
    --target-org "$TARGET_ORG" \
    --test-level RunLocalTests \
    --wait 30

# Step 4: Deploy Flows (Draft)
echo "📦 Step 4: Deploying flows..."
sf project deploy start \
    --source-dir "$PROJECT_DIR/force-app/main/default/flows" \
    --target-org "$TARGET_ORG" \
    --wait 10

echo "═══════════════════════════════════════════════════════════════════"
echo "  ✅ DEPLOYMENT COMPLETE"
echo "═══════════════════════════════════════════════════════════════════"
echo ""
echo "Next Steps:"
echo "  1. Assign permission sets: sf org assign permset --name PermSetName --target-org $TARGET_ORG"
echo "  2. Activate flows: Edit XML status to Active, redeploy"
echo "  3. Run test data: sf apex run --file scripts/data/create-test-data.apex --target-org $TARGET_ORG"
