---
name: {{SKILL_NAME}}
description: {{SKILL_DESCRIPTION}}
version: {{VERSION}}
author: {{AUTHOR}}
tags: {{TAGS}}
allowed-tools: {{ALLOWED_TOOLS}}
---

# {{SKILL_NAME}}: {{SKILL_DESCRIPTION}}

You are an expert assistant specializing in {{SKILL_DOMAIN}}. Your role is to help users with {{SKILL_PURPOSE}}.

## Core Responsibilities

1. **Primary Function**: [Describe the main thing this skill does]
2. **Secondary Functions**: [Any supporting capabilities]
3. **Output**: [What users should expect to receive]

## Workflow

When a user invokes this skill, follow these steps:

### Phase 1: Understanding
1. Analyze the user's request
2. Identify what needs to be done
3. Determine which tools are needed
4. [Add specific steps for your skill]

### Phase 2: Execution
1. [First action step]
2. [Second action step]
3. [Third action step]
4. [Continue as needed]

### Phase 3: Delivery
1. Present results clearly
2. Provide explanations where helpful
3. Suggest next steps or improvements
4. [Skill-specific delivery steps]

## Best Practices

When executing this skill:

- **Be Clear**: Provide explicit, understandable output
- **Be Thorough**: Don't skip important steps
- **Be Helpful**: Explain why, not just what
- **Be Accurate**: Verify information before presenting it
- [Add skill-specific best practices]

## Examples

### Example 1: [Common Use Case]
```
User: "[Example request]"

You should:
1. [Step 1]
2. [Step 2]
3. [Step 3]

Output: [What the user receives]
```

### Example 2: [Another Use Case]
```
User: "[Another example request]"

You should:
1. [Step 1]
2. [Step 2]
3. [Step 3]

Output: [What the user receives]
```

## Tool Usage

This skill has access to the following tools:
{{TOOL_DESCRIPTIONS}}

Use these tools to:
- [Purpose 1]
- [Purpose 2]
- [Purpose 3]

## Edge Cases

Be aware of these special situations:

- **Edge Case 1**: [Description and how to handle]
- **Edge Case 2**: [Description and how to handle]
- **Edge Case 3**: [Description and how to handle]

## Error Handling

If something goes wrong:

1. **Identify the issue**: What specifically failed?
2. **Explain to user**: Clear, non-technical explanation
3. **Suggest solutions**: Actionable steps to resolve
4. **Graceful degradation**: Partial results if possible

## Output Format

Structure your output like this:

```
[Your skill's typical output format]

## Summary
[Brief overview of what was done]

## Details
[Specific findings, results, or generated content]

## Next Steps
[Recommendations for the user]
```

## Notes

- [Important consideration 1]
- [Important consideration 2]
- [Any limitations or prerequisites]
- [Tips for best results]

---

## Customization Guide

**You should customize this template by:**

1. **Replacing placeholders** with your skill-specific content
2. **Removing sections** that don't apply to your skill
3. **Adding sections** for unique requirements
4. **Including concrete examples** from your domain
5. **Being specific** about tools and their purposes

**Common customization patterns:**

For **code analysis skills**:
- Add section for analysis criteria
- Include pattern recognition logic
- Define severity levels
- Specify output format for findings

For **documentation skills**:
- Define documentation standards
- Include template structures
- Specify formatting rules
- Add example documentation outputs

For **interactive skills**:
- Define question sequences
- Specify validation logic
- Include user feedback patterns
- Add confirmation steps

For **generation skills**:
- Define generation rules
- Include template examples
- Specify customization options
- Add validation for generated content

**Remember:** This template is a starting point. Make it specific to your skill's purpose!
