# Credits & Acknowledgments

This skill was built upon the collective wisdom of the technical documentation and diagramming community. We gratefully acknowledge the following authors and resources whose ideas, patterns, and best practices have shaped this skill.

---

## Diagramming Tools & Libraries

### Mermaid
**[mermaid.js.org](https://mermaid.js.org/)**
- **License**: MIT
- **Authors**: Knut Sveidqvist and contributors
- Primary diagramming syntax for ERD, sequence, and flowchart diagrams

Key contributions:
- Entity Relationship Diagram syntax
- Sequence diagram patterns
- Flowchart and state diagram support
- Live rendering capabilities

### PlantUML
**[plantuml.com](https://plantuml.com/)**
- Alternative diagramming syntax reference
- UML diagram patterns

---

## Salesforce Documentation

### Official Resources
- **Schema Reference**: https://developer.salesforce.com/docs/atlas.en-us.object_reference.meta/object_reference/
- **Relationship Types**: https://help.salesforce.com/s/articleView?id=sf.overview_of_custom_object_relationships.htm
- **Data Modeling Guide**: https://architect.salesforce.com/design/decision-guides/data-modeling

### Salesforce Architects
**[architect.salesforce.com](https://architect.salesforce.com/)**

Key contributions:
- Data model design patterns
- Integration architecture diagrams
- Reference architectures

---

## Authors & Contributors

### Salesforce Ben
**[salesforceben.com](https://www.salesforceben.com/)**

Key contributions:
- Data model visualization guides
- ERD creation tutorials
- Schema documentation patterns

### LucidChart Salesforce Integration
**[lucidchart.com](https://www.lucidchart.com/)**

Key contributions:
- Salesforce ERD generation patterns
- Visual data modeling approaches

---

## Community Resources

### Salesforce Stack Exchange
**[salesforce.stackexchange.com](https://salesforce.stackexchange.com/)**
- Data modeling discussions
- Diagram best practices
- Documentation patterns

### Unofficial SF
**[unofficialsf.com](https://unofficialsf.com/)**
- Flow visualization approaches
- Automation documentation patterns

---

## Key Concepts Credited

### ERD Notation
The Entity Relationship Diagram conventions follow standard database modeling patterns adapted for Salesforce relationships (Master-Detail, Lookup, External).

### Sequence Diagram Patterns
OAuth flow and integration sequence diagrams follow UML 2.0 standards with Salesforce-specific adaptations.

### Mermaid in Documentation
The approach of using Mermaid for inline diagrams in Markdown documentation is a widely-adopted pattern in technical documentation.

---

## Special Thanks

To the Mermaid.js community for creating an accessible, text-based diagramming tool that enables version-controlled technical documentation.

---

*If we've missed anyone whose work influenced this skill, please let us know so we can add proper attribution.*
