# Credits & Acknowledgments

This skill leverages cutting-edge AI technologies and tools from Google and the open-source community.

---

## Technologies & Tools

### Google Gemini
**[Google AI Studio](https://aistudio.google.com/)**

Key capabilities:
- Gemini 3 Pro multimodal AI model
- Image generation via Nano Banana Pro extension
- Code review and analysis capabilities
- Documentation research and summarization

### Gemini CLI
**[npm: @google/gemini-cli](https://www.npmjs.com/package/@google/gemini-cli)**

Key features:
- Command-line access to Gemini models
- Extension support (Nano Banana)
- Non-interactive mode with --yolo flag
- JSON output for programmatic use

### Nano Banana Pro
**Gemini Image Generation Extension**

Key features:
- High-quality image generation
- ERD and diagram creation
- UI/UX mockup generation
- Architecture visualization

---

## Display Technologies

### timg
**[GitHub: hzeller/timg](https://github.com/hzeller/timg)**

Key features:
- Terminal image viewer
- Kitty graphics protocol support
- Multiple format support (PNG, JPG, GIF)
- Inline terminal display

### Kitty Graphics Protocol
**[Kitty Documentation](https://sw.kovidgoyal.net/kitty/graphics-protocol/)**

Key features:
- High-fidelity image display in terminals
- Supported by Ghostty, Kitty, WezTerm
- Enables visual content in CLI workflows

### Ghostty Terminal
**[ghostty.org](https://ghostty.org/)**

Key features:
- Modern GPU-accelerated terminal
- Kitty graphics protocol support
- Cross-platform (macOS, Linux)
- High performance rendering

---

## Salesforce Resources

### Salesforce Lightning Design System (SLDS)
**[lightningdesignsystem.com](https://www.lightningdesignsystem.com/)**

- Design patterns for LWC mockups
- Color palettes and typography
- Component specifications

### Salesforce Developers
**[developer.salesforce.com](https://developer.salesforce.com/)**

- API documentation
- Best practices guides
- Platform architecture references

---

## Special Thanks

- Google AI team for Gemini and the Gemini CLI
- The timg project for terminal graphics
- Ghostty team for excellent Kitty protocol support
- Salesforce community for design system resources

---

*If we've missed anyone whose work influenced this skill, please let us know so we can add proper attribution.*
