<!-- Parent: sf-diagram-nanobananapro/SKILL.md -->
# Official Salesforce Architect ERD Aesthetic Guide

Reference for generating ERDs matching the **architect.salesforce.com** visual style.
This is the default style for all ERD diagrams generated by sf-diagram-nanobananapro.

---

## Cloud-Specific Color Palettes

Each Salesforce cloud has its own brand color. The skill auto-detects which cloud to use based on the objects requested.

| Cloud | Border Color | Fill (~25% opacity) | Detect By Objects |
|-------|--------------|---------------------|-------------------|
| **Sales Cloud** | `#0B827C` (Teal) | Light Teal | Lead, Opportunity, Quote, Campaign, Order |
| **Service Cloud** | `#9E2A7D` (Magenta) | Light Pink | Case, Knowledge, Entitlement, Swarm, Incident |
| **Platform** | `#5A67D8` (Purple) | Light Purple | Account, Contact only (no cloud-specific objects) |
| **Industries/Scheduler** | `#BA4383` (Pink) | Light Pink | ServiceTerritory, WorkType, Shift, ServiceResource |
| **Nonprofit Cloud** | `#032D60` (Navy) | Light Gray | Survey, Donation, Program objects |

---

## The Signature Box Style: "Dark Border + Light Fill"

This is the defining visual pattern of architect.salesforce.com diagrams:

| Property | Value |
|----------|-------|
| **Border** | Solid 2px in cloud's brand color |
| **Fill** | Same hue at ~25% opacity (translucent) |
| **Corners** | Rounded (8-12px radius) |
| **Text** | Dark gray/black on light fill |

### Visual Example

```
┌─────────────────────────┐
│ ░░░░░░░░░░░░░░░░░░░░░░░ │  ← Light translucent fill
│ ░ Opportunity          ░ │  ← Bold logical name
│ ░ Opportunity          ░ │  ← Smaller italic API name
│ ░ • Name               ░ │  ← Key fields with bullets
│ ░ • Amount             ░ │
│ ░ • Close Date         ░ │
└─────────────────────────┘
  ↑ Dark solid border
```

---

## Page Structure

### 1. Page Title (Top)

Large bold text centered at the very top:
- Format: `"[Cloud Name] Overview Data Model"`
- Example: `"Sales Cloud Overview Data Model"`

### 2. Header Banner

Below the title, a horizontal banner containing:

```
┌──────────────────────────────────────────────────────────────────────────────┐
│ [salesforce]  SALES CLOUD   │  LEGEND:                                       │
│               Overview      │  ENTITIES        │  RELATIONSHIPS              │
│                             │  [boxes...]      │  [symbols...]               │
└──────────────────────────────────────────────────────────────────────────────┘
```

**Left Section:**
- Salesforce cloud logo
- "[CLOUD NAME] Overview" in dark background

**Center Section - ENTITIES:**
- Cloud Entity (dark border + light fill)
- Related Entity (dark border + light fill)
- External Entity (black border + white fill)

**Right Section - RELATIONSHIPS:**
- Parent to Child (Many-to-One)
- Required to Required (One-to-One)
- Optional to Optional (Zero-or-One to Zero-or-One)
- Many-to-Many

### 3. Main Diagram Area

The ERD with objects and relationship lines.

### 4. Footer

```
┌──────────────────────────────────────────────────────────────────────────────┐
│ ©2024 Salesforce - Subject to change without notice    Last modified: [DATE]│
└──────────────────────────────────────────────────────────────────────────────┘
```

---

## Entity Box Format

Each object box contains:

```
┌─────────────────────────┐
│ Opportunity             │  ← Bold logical name (larger font)
│ Opportunity             │  ← API name (smaller, italic, gray)
│ • Name                  │  ← Key field 1 with bullet
│ • Amount                │  ← Key field 2 with bullet
│ • Close Date            │  ← Key field 3 with bullet
│ • StageName             │  ← Key field 4 (optional)
└─────────────────────────┘
```

### Recommended Fields by Object

| Object | Key Fields |
|--------|------------|
| Account | Account Number, Name, Industry, Type |
| Contact | Name, Email, Title, Phone |
| Lead | Name, Company, Status, Rating |
| Opportunity | Name, Amount, Close Date, StageName |
| Campaign | Name, Type, Status, StartDate |
| Case | CaseNumber, Type, Priority, Status |
| Quote | Name, ExpirationDate, Status |
| Order | OrderNumber, EffectiveDate, Status |
| Product2 | Name, ProductCode, IsActive |

---

## Relationship Line Labels

**Always include descriptive text labels on relationship lines.**

| Relationship Type | Label Examples |
|-------------------|----------------|
| Parent-Child | "child of", "parent of" |
| Lookup | "related to" |
| Junction | "member of", "participant in" |
| Conversion | "converts to", "promoted to" |
| Association | "assigned to", "owned by" |

### Line Styling

| Property | Value |
|----------|-------|
| Stroke width | 1-2px |
| Color | Black (`#000000`) |
| Direction | Straight horizontal or vertical only (NO diagonals) |
| Crow's foot | On "many" side of relationship |
| Bar | On "one" side (required) |
| Circle + Bar | On "one" side (optional) |

---

## Master Prompt Template

Use this template when generating ERDs:

```
Create a Salesforce [CLOUD_NAME] ERD in the EXACT architect.salesforce.com style:

PAGE TITLE (very top, large bold text):
'[Cloud Name] Overview Data Model'

HEADER SECTION (below title):
- Left: Salesforce cloud logo + '[CLOUD_NAME] Overview' in dark [COLOR] (#[HEX]) banner box
- Center: LEGEND with 'ENTITIES' section showing:
  * Cloud Entity box (dark [COLOR] border, light [COLOR] ~25% opacity fill)
  * Related Entity box (dark border, lighter fill)
  * External Entity box (black border, white fill)
- Right: 'RELATIONSHIPS' section showing notation symbols

BOX STYLING - CRITICAL:
- DARK BORDER: Solid 2px border in dark [COLOR] (#[HEX])
- LIGHT TRANSLUCENT FILL: Same [COLOR] hue at ~25% opacity
- Rounded corners (8-12px radius)
- Text in dark gray/black on the light fill

ENTITY BOX FORMAT:
┌─────────────────────────┐
│ Logical Name            │  (Bold, larger)
│ APIName                 │  (Smaller, italic, gray)
│ • Field1                │  (Bullet points)
│ • Field2                │
└─────────────────────────┘

OBJECTS TO INCLUDE:
[List objects with their fields]

RELATIONSHIP LINES:
- Thin black lines with text labels ON the lines
- 'child of' / 'parent of' / 'related to' labels
- Crow's foot on many side, bar on one side
- STRAIGHT LINES ONLY (horizontal and vertical)

FOOTER:
Left: '©[YEAR] Salesforce - Subject to change without notice'
Right: 'Last modified: [DATE]'

CRITICAL: Dark [COLOR] borders with LIGHT translucent [COLOR] fill.
```

---

## Cloud-Specific Templates

### Sales Cloud

```
COLOR: Teal #0B827C
OBJECTS: Lead, Account, Contact, Opportunity, Campaign, CampaignMember,
         Quote, Order, Product2, PricebookEntry, Territory
```

### Service Cloud

```
COLOR: Magenta #9E2A7D
OBJECTS: Case, Knowledge, KnowledgeArticle, Entitlement, Asset,
         ServiceContract, WorkOrder, Swarm, Incident, Problem
```

### Platform (Generic)

```
COLOR: Purple #5A67D8
OBJECTS: Account, Contact, User, Custom Objects
```

---

## Quick Reference Checklist

```
ARCHITECT.SALESFORCE.COM ERD CHECKLIST
═══════════════════════════════════════

☐ Page title at very top ("[Cloud] Overview Data Model")
☐ Header banner with Salesforce logo + "[CLOUD] Overview"
☐ Legend bar (ENTITIES + RELATIONSHIPS sections)
☐ DARK border in cloud's brand color
☐ LIGHT translucent fill (~25% opacity)
☐ Entity boxes: Name + API Name + bullet fields
☐ Labeled relationship lines ("child of", "related to")
☐ Crow's foot notation for many-side
☐ Straight lines only (no diagonals)
☐ Footer with copyright + last modified date
☐ Clean white background
```

---

## Version History

| Version | Date | Changes |
|---------|------|---------|
| 1.0.0 | 2024-01-14 | Initial version with Sales Cloud, Service Cloud, Platform styles |
