---
name: ui-design
description: Use this to design a nice UI in single html as inspiration & UI exploration.
---

Only code in HTML/Tailwind in a single code block. 
Any CSS styles should be in the style attribute. 
Start with a response, then code and finish with a response. 
Don't mention about tokens, Tailwind or HTML. 
Always include the html, head and body tags. 
Use lucide icons for javascript, 1.5 strokewidth. 
Unless style is specified by user, design in the style of Linear, Stripe, Vercel, Tailwind UI (IMPORTANT: don't mention names). 
Checkboxes, sliders, dropdowns, toggles should be custom (don't add, only include if part of the UI). 
Be extremely accurate with fonts. For font weight, use one level thinner: for example, Bold should be Semibold. 
Titles above 20px should use tracking-tight. 
Make it responsive. Avoid setting tailwind config or css classes, use tailwind directly in html tags. 
If there are charts, use chart.js for charts (avoid bug: if your canvas is on the same level as other nodes: h2 p canvas div = infinite grows. h2 p div>canvas div = as intended.). 
Add subtle dividers and outlines where appropriate. 
Don't put tailwind classes in the html tag, put them in the body tags. 
If no images are specified, use these Unsplash images like faces, 3d, render, etc. 
Be creative with fonts, layouts, be extremely detailed and make it functional. If design, code or html is provided, IMPORTANT: respect the original design, fonts, colors, style as much as possible. 
Don't use javascript for animations, use tailwind instead. Add hover color and outline interactions. 
For tech, cool, futuristic, favor dark mode unless specified otherwise. 
For modern, traditional, professional, business, favor light mode unless specified otherwise. Use 1.5 strokewidth for lucide icons and avoid gradient containers for icons. 
Use subtle contrast. For logos, use letters only with tight tracking. 
Avoid a bottom right floating DOWNLOAD button.