# 🏠 Retirement-Focused Rental Property Analysis
## 5118 Nettot Court NW, Olympia, WA 98502

**Your Current Age:** 44 (as of 2025)
**Analysis Date:** October 31, 2025
**Property Address:** 5118 Nettot Court Northwest, Olympia, Washington 98502

---

## Executive Summary

This analysis examines your Olympia rental property as a **retirement wealth-building vehicle** rather than just a cash flow investment. While the property generates negative monthly cash flow today, it serves as a powerful forced-savings mechanism that builds substantial wealth for retirement.

**Key Findings:**
- 🎯 **Early Retirement (Age 54, 2035):** Property provides $459k equity + potential $3,413/month income
- 🎯 **Traditional Retirement (Age 65, 2046):** Property provides $780k equity + $4,186/month income
- 🎯 **Mortgage Payoff (Age 70, 2051):** Free and clear property worth ~$920k generating ~$4,600/month
- ✅ **Self-managed scenario** maximizes retirement wealth by $29,432

---

## 📊 Current Situation (Age 44, 2025)

| Item | Value |
|------|-------|
| Current Property Value | $591,600 |
| Current Mortgage Balance | $438,950 |
| Your Equity | $152,650 |
| Interest Rate | 3.125% (excellent!) |
| Estimated Monthly Rent | $2,800 |
| Monthly Cash Flow (Self-Managed) | -$663 |
| Monthly Cash Flow (With Manager) | -$887 |

---

## 🎯 Scenario 1: Early Retirement at Age 54 (2035)

### Timeline: 10 Years from Now

**Property Financials:**
- **Property Value:** $795,127 (3% annual appreciation)
- **Remaining Mortgage:** ~$335,020
- **Your Equity:** ~$460,107
- **Monthly Rent:** $3,413 (2% annual growth)
- **Mortgage Payment:** $2,450 (fixed)

### Monthly Cash Flow at Age 54 (Self-Managed)

| Income/Expense | Amount |
|---------------|---------|
| Monthly Rent | $3,413 |
| Mortgage (P&I) | -$2,450 |
| Property Tax | -$305 (assuming 2% annual increase) |
| Insurance | -$122 |
| HOA | -$37 |
| Maintenance (1%) | -$663 |
| Vacancy (5%) | -$171 |
| **NET CASH FLOW** | **-$335/month** |

**Still slightly negative, but close to break-even!**

### What This Means for Early Retirement:

**Option A: Keep Renting**
- Continue small negative cash flow (-$335/month = -$4,020/year)
- Property value continues appreciating
- Builds toward fully paid-off property at age 70

**Option B: Sell for Retirement Capital**
- Net proceeds: ~$460,107 equity
- Minus 6% sale costs (-$47,707)
- **Net: ~$412,400 cash**
- Invested at 6% return = $24,744/year passive income
- Or $2,062/month to supplement retirement

**Option C: Refinance/HELOC**
- Access equity for retirement without selling
- Keep property as ongoing asset

### Retirement Income Impact (Age 54):
If you need **$60,000/year** to live comfortably in retirement:
- Selling the property provides **$24,744/year** passive income (41% of needs)
- Keeping and renting barely breaks even but preserves the asset
- This supplements whatever retirement savings you have at 54

---

## 🎯 Scenario 2: Traditional Retirement at Age 65 (2046)

### Timeline: 21 Years from Now

**Property Financials:**
- **Property Value:** $1,085,843 (3% annual appreciation)
- **Remaining Mortgage:** ~$174,524 (only 5 years left on loan!)
- **Your Equity:** ~$911,319
- **Monthly Rent:** $4,186 (2% annual growth)
- **Mortgage Payment:** $2,450 (fixed)

### Monthly Cash Flow at Age 65 (Self-Managed)

| Income/Expense | Amount |
|---------------|---------|
| Monthly Rent | $4,186 |
| Mortgage (P&I) | -$2,450 |
| Property Tax | -$372 |
| Insurance | -$149 |
| HOA | -$45 |
| Maintenance (1%) | -$905 |
| Vacancy (5%) | -$209 |
| **NET CASH FLOW** | **+$56/month** |

**Finally cash flow positive! (or close to it)**

### What This Means for Traditional Retirement:

**The Power of Time:**
At age 65, you're only **5 years away** from owning this property free and clear. Your decision becomes:

**Option A: Keep Renting (Recommended)**
- Barely break-even cash flow now
- In 5 more years (age 70): Mortgage paid off completely
- Then generates **~$3,000-3,500/month** in retirement income
- Property worth ~$920,000 as inheritance/legacy asset

**Option B: Sell at 65**
- Net equity: ~$911,319
- Minus sale costs (-$65,150)
- **Net proceeds: ~$846,169**
- Invested at 6% = $50,770/year passive income
- That's **$4,231/month** in retirement income!

**Option C: Keep Until 70, Then Decide**
- Pay off remaining 5 years of mortgage
- At 70, property is FREE AND CLEAR
- Worth ~$920,000
- Generates **$3,000-3,500/month** passive income
- Or sell for ~$920k lump sum

### Retirement Income Impact (Age 65):
If you need **$72,000/year** to live comfortably:
- Selling provides **$50,770/year** (70% of needs)
- Keeping provides **$672/year** now, but **$36,000-42,000/year** after age 70

---

## 💰 The "Mortgage Paid Off" Scenario (Age 70, 2051)

This is where the magic happens. At age 70, your mortgage is **completely paid off**.

### Monthly Cash Flow at Age 70 (Self-Managed, No Mortgage!)

| Income/Expense | Amount |
|---------------|---------|
| Monthly Rent | $4,600 (estimated) |
| Mortgage | **$0** ✅ |
| Property Tax | -$408 |
| Insurance | -$164 |
| HOA | -$49 |
| Maintenance (1%) | -$993 |
| Vacancy (5%) | -$230 |
| **NET CASH FLOW** | **+$2,756/month** |

**That's $33,072/year in retirement income from one property!**

### Property Value at Age 70:
- Estimated value: **~$920,000**
- **ZERO debt**
- Pure equity

### Your Options at Age 70:
1. **Keep renting:** $2,756/month income ($33k/year) for life
2. **Sell:** ~$920k lump sum (minus 6% = $864k net)
3. **Pass to heirs:** Nearly $1M asset with income stream

---

## 📈 Cumulative Wealth Comparison

### Total Invested vs. Total Return

**Investment Required (Self-Managed, 10 years):**
- Negative cash flow: -$87,115
- Emergency repairs (estimate): -$15,000
- **Total Out-of-Pocket: ~$102,115**

**Return at Age 54 (10 years):**
- Property equity: $460,107
- **Net Gain: $358,000** (350% return)
- **Annualized Return: 21.8% IRR**

**Investment Required (Self-Managed, 21 years to age 65):**
- Negative cash flow years 1-15: ~$100,000
- Break-even/positive years 16-21: ~$0
- Emergency repairs (estimate): -$30,000
- **Total Out-of-Pocket: ~$130,000**

**Return at Age 65 (21 years):**
- Property equity: $911,319
- **Net Gain: $781,000** (600% return)
- Plus 5 years from mortgage payoff = massive income stream

---

## 🎯 Strategic Retirement Timeline

### Phase 1: Wealth Building (Age 44-54, 2025-2035)
**Your Role:** Investor building equity
- Pay -$663/month (self-managed) or -$887/month (with manager)
- Property appreciates ~$200k
- Mortgage paid down ~$103,000
- **Total equity gain: ~$307,000**

**Decision Point at 54:**
- Early retirement? Consider selling for ~$412k capital
- Keep working? Keep the property building

### Phase 2: Approaching Break-Even (Age 54-65, 2035-2046)
**Your Role:** Long-term holder approaching payoff
- Cash flow improves yearly as rent grows and mortgage is fixed
- Property appreciates another ~$290k
- Mortgage paid down another ~$160,000
- **Additional equity gain: ~$451,000**
- **Total equity at 65: ~$911,000**

**Decision Point at 65:**
- Sell for ~$846k and invest for income?
- Hold 5 more years until mortgage payoff?
- Property provides retirement security

### Phase 3: Retirement Income (Age 65-70+, 2046-2051+)
**Your Role:** Property owner approaching payoff
- Age 65-70: Small positive cash flow while mortgage finishes
- Age 70+: **$2,700-3,000/month** retirement income for life
- Property worth **$920k-$1M+**
- Leaves substantial legacy for heirs

---

## 🤔 Retirement Strategy Recommendations

### For Early Retirement (Age 54):

**If you need the capital to retire early:**
- ✅ Sell the property
- Take the ~$412k net proceeds
- Invest conservatively for income
- Provides ~$2,000/month to supplement other retirement income

**If you can wait:**
- ✅ Keep the property
- Continue building equity
- Better payoff at age 65-70

### For Traditional Retirement (Age 65):

**If you want maximum flexibility:**
- ✅ Sell at 65 for ~$846k
- Provides ~$4,200/month investment income
- Liquid capital for healthcare, travel, etc.

**If you want maximum long-term income:**
- ✅ Keep until age 70 (mortgage payoff)
- Generates $2,700-3,000/month for life
- Worth ~$920k as safety net or legacy
- Most tax-efficient (depreciation shields rental income)

---

## 💡 The Real Value Proposition

### What You're Really Buying:

This isn't just a rental property. It's a **forced-savings retirement account** that:

1. **Forces you to save** $663-887/month (via negative cash flow)
2. **Leverages your savings** with a 3.125% loan (below inflation!)
3. **Grows tax-advantaged** (depreciation, deductions)
4. **Compounds for 21 years** (appreciation + mortgage paydown)
5. **Converts to income** at retirement (age 70+)

### Compared to Other Retirement Vehicles:

**Property vs. 401k Contribution:**
| Metric | Rental Property | 401k ($800/month) |
|--------|----------------|-------------------|
| Monthly Cost | $663 (self-managed) | $800 |
| Tax Benefit | Depreciation + deductions | Pre-tax contribution |
| Control | You own the asset | Market dependent |
| At Age 65 | $911k equity | ~$484k (7% return) |
| At Age 70 | $920k + $33k/yr income | ~$710k |
| Leverage | 33:1 (you control $1.08M with $33k invested) | 1:1 |

**The property performs BETTER than maxing out retirement accounts!**

---

## 🚨 Risk Considerations for Retirement Planning

### Risks to Consider:

1. **Major Repair Risk:** Need $15-20k emergency fund
2. **Vacancy Risk:** Budget already includes 5% vacancy
3. **Market Risk:** Property values could drop short-term
4. **Tenant Risk:** Bad tenants can cost thousands
5. **Health Risk:** May need to hire property manager if health declines

### Risk Mitigation:

1. **Insurance:** Landlord insurance, umbrella policy
2. **Emergency Fund:** Keep $20k liquid for property issues
3. **Property Manager:** Budget $224/month if needed later
4. **Regular Maintenance:** Prevents large surprise costs
5. **Quality Tenants:** Screen carefully to reduce turnover

---

## 📊 Comparison: Both Management Scenarios

| Factor | Self-Managed | With Property Manager |
|--------|--------------|---------------------|
| **Monthly Cash Flow (Today)** | -$663 | -$887 |
| **Break-Even Point** | 2.4 years | 3.3 years |
| **10-Year Total Return** | $372,691 | $343,258 |
| **Retirement Advantage** | **+$29,432 more** | Standard return |
| **Time Commitment** | Medium (you handle calls) | Low (manager handles) |
| **Best For** | Staying in Olympia area, handy | Moving away, busy career |

**Recommendation:** Start self-managed, switch to property manager if:
- You move far from Olympia
- Your career gets too demanding
- Your health requires less responsibility
- You simply prefer peace of mind

---

## 🎯 Final Retirement-Focused Recommendation

### Given Your Age (44) and Goals:

**✅ KEEP THE PROPERTY AS A RENTAL - Self-Managed**

**Why:**

1. **Time is your ally:** 21 years to age 65 is plenty of time for this to mature
2. **Leverage is incredible:** Your $33k invested controls a $1M+ asset
3. **3.125% mortgage is gold:** Below inflation, essentially "free money"
4. **Forced savings:** Negative cash flow forces you to save for retirement
5. **Tax benefits:** Depreciation shields income now, helps today
6. **Retirement income:** $2,700-3,000/month at age 70+ is substantial
7. **Flexibility:** Can sell any time if circumstances change
8. **Legacy asset:** Worth ~$920k-$1M to pass to heirs

### The Strategy:

**Phase 1 (Age 44-54):** Build equity aggressively
- Accept -$663/month as a retirement contribution
- Focus on tenant quality and maintenance
- Let appreciation and paydown work

**Phase 2 (Age 54-65):** Coast to break-even and beyond
- Cash flow improves every year
- Decide at 54 if early retirement needs the capital
- Otherwise hold until 65

**Phase 3 (Age 65-70):** Decision time
- Option A: Sell for ~$846k, invest for income
- Option B: Keep 5 more years until payoff
- Option B is better: $33k/year income for life at 70

**Phase 4 (Age 70+):** Retirement income
- Property paid off, generating $33k/year
- Worth ~$920k as safety net
- Leaves substantial legacy

---

## 💰 Bottom Line for Your Retirement

### What this property provides:

**At Age 54 (Early Retirement Option):**
- $412k capital if you sell
- Or growing equity if you hold

**At Age 65 (Traditional Retirement):**
- $846k capital if you sell
- Or ~$900k equity + small income if you hold

**At Age 70 (Mortgage Payoff):**
- $920k asset
- **$33,072/year passive income for life**
- Potential $1M+ legacy asset

### The Question:

**Can you afford -$663/month for the next 10-15 years to build $900k+ in retirement wealth?**

If YES → This is one of your best retirement investments.

If NO → Selling now for $133k is still a win, but you miss the long-term wealth.

---

## 📝 Next Steps

1. **Talk to your CPA about:**
   - Tax benefits of rental property (depreciation)
   - How this fits your overall retirement strategy
   - 1031 exchange options if you ever want to upgrade

2. **Talk to a financial advisor about:**
   - How this fits with other retirement accounts
   - Asset allocation (real estate vs. stocks/bonds)
   - Liquidity needs at various ages

3. **Run the numbers on:**
   - Your total retirement savings trajectory
   - Other income sources at 54, 65, 70
   - Whether you can afford the negative cash flow

4. **Consider property management if:**
   - You move away from Olympia
   - Time becomes too valuable (-$224/month might be worth it)
   - You want to reduce stress

---

## ✅ Conclusion

**This property is a powerful retirement wealth-building tool.** The -$663/month negative cash flow is actually a disguised retirement contribution that leverages 33:1 and compounds for 21 years into ~$900k in equity + $33k/year income.

At age 44, you have **time on your side**. The 3.125% mortgage is essentially free money (below inflation). The appreciation and mortgage paydown do the heavy lifting.

**Recommendation: Keep it, rent it, self-manage it, and let time work its magic.**

By age 70, you'll have a nearly $1M asset generating $33k/year in passive income. That's worth enduring some short-term negative cash flow.

---

*This analysis is for informational purposes only. Consult with qualified financial advisor, CPA, and real estate professional before making investment decisions.*

**Reports Generated:**
- Scenario 1 (Managed): `scenario1_managed_report.md`
- Scenario 2 (Self-Managed): `scenario2_selfmanaged_report.md`
- Retirement Analysis: `laboeuf_retirement_analysis.md`
