# Financial Metrics for Rental Property Analysis

This document explains key financial metrics used in rental property analysis in plain language.

## Cash Flow Metrics

### Net Monthly Cash Flow
**What it is:** The amount of money left over (or lost) each month after all expenses are paid.

**Formula:** Monthly Rent - All Monthly Expenses

**What it means:**
- **Positive cash flow**: You make money each month (good!)
- **Negative cash flow**: You lose money each month (may still be okay if property appreciates)

**Example:** If rent is $2,500 and expenses total $2,200, net cash flow is $300/month.

### Net Operating Income (NOI)
**What it is:** Annual income from the property minus operating expenses (but NOT including mortgage payments).

**Formula:** Annual Gross Rent - Operating Expenses (no mortgage)

**Why it matters:** Shows how much the property itself generates, regardless of how it's financed.

## Return Metrics

### Cap Rate (Capitalization Rate)
**What it is:** The rate of return based on the property's value, ignoring financing.

**Formula:** (Annual NOI ÷ Property Value) × 100

**What's good:**
- 4-6%: Low but stable (good neighborhoods)
- 7-10%: Good return
- 10%+: High return (but may be higher risk)

**Example:** If NOI is $15,000 and property value is $300,000, cap rate is 5%.

**When to use:** Comparing properties of different values.

### Cash-on-Cash Return (CoC)
**What it is:** Annual return on the actual cash you invested (down payment + closing costs).

**Formula:** (Annual Cash Flow ÷ Total Cash Invested) × 100

**What's good:**
- 8-12%: Good return
- 12%+: Excellent return
- Below 5%: May not be worth the effort

**Example:** If you invested $90,000 and get $7,200/year in cash flow, CoC is 8%.

**When to use:** Understanding return on YOUR money (not borrowed money).

### Internal Rate of Return (IRR)
**What it is:** The average annual return over the entire investment period, accounting for time value of money.

**What's included:**
- All monthly cash flows
- Property appreciation
- Sale proceeds at the end

**What's good:**
- 10-15%: Good
- 15%+: Excellent
- Below 8%: Consider other investments

**When to use:** Comparing different investment opportunities over time.

### Net Present Value (NPV)
**What it is:** Today's value of all future cash flows, discounted by your required rate of return.

**What it means:**
- **Positive NPV**: Investment is worthwhile
- **Negative NPV**: You'd be better off investing elsewhere
- **Higher NPV**: Better investment

**Example:** If NPV is $50,000, the investment will generate $50,000 more than your alternative investment.

**When to use:** Deciding if an investment meets your minimum return requirements.

## Time Metrics

### Break-Even Point
**What it is:** How long until your cumulative returns equal your initial investment.

**What's included:**
- Monthly cash flow (positive or negative)
- Property appreciation
- Initial investment (down payment + closing costs)

**What's good:**
- Under 5 years: Excellent
- 5-10 years: Good
- 10+ years: Consider carefully

**When to use:** Understanding investment timeline and risk.

### Payback Period
**What it is:** How long until positive cash flow covers your initial investment.

**Difference from break-even:** Doesn't include appreciation, only cash flow.

**When to use:** Conservative analysis focusing on cash-only returns.

## Rent vs. Sell Comparison Metrics

### Capital Gains
**What it is:** The profit from selling the property (sale price - original purchase price).

**Tax considerations:**
- Primary residence: First $250k ($500k married) tax-free
- Investment property: Taxed as capital gains (15-20% federal)
- Depreciation recapture: Additional tax on claimed depreciation

### Total Return
**What it is:** Combined return from all sources:
- Rental cash flow
- Property appreciation
- Mortgage paydown
- Tax benefits

**When to use:** Comprehensive comparison between renting and selling.

## Cost Components

### Operating Expenses
**What's included:**
- Property taxes
- Insurance
- HOA fees
- Maintenance (typically 1% of property value/year)
- Property management (typically 8-10% of rent)
- Vacancy allowance (typically 5-8% of rent)

**What's NOT included:**
- Mortgage payments
- Capital improvements

### Sale Costs
**What's typically included:**
- Real estate commission (5-6%)
- Transfer taxes
- Title insurance
- Closing costs
- Repairs for sale

**Rule of thumb:** Budget 6-8% of sale price for all costs.

## Tax Considerations (Simplified)

### Rental Income Taxation
- Rental income is taxable
- Operating expenses are deductible
- Mortgage interest is deductible
- Depreciation is deductible (but must be recaptured on sale)

### Capital Gains Taxation
- **Short-term** (< 1 year): Taxed as ordinary income
- **Long-term** (> 1 year): Taxed at 0%, 15%, or 20% depending on income
- **Primary residence exemption**: Up to $250k ($500k married) tax-free

### Important Note
Tax laws are complex and vary by situation. Always consult a CPA for tax advice.

## Risk Factors

### Factors That Can Impact Returns
1. **Vacancy**: Empty property means no rent
2. **Maintenance surprises**: Roof, HVAC, plumbing can be expensive
3. **Market changes**: Property values and rents can decrease
4. **Interest rate changes**: If you have adjustable rate mortgage
5. **Tenant issues**: Late payments, damage, eviction costs
6. **Property tax increases**: Can significantly impact cash flow
7. **HOA special assessments**: Unexpected large expenses

### Risk Mitigation
- Maintain cash reserves (6-12 months expenses)
- Get proper insurance
- Screen tenants thoroughly
- Budget conservatively
- Diversify investments

## Decision Framework

### When to Rent
- Positive or near-positive cash flow
- Good cap rate (4%+) and CoC (8%+)
- Strong rental market
- Don't need immediate cash
- Want tax benefits and long-term wealth building

### When to Sell
- Significant appreciation allows large profit
- Need cash for other opportunities
- Negative cash flow with poor outlook
- Market is at peak
- Property requires major repairs
- Don't want landlord responsibilities

### Questions to Ask
1. Can I afford negative cash flow if it happens?
2. Do I have 6-12 months expenses in reserve?
3. Am I prepared to be a landlord?
4. Is the local rental market strong?
5. Are there better investment opportunities?
6. What's my investment timeline?
7. What are my tax implications?

## Resources

### Further Learning
- BiggerPockets.com - Real estate investing community
- IRS Publication 527 - Residential Rental Property
- Local real estate investment clubs
- Qualified CPA specializing in real estate
- Real estate attorney for legal questions

### Tools
- Rental property calculators
- Local market rent data (Zillow, Rentometer)
- Property tax records
- Comparative market analysis (CMA) from agent
