# 🏠 Rental Property Analysis Report

**Property Address:** 5118 Nettot Court Northwest, Olympia, Washington 98502
**Analysis Date:** 2025-10-31
**Desired Start Date:** 2025-03-01

## 📊 Property Overview

| Item | Value |
|------|-------|
| Purchase Price | $510,000 |
| Purchase Year | 2021 |
| Current Value (Est.) | $591,600 |
| Current Mortgage | $438,950 |
| Interest Rate | 3.125% |
| Estimated Monthly Rent | $2,800 |

## 💰 Monthly Cash Flow Analysis

### Income
- **Gross Monthly Rent:** $2,800.00

### Expenses
- **Mortgage:** $2,450.00
- **Property Tax:** $250.00
- **Insurance:** $100.00
- **Hoa:** $30.00
- **Maintenance:** $493.00
- **Management:** $0.00
- **Vacancy:** $140.00

**Total Monthly Expenses:** $3,463.00

🔴 **Net Monthly Cash Flow:** $-663.00

## 📈 Key Financial Metrics

| Metric | Value | What It Means |
|--------|-------|---------------|
| Cap Rate | 3.62% | Annual return based on property value (good: 4-10%) |
| Cash-on-Cash Return | -34.15% | Annual return on your invested cash (good: 8-12%) |
| Internal Rate of Return (IRR) | 21.80% | Average annual return over 10 years |
| Net Present Value (NPV) | $-7,004.87 | Today's value of all future returns |

### Understanding These Metrics

- **Cap Rate**: Higher is better. Compares property income to its value.
- **Cash-on-Cash Return**: Shows return on actual money invested (not borrowed).
- **IRR**: Accounts for time value of money. Higher means better investment.
- **NPV**: Positive means investment is worthwhile at your discount rate.

## ⏱️ Break-Even Analysis

Property breaks even after 29 months (2.4 years)

- **Time to Break Even:** 29 months (2.4 years)
- This includes monthly cash flow AND property appreciation

## 🤔 Rent vs. Sell Comparison

### Selling Now
- Current Property Value: $609,348
- Sale Costs (6%): $36,561
- Remaining Mortgage: $438,950
- Capital Gains Tax (Est.): $0
- **Net Proceeds:** $133,837.12

### Renting for 10 Years
- Total Rental Cash Flow: $-87,115.98
- Equity After 10 Years: $459,807.79
- **Total Return:** $372,691.81
- Internal Rate of Return: 21.80%
- Net Present Value: $-7,004.87

✅ **Recommendation:** RENT
- Renting provides $238,854.69 more value over 10 years

## 📝 Assumptions Used

- Property appreciation: 3% per year
- Rent growth: 2% per year
- Vacancy rate: 5%
- Management fee: 0%
- Maintenance: 1.0% of property value per year
- Hold period: 10 years

### Data Sources

- **Property details**: User-provided configuration file
- **Financial calculations**: Industry-standard formulas for real estate analysis
- **Market assumptions**: Based on national averages (should be verified with local data)
- **Rental estimate**: User-provided value (not verified with market data)

**Recommended verification sources:**
- Rental comps: Zillow, Redfin, Rentometer, local property management companies
- Property values: Recent comparable sales, professional appraisal
- Tax rates: County assessor's office
- Insurance rates: Multiple insurance quotes
- Market trends: Local MLS data, real estate market reports

---
*This analysis is for informational purposes only and should not be considered financial advice.*
*Consult with a qualified financial advisor, CPA, and real estate professional before making investment decisions.*