# Clinical Case Report Template

## Title

[Insert descriptive title that includes "Case Report" or "Case Study" and indicates the clinical focus]

Example: Unusual Presentation of Acute Appendicitis in an Elderly Patient: A Case Report

## Author Information

[Author names, affiliations, ORCID IDs]

**Corresponding Author:**  
[Name]  
[Email]  
[Institution]

## Keywords

[2-5 keywords, preferably MeSH terms]

Example: Appendicitis, Atypical presentation, Elderly, Diagnostic imaging

## Abstract

### Introduction
[What is unique about this case? Why is it worth reporting? 1-2 sentences]

### Patient Concerns
[Primary symptoms and chief complaint]

### Diagnosis
[Final diagnosis, how it was reached]

### Interventions
[Key treatments provided]

### Outcomes
[Clinical outcome and follow-up status]

### Lessons
[Main takeaway messages for clinicians]

**Word count:** [150-250 words]

## Introduction

[Background information - 2-4 paragraphs]

**Paragraph 1:** Background on the condition
- Epidemiology of the condition
- Typical clinical presentation
- Standard diagnostic approach
- Current treatment guidelines

**Paragraph 2:** Why this case is novel
- What makes this case unusual or important
- Gap in medical knowledge addressed
- Literature review showing rarity or uniqueness
- Clinical significance

**Paragraph 3:** Objectives
- Purpose of reporting this case
- Learning points to be highlighted

## Patient Information

**Demographics:**
- Age: [e.g., "A 72-year-old" or "A woman in her 70s"]
- Sex: [Male/Female]
- Ethnicity: [if relevant to case]
- Occupation: [if relevant]

**Medical History:**
- Past medical history: [chronic conditions]
- Past surgical history: [prior surgeries]
- Family history: [relevant family history]
- Social history: [tobacco, alcohol, occupation, living situation]

**Medications:**
- Current medications: [list with doses]
- Allergies: [drug allergies and reactions]

**Presenting Symptoms:**
- Chief complaint: ["Patient's words" or clinical presentation]
- Duration of symptoms
- Severity and characteristics
- Associated symptoms
- Relevant review of systems

## Clinical Findings

**Physical Examination:**
- Vital signs: [T, BP, HR, RR, SpO2]
- General appearance: [overall state]
- Systematic examination by organ system:
  - HEENT: [findings]
  - Cardiovascular: [findings]
  - Respiratory: [findings]
  - Abdomen: [findings]
  - Neurological: [findings]
  - Other relevant systems: [findings]

**Pertinent Negatives:**
[Important negative findings]

## Timeline

| Date/Time | Event |
|-----------|-------|
| [Day -X or Date] | [Initial symptom onset] |
| [Day 0 or Date] | [Presentation to healthcare] |
| [Day 0 or Date] | [Initial evaluation and tests] |
| [Day X or Date] | [Diagnosis confirmed] |
| [Day X or Date] | [Treatment initiated] |
| [Day X or Date] | [Hospital discharge or follow-up] |
| [Month X or Date] | [Long-term follow-up] |

*Note: Use relative days (Day 0, Day 1) or approximate dates (Month 1, Month 3) to protect patient privacy*

## Diagnostic Assessment

### Initial Diagnostic Workup

**Laboratory Tests:**
| Test | Result | Reference Range | Interpretation |
|------|--------|----------------|----------------|
| [Test name] | [Value with units] | [Normal range] | [High/Low/Normal] |

**Imaging Studies:**
- [Modality] ([Date]): [Key findings]
- [Include images if applicable, with labels and arrows pointing to key findings]

**Other Diagnostic Procedures:**
- [Procedure name] ([Date]): [Findings]

### Differential Diagnosis

**Diagnoses Considered:**
1. [Primary differential]
   - Supporting evidence:
   - Evidence against:
2. [Alternative diagnosis]
   - Supporting evidence:
   - Evidence against:
3. [Additional differentials as appropriate]

### Diagnostic Challenges

[Describe any difficulties in reaching the diagnosis]
- Atypical presentation
- Misleading initial findings
- Diagnostic delays
- Complex decision-making

### Final Diagnosis

**Confirmed Diagnosis:** [Final diagnosis with ICD-10 code if applicable]

**Diagnostic Reasoning:**
[Explain how diagnosis was reached, key diagnostic features, confirmatory tests]

## Therapeutic Intervention

### Treatment Approach

**Initial Management:**
- [Immediate interventions]
- [Supportive care]
- [Monitoring]

**Definitive Treatment:**
1. **Pharmacological Interventions:**
   - [Drug name]: [Dose, route, frequency, duration]
   - Indication: [Why prescribed]
   - Response: [Patient response to treatment]

2. **Procedural/Surgical Interventions:**
   - [Procedure name] performed on [date/day]
   - Indication: [Why performed]
   - Technique: [Brief description]
   - Findings: [Intraoperative or procedural findings]
   - Complications: [Any complications or none]

3. **Other Interventions:**
   - [Physical therapy, dietary modifications, etc.]

**Alternative Treatments Considered:**
[Other treatment options that were considered and why they were not pursued]

**Changes to Interventions:**
[Any modifications to treatment plan]
- Date of change:
- Reason for change:
- New intervention:

## Follow-up and Outcomes

**Immediate Outcome:**
[Outcome during hospitalization or initial treatment period]
- Clinical response:
- Laboratory or imaging follow-up:
- Complications:
- Length of hospitalization (if applicable):

**Short-term Follow-up:** ([Timeframe, e.g., 1 month])
- Clinical status:
- Follow-up tests:
- Adherence to treatment:
- Any issues or concerns:

**Long-term Follow-up:** ([Timeframe, e.g., 6 months, 1 year])
- Clinical status:
- Recovery or resolution:
- Functional status:
- Quality of life:
- Recurrence or complications:

**Patient-Reported Outcomes:**
[Symptoms, quality of life, patient satisfaction]

## Discussion

**Paragraph 1: Summary and Significance**
[Briefly summarize the case and state its significance]

**Paragraph 2: Literature Review**
[Review similar cases in the literature]
- Number of similar cases reported
- Comparison to this case
- What is novel about this case
- [Cite relevant references]

**Paragraph 3: Clinical Implications**
[What can clinicians learn from this case?]
- Recognition of atypical presentations
- Diagnostic pearls
- Treatment considerations
- When to consider this diagnosis

**Paragraph 4: Pathophysiology or Mechanism (if applicable)**
[Explain underlying mechanism, why this occurred, contributing factors]

**Paragraph 5: Strengths and Limitations**
[Acknowledge limitations of case report]
- Single case report limitations
- Cannot establish causation
- Generalizability concerns
- Strengths of comprehensive evaluation

**Paragraph 6: Future Directions**
[Unanswered questions, areas for future research]

## Learning Points

- [Point 1: Concise, actionable clinical lesson]
- [Point 2: Key diagnostic or treatment pearl]
- [Point 3: When to consider this diagnosis]
- [Point 4: (optional) Additional takeaway]

## Patient Perspective

[Optional but encouraged: Patient's own description of experience, in their own words if possible]

"[Patient quote describing their experience, symptoms, treatment, or outcome]"

[Or narrative description of patient's perspective, impact on quality of life, satisfaction with care]

## Informed Consent

Written informed consent was obtained from the patient for publication of this case report and any accompanying images. A copy of the written consent is available for review by the Editor-in-Chief of this journal on request.

[OR if patient deceased/unable to consent:]

Written informed consent was obtained from the patient's next of kin for publication of this case report, as the patient was deceased [or unable to provide consent due to...] at the time of manuscript preparation.

## Conflicts of Interest

The authors declare that they have no conflicts of interest.

## Funding

This case report received no specific grant from any funding agency in the public, commercial, or not-for-profit sectors.

[OR: This work was supported by [funding source and grant number]]

## Acknowledgments

[Acknowledge contributors who do not meet authorship criteria, providers who cared for patient, etc.]

## References

[Format according to journal requirements - typically AMA, Vancouver, or APA]

1. [First reference - Author(s). Title. Journal. Year;Volume(Issue):Pages.]
2. [Second reference...]

---

## CARE Checklist Completion

Use the CARE checklist to ensure all required elements are included:

- [ ] Title includes "case report"
- [ ] Keywords provided (2-5)
- [ ] Structured/unstructured abstract
- [ ] Introduction with background and novelty
- [ ] Patient demographics (de-identified)
- [ ] Clinical findings
- [ ] Timeline
- [ ] Diagnostic assessment
- [ ] Therapeutic interventions
- [ ] Follow-up and outcomes
- [ ] Discussion with literature review
- [ ] Patient perspective (if possible)
- [ ] Informed consent statement
- [ ] All 18 HIPAA identifiers removed
- [ ] References formatted correctly
- [ ] Figures/tables labeled and referenced
- [ ] Word count within journal limits

---

## De-identification Checklist

Verify all HIPAA identifiers removed:

- [ ] Names (patient, family, providers)
- [ ] Geographic locations smaller than state
- [ ] Exact dates (use year only or relative time)
- [ ] Phone numbers
- [ ] Email addresses
- [ ] Medical record numbers
- [ ] Account numbers
- [ ] License numbers
- [ ] Device serial numbers
- [ ] URLs
- [ ] IP addresses
- [ ] Biometric identifiers
- [ ] Full-face photos (cropped or blurred)
- [ ] Any other identifying information

---

**Notes:**
- Adapt this template to your specific journal's requirements
- Check word count limits (typically 1500-3000 words)
- Follow journal's reference style
- Include institutional review/ethics exemption if applicable
- Consider attaching CARE checklist when submitting


