# Diagnostic Reports Standards

## Radiology Reporting Standards

### American College of Radiology (ACR) Guidelines

The ACR provides comprehensive practice parameters for diagnostic imaging reporting to ensure quality, consistency, and communication effectiveness.

#### Core Radiology Report Components

**1. Patient Demographics**
- Patient name and/or unique identifier
- Date of birth or age
- Sex
- Medical record number
- Examination date and time
- Referring physician

**2. Procedure/Examination**
- Specific examination performed
- Anatomical region
- Laterality (right, left, bilateral)
- Technique and protocol
- Example: "MRI Brain without and with Contrast"

**3. Clinical Indication**
- Reason for examination
- Relevant clinical history
- Specific clinical question
- ICD-10 codes (when required)
- Example: "Headache and visual disturbances. Rule out intracranial mass."

**4. Comparison**
- Prior relevant imaging studies
- Dates of prior studies
- Modality of prior studies
- Availability for comparison
- Example: "Comparison: CT head without contrast from 6 months prior (January 15, 2023)"

**5. Technique**
- Imaging parameters and protocol
- Contrast administration details:
  - Type (iodinated, gadolinium)
  - Route (IV, oral, rectal)
  - Volume administered
  - Timing of imaging
- Technical quality statement
- Radiation dose (for CT)
- Limitations or technical issues
- Example:
  ```
  Technique: Multiplanar T1 and T2-weighted sequences were obtained through
  the brain without and with IV contrast. 15 mL of gadolinium-based contrast
  agent was administered intravenously. Technical quality is adequate.
  ```

**6. Findings**
- Systematic description of imaging findings
- Organized by anatomical region or organ system
- Measurements of abnormalities (size, volume)
- Specific descriptive terminology
- Pertinent positive findings
- Relevant negative findings
- Comparison to prior studies when available

**Organization approaches:**
- Organ-by-organ (for abdomen/pelvis)
- Region-by-region (for chest)
- System-by-system (for spine)
- Compartment-by-compartment (for musculoskeletal)

**7. Impression/Conclusion**
- Summary of key findings
- Diagnosis or differential diagnosis
- Answers to clinical question
- Level of concern or urgency
- Comparison to prior (improved, stable, worsened)
- Recommendations for further imaging or clinical management
- Clear and concise (often numbered list)

Example:
```
IMPRESSION:
1. 3.2 cm enhancing mass in the right frontal lobe with surrounding vasogenic
   edema, most consistent with high-grade glioma. Metastasis cannot be excluded.
   Clinical correlation and tissue sampling recommended.
2. No acute intracranial hemorrhage or herniation.
3. Recommend neurosurgical consultation.
```

**8. Critical Results Communication**
- Urgent or unexpected findings requiring immediate action
- Direct communication to ordering provider documented
- Time, date, and recipient of verbal communication
- Example: "Critical result: Acute pulmonary embolism. Dr. Smith paged at 14:35 on [date]."

### Structured Reporting Systems

#### Lung-RADS (Lung CT Screening Reporting and Data System)

Used for lung cancer screening CT interpretation.

**Categories:**
- **Lung-RADS 0**: Incomplete - additional imaging needed
- **Lung-RADS 1**: Negative - no nodules, definitely benign nodules
- **Lung-RADS 2**: Benign appearance or behavior - nodules with very low likelihood of malignancy
- **Lung-RADS 3**: Probably benign - short-interval follow-up suggested
- **Lung-RADS 4A**: Suspicious - 3-month follow-up or PET/CT
- **Lung-RADS 4B**: Very suspicious - 3-month follow-up or PET/CT, consider biopsy
- **Lung-RADS 4X**: Very suspicious with additional features, consider biopsy

**Management recommendations included for each category**

#### BI-RADS (Breast Imaging Reporting and Data System)

Standardized lexicon for breast imaging (mammography, ultrasound, MRI).

**Categories:**
- **BI-RADS 0**: Incomplete - need additional imaging
- **BI-RADS 1**: Negative - no abnormalities
- **BI-RADS 2**: Benign findings
- **BI-RADS 3**: Probably benign - short-interval follow-up (6 months)
- **BI-RADS 4**: Suspicious - biopsy recommended
  - 4A: Low suspicion
  - 4B: Moderate suspicion
  - 4C: High suspicion
- **BI-RADS 5**: Highly suggestive of malignancy - biopsy recommended
- **BI-RADS 6**: Known biopsy-proven malignancy

**Descriptors:**
- Mass: Shape, margin, density
- Calcifications: Morphology, distribution
- Asymmetry: Type and characteristics
- Associated features

#### LI-RADS (Liver Imaging Reporting and Data System)

For reporting liver observations in patients at risk for hepatocellular carcinoma.

**Categories:**
- **LI-RADS 1**: Definitely benign
- **LI-RADS 2**: Probably benign
- **LI-RADS 3**: Intermediate probability of malignancy
- **LI-RADS 4**: Probably HCC
- **LI-RADS 5**: Definitely HCC
- **LI-RADS M**: Probably or definitely malignant, not HCC-specific
- **LI-RADS TIV**: Tumor in vein

**Major features assessed:**
- Size
- Enhancement pattern (arterial phase hyperenhancement, washout)
- Capsule appearance
- Threshold growth

#### PI-RADS (Prostate Imaging Reporting and Data System)

For multiparametric MRI of the prostate.

**Assessment categories:**
- **PI-RADS 1**: Very low - clinically significant cancer highly unlikely
- **PI-RADS 2**: Low - clinically significant cancer unlikely
- **PI-RADS 3**: Intermediate - equivocal
- **PI-RADS 4**: High - clinically significant cancer likely
- **PI-RADS 5**: Very high - clinically significant cancer highly likely

**Evaluation:**
- Peripheral zone: DWI/ADC primary determinant
- Transition zone: T2-weighted primary determinant
- DCE (dynamic contrast-enhanced): Used for PI-RADS 3 lesions in peripheral zone

### RadLex and Standardized Terminology

**RadLex** is a comprehensive lexicon for radiology developed by the Radiological Society of North America (RSNA).

**Benefits:**
- Standardized terminology
- Improved communication
- Enables data mining and analytics
- Facilitates decision support systems
- Consistent report structure

**Common RadLex terms:**
- Anatomical structures
- Imaging observations
- Disease entities
- Procedures

### Radiological Measurements

**Linear measurements:**
- Use bidimensional (length × width) or tridimensional (length × width × height)
- Report largest dimension for nodules/masses
- Consistent measurement methodology for follow-up
- Perpendicular measurements when possible

**Volumetric measurements:**
- More accurate for follow-up of irregular lesions
- Automated or semi-automated software
- Particularly useful for lung nodules

**Response assessment:**
- RECIST 1.1 (Response Evaluation Criteria in Solid Tumors)
  - Target lesions: sum of longest diameters (maximum 5 lesions, 2 per organ)
  - Complete response, partial response, stable disease, progressive disease

## Pathology Reporting Standards

### College of American Pathologists (CAP) Protocols

CAP cancer protocols provide standardized synoptic reporting templates for cancer specimens.

#### Synoptic Reporting Elements

**Core elements for all cancer specimens:**

**1. Specimen Information**
- Procedure type (biopsy, excision, resection)
- Specimen laterality
- Specimen integrity and adequacy

**2. Tumor Site**
- Anatomical site and subsite
- Precise location within organ

**3. Tumor Size**
- Greatest dimension in cm
- Additional dimensions if 3D measurement relevant
- Method of measurement (gross vs. microscopic)

**4. Histologic Type**
- WHO classification
- Specific subtype
- Percentage of each component in mixed tumors

**5. Histologic Grade**
- Grading system used (e.g., Nottingham, Fuhrman, Gleason)
- Grade category (well, moderately, poorly differentiated OR G1, G2, G3)
- Individual component scores if applicable

**6. Extent of Invasion**
- Depth of invasion (measured in mm)
- Involvement of adjacent structures
- Lymphovascular invasion (present/not identified)
- Perineural invasion (present/not identified)

**7. Margins**
- Closest margin distance
- Margin status for each margin assessed (negative/positive)
- Specific margin(s) involved if positive

**8. Lymph Nodes**
- Number of lymph nodes examined
- Number of lymph nodes with metastasis
- Size of largest metastatic deposit
- Extranodal extension (present/absent)

**9. Pathologic Stage (pTNM)**
- pT: Primary tumor extent
- pN: Regional lymph nodes
- pM: Distant metastasis (if known)
- AJCC Cancer Staging Manual edition used

**10. Additional Findings**
- Treatment effect (if post-neoadjuvant therapy)
- Associated lesions (dysplasia, carcinoma in situ)
- Background tissue (cirrhosis, inflammation)

**11. Ancillary Studies**
- Immunohistochemistry results
- Molecular/genetic testing results
- Biomarker status (e.g., ER, PR, HER2 for breast; MSI for colon)
- FISH or other cytogenetic results

#### Organ-Specific CAP Protocols

**Breast Cancer:**
- Histologic type (invasive ductal, lobular, special types)
- Nottingham grade (tubule formation, nuclear pleomorphism, mitotic count)
- ER/PR status (percentage and intensity)
- HER2 status (IHC score, FISH if needed)
- Ki-67 proliferation index
- DCIS component (if present)
- Response to neoadjuvant therapy (residual cancer burden)

**Colorectal Cancer:**
- Histologic type (adenocarcinoma, mucinous, etc.)
- Grade
- Depth of invasion (into submucosa, muscularis propria, pericolic tissue, etc.)
- Tumor deposits
- Lymph nodes (number positive/total examined)
- Margins (proximal, distal, radial/circumferential)
- MSI/MMR status
- KRAS, NRAS, BRAF mutations

**Prostate Cancer:**
- Gleason score (primary + secondary pattern)
- Grade group (1-5)
- Percentage of tissue involved
- Extraprostatic extension
- Seminal vesicle invasion
- Surgical margin status
- Lymph nodes if sampled

**Lung Cancer:**
- Histologic type (adenocarcinoma, squamous, small cell, etc.)
- Grade (for NSCLC)
- Invasion depth
- Visceral pleural invasion
- Distance to margins
- Lymph nodes
- Molecular markers (EGFR, ALK, ROS1, PD-L1)

### Gross Pathology Description

**Essential elements:**
- Specimen labeling and identification
- Type of specimen
- Dimensions and weight
- Orientation markers (if present)
- External surface description
- Cut surface appearance
- Lesion description:
  - Size (3 dimensions)
  - Location
  - Color
  - Consistency
  - Borders (well-circumscribed, infiltrative)
  - Distance to margins
- Sampling approach (how tissue was sectioned and submitted)

**Example:**
```
GROSS DESCRIPTION:
Received fresh, labeled with patient name and "left breast, lumpectomy" is an
oriented lumpectomy specimen measuring 8.5 x 6.0 x 4.0 cm, with a suture
indicating superior margin. Inking: superior - blue, inferior - black, medial -
green, lateral - red, anterior - orange, posterior - yellow. Serially sectioned
to reveal a firm, gray-white mass measuring 2.1 x 1.8 x 1.5 cm, located 2.5 cm
from superior, 3.0 cm from inferior, 2.0 cm from medial, 3.5 cm from lateral,
1.5 cm from anterior, and 1.8 cm from posterior margins. Representative sections
submitted as follows: A1-A3 tumor, A4 superior margin, A5 medial margin, A6
posterior margin.
```

### Microscopic Description

**Key elements:**
- Architectural pattern
- Cellular characteristics
  - Cell type
  - Nuclear features (size, shape, chromatin, nucleoli)
  - Cytoplasmic features
  - Mitotic activity
- Degree of differentiation
- Invasion pattern
- Special features (necrosis, hemorrhage, calcification)
- Stroma and background tissue
- Lymphovascular or perineural invasion
- Margins (distance and status)
- Lymph nodes (description of metastases)

### Frozen Section Reporting

**Indications:**
- Intraoperative diagnosis
- Margin assessment
- Lymph node evaluation
- Tissue triage

**Report format:**
- "Frozen section diagnosis" clearly labeled
- Intraoperative consultation note
- Time of frozen section
- Specimen description
- Frozen section diagnosis
- Note: "Permanent sections to follow"

**Frozen section disclaimers:**
- Limited by frozen artifact
- Final diagnosis on permanent sections
- Defer to permanent sections for definitive diagnosis

### Diagnostic Certainty Language

**Definitive:**
- "Consistent with..."
- "Diagnostic of..."
- "Positive for..."

**Probable:**
- "Consistent with..."
- "Favor..."
- "Most likely..."

**Possible:**
- "Suggestive of..."
- "Cannot exclude..."
- "Differential diagnosis includes..."

**Defer:**
- "Defer to..."
- "Recommend..."
- "Additional studies pending..."

## Laboratory Reporting Standards

### Clinical Laboratory Standards Institute (CLSI) Guidelines

CLSI provides standards for laboratory testing and reporting.

#### Laboratory Report Components

**1. Patient Demographics**
- Patient name and identifier
- Date of birth or age
- Sex
- Ordering provider

**2. Specimen Information**
- Specimen type (blood, serum, plasma, urine, CSF, etc.)
- Collection date and time
- Received date and time
- Specimen condition
- Fasting status (if relevant)

**3. Test Information**
- Test name (full, not just abbreviation)
- Test code
- Methodology
- Accession or specimen number

**4. Results**
- Quantitative value with units
- Qualitative result (positive/negative, detected/not detected)
- Reference range or interval
- Flags for abnormal results
  - H = High
  - L = Low
  - Critical or panic values highlighted

**5. Reference Intervals**
- Age-specific
- Sex-specific
- Population-specific (when relevant)
- Method-specific
- Units clearly stated

**Example:**
```
Test: Hemoglobin A1c
Result: 8.2%  (H)
Reference Range: 4.0-5.6% (non-diabetic)
Method: HPLC
Interpretation: Consistent with poorly controlled diabetes
```

**6. Interpretative Comments**
- When result requires context
- Suggests additional testing
- Explains interferences or limitations
- Provides clinical guidance

**7. Quality Control**
- Delta checks (comparison to prior values)
- Critical values and read-back procedure
- Specimen quality issues (hemolysis, lipemia, icterus)
- Dilutions performed
- Repeat testing if needed

### LOINC (Logical Observation Identifiers Names and Codes)

Standard coding system for laboratory and clinical observations.

**LOINC code components:**
- Component (analyte measured)
- Property (mass, substance concentration, etc.)
- Timing (point in time, 24-hour)
- System (specimen type)
- Scale (quantitative, ordinal, nominal)
- Method (when relevant)

**Example:**
- Hemoglobin A1c in Blood: 4548-4
- Glucose in Serum/Plasma: 2345-7
- Creatinine in Serum/Plasma: 2160-0

### Critical Value Reporting

**Definition:** Results that indicate life-threatening conditions requiring immediate clinical action.

**Critical value examples:**
- Glucose: <40 mg/dL or >500 mg/dL
- Potassium: <2.5 mEq/L or >6.5 mEq/L
- Sodium: <120 mEq/L or >160 mEq/L
- Calcium: <6.0 mg/dL or >13.0 mg/dL
- WBC: <1.0 × 10³/μL or >50 × 10³/μL
- Hemoglobin: <5.0 g/dL
- Platelets: <20 × 10³/μL
- INR: >5.0 (on warfarin)
- Positive blood culture
- Positive CSF culture or gram stain

**Critical value procedure:**
1. Result identified by laboratory
2. Immediate contact with ordering provider or designee
3. Read-back verification
4. Documentation:
   - Date and time
   - Person contacted
   - Person receiving notification
   - Test and result
5. Follow facility policy for unable to reach provider

### Microbiology Reporting

**Culture reports:**
- Specimen type and source
- Organisms identified
- Quantity (light, moderate, heavy growth)
- Antimicrobial susceptibility results
- Interpretation (susceptible, intermediate, resistant)
- MIC values when applicable

**Gram stain reports:**
- Bacteria present (Gram-positive/negative, morphology)
- Quantity and cellular context
- WBCs or other cells present

**Preliminary reports:**
- Issued before final identification
- Clearly labeled "PRELIMINARY"
- Final report to follow

**Final reports:**
- Definitive organism identification
- Complete susceptibility panel
- Interpretative comments

### Molecular Pathology/Genomics Reporting

**Components:**
- Gene(s) tested
- Variant(s) detected
- Classification (pathogenic, likely pathogenic, VUS, likely benign, benign)
- Allele frequency
- Methodology (NGS, Sanger sequencing, PCR, etc.)
- Reference sequence
- Clinical significance and interpretation
- Recommendations (treatment implications, family testing)
- Limitations of testing

**Example:**
```
Test: BRCA1/BRCA2 Full Gene Sequencing
Result: PATHOGENIC VARIANT DETECTED
Gene: BRCA1
Variant: c.68_69delAG (p.Glu23ValfsTer17)
Classification: Pathogenic
Interpretation: This variant is associated with increased risk of breast and
ovarian cancer. Genetic counseling and risk-reducing strategies recommended.
Family testing should be considered.
```

### Point-of-Care Testing (POCT)

**Requirements:**
- Same quality standards as central laboratory
- Operator competency documentation
- Quality control documentation
- Maintenance records
- Result documentation in medical record

**Common POCT:**
- Blood glucose
- Hemoglobin/hematocrit
- INR
- Blood gas
- Pregnancy test
- Urinalysis
- Rapid strep
- Influenza

## Quality Indicators for Diagnostic Reports

### Radiology Quality Metrics

- Report turnaround time (routine vs. urgent)
- Critical result communication time
- Report error rates
- Addendum rate
- Referring physician satisfaction

**Benchmarks:**
- Routine reports: <24 hours
- Urgent reports: <4 hours
- STAT reports: <1 hour
- Critical findings: Immediate verbal communication

### Pathology Quality Metrics

- Turnaround time (TAT) for different specimen types
- Frozen section accuracy
- Amendment rate
- Specimen adequacy rate
- Immunohistochemistry QC

**TAT benchmarks:**
- Surgical pathology routine: 2-3 days
- Surgical pathology complex: 5-7 days
- Cytology: 1-2 days
- Frozen section: 15-20 minutes intraoperatively

### Laboratory Quality Metrics

- TAT from collection to result
- Critical value notification time
- Specimen rejection rate
- Proficiency testing performance
- Delta check failure rate

**TAT benchmarks:**
- STAT laboratory: <60 minutes
- Routine laboratory: 2-4 hours
- Send-out tests: Per reference laboratory

---

This reference provides comprehensive standards for diagnostic reporting across radiology, pathology, and laboratory medicine. Refer to these guidelines to ensure reports meet professional standards and regulatory requirements.

