# Corrective and Preventive Action (CAPA) Procedure Template

**Document Number:** SOP-8.5-001
**Title:** Corrective and Preventive Action (CAPA)
**Revision:** 00
**Effective Date:** [DATE]
**Page:** 1 of [X]

---

## DOCUMENT CONTROL

### Approval Signatures

| Role | Name | Signature | Date |
|------|------|-----------|------|
| Author | [NAME] | | [DATE] |
| Reviewer | [NAME] | | [DATE] |
| Approver (Quality Manager) | [NAME] | | [DATE] |

### Revision History

| Revision | Date | Description of Changes | Approved By |
|----------|------|------------------------|-------------|
| 00 | [DATE] | Initial release | [NAME] |
|  |  |  |  |

---

## TABLE OF CONTENTS

1. [Purpose](#1-purpose)
2. [Scope](#2-scope)
3. [Definitions](#3-definitions)
4. [Responsibilities](#4-responsibilities)
5. [Procedure](#5-procedure)
   - 5.1 [Corrective Action Process](#51-corrective-action-process)
   - 5.2 [Preventive Action Process](#52-preventive-action-process)
   - 5.3 [CAPA Prioritization](#53-capa-prioritization)
   - 5.4 [Investigation and Root Cause Analysis](#54-investigation-and-root-cause-analysis)
   - 5.5 [Action Planning and Implementation](#55-action-planning-and-implementation)
   - 5.6 [Effectiveness Review](#56-effectiveness-review)
   - 5.7 [CAPA Closure](#57-capa-closure)
6. [Records](#6-records)
7. [References](#7-references)
8. [Attachments](#8-attachments)

---

## 1. PURPOSE

This procedure establishes requirements for:

- Corrective action to eliminate causes of nonconformities and prevent recurrence
- Preventive action to eliminate causes of potential nonconformities and prevent occurrence
- Systematic investigation and analysis of problems and risks
- Implementation and verification of effective actions
- Continuous improvement of the Quality Management System

This procedure ensures compliance with ISO 13485:2016 Clauses 8.5.2 (Corrective Action) and 8.5.3 (Preventive Action).

---

## 2. SCOPE

This procedure applies to:

- All nonconformities identified through any means (internal audits, customer complaints, process monitoring, product inspection, etc.)
- Potential nonconformities identified through risk analysis, trend analysis, and proactive reviews
- All products, processes, and QMS elements
- All departments and personnel within [COMPANY NAME]

---

## 3. DEFINITIONS

| Term | Definition |
|------|------------|
| **CAPA** | Corrective and Preventive Action |
| **Corrective Action** | Action to eliminate the cause of a detected nonconformity or other undesirable situation to prevent recurrence |
| **Preventive Action** | Action to eliminate the cause of a potential nonconformity or other potential undesirable situation to prevent occurrence |
| **Nonconformity** | Non-fulfillment of a requirement |
| **Root Cause** | The fundamental reason for the occurrence of a problem |
| **Root Cause Analysis (RCA)** | Systematic process to identify the root cause of a problem |
| **Effectiveness Check** | Verification that implemented actions have achieved the intended result |
| **5 Whys** | Iterative questioning technique used to explore cause-and-effect relationships |
| **Fishbone Diagram** | Visual tool for categorizing potential causes of a problem (also called Ishikawa diagram) |

---

## 4. RESPONSIBILITIES

### 4.1 Quality Manager
- Overall responsibility for CAPA system
- Reviews all CAPAs for adequacy
- Approves CAPA closures
- Reports CAPA metrics in management review
- Ensures resources are available for CAPA activities

### 4.2 CAPA Coordinator
- Manages CAPA database/system
- Assigns CAPA numbers
- Tracks CAPA status and due dates
- Sends reminders for overdue actions
- Generates CAPA metrics and reports
- Maintains CAPA records

### 4.3 CAPA Owner (Assigned Personnel)
- Leads investigation and root cause analysis
- Develops action plan
- Implements corrective/preventive actions
- Coordinates with affected departments
- Documents all CAPA activities
- Performs effectiveness checks
- Requests CAPA closure when complete

### 4.4 Department Managers
- Provide resources and support for CAPA activities
- Participate in investigations within their areas
- Implement actions within their departments
- Verify implementation of actions

### 4.5 All Personnel
- Report nonconformities and improvement opportunities
- Participate in CAPA investigations as requested
- Implement actions assigned to them
- Support CAPA effectiveness

---

## 5. PROCEDURE

### 5.1 Corrective Action Process

Corrective actions are initiated in response to identified nonconformities from sources including:

**Sources of Nonconformities:**
- Customer complaints (per SOP-[NUMBER])
- Internal nonconforming product (per SOP-[NUMBER])
- Internal audit findings (per SOP-[NUMBER])
- Process monitoring out-of-specification results
- Product inspection failures
- Supplier nonconformances
- Regulatory inspections or observations
- Management review action items
- Risk management outputs
- Returned or rejected product

**5.1.1 CAPA Initiation**

1. When a nonconformity is identified, the individual discovering it:
   - Completes a CAPA Request Form (Attachment A) or enters information into CAPA system
   - Describes the nonconformity clearly and completely
   - Attaches supporting documentation (NCRs, complaints, audit findings, etc.)
   - Submits to Quality department

2. CAPA Coordinator:
   - Receives CAPA request
   - Assigns unique CAPA number: CAPA-[YEAR]-[###]
   - Logs CAPA in tracking system
   - Routes to Quality Manager for review

3. Quality Manager:
   - Reviews CAPA request for completeness and clarity
   - Determines if corrective action is warranted
   - Assigns priority (see Section 5.3)
   - Assigns CAPA Owner
   - Sets due date based on priority
   - Approves initiation of CAPA investigation

### 5.2 Preventive Action Process

Preventive actions are initiated proactively to address potential problems before they occur.

**Sources of Preventive Action:**
- Trend analysis of complaints, NCRs, or other data
- Risk management activities (per SOP-[NUMBER])
- Process capability studies
- Near-miss events
- Lessons learned from other organizations or devices
- Changes in regulations or standards
- Proactive process improvements
- Management review outputs
- Employee suggestions

**5.2.1 Preventive Action Initiation**

Process is similar to corrective action (Section 5.1.1), but:
- Describes potential nonconformity and its possible consequences
- Includes data or rationale supporting the need for preventive action
- May have different prioritization based on risk of occurrence

### 5.3 CAPA Prioritization

All CAPAs are prioritized based on:
- Severity of impact (safety, regulatory, customer impact)
- Frequency or likelihood of occurrence
- Detectability before reaching customer

**Priority Levels:**

| Priority | Criteria | Due Date for Completion |
|----------|----------|-------------------------|
| **Critical** | Safety issue, regulatory requirement, major customer impact, Class I recall potential | [X] days |
| **High** | Significant quality impact, repeat issue, moderate customer impact, regulatory reporting | [X] days |
| **Medium** | Moderate impact, isolated occurrence, minor customer impact | [X] days |
| **Low** | Minor impact, isolated occurrence, no customer impact, improvement opportunity | [X] days |

Priority is determined by Quality Manager in consultation with CAPA Owner and affected department managers.

### 5.4 Investigation and Root Cause Analysis

**5.4.1 Investigation Planning**

CAPA Owner develops investigation plan including:
- Scope of investigation
- Team members needed (if applicable)
- Data to be collected
- Analysis methods to be used
- Timeline

**5.4.2 Data Collection**

Collect relevant data:
- Review related records (batch records, inspection records, training records, etc.)
- Interview personnel involved
- Review similar past occurrences
- Examine physical evidence (product samples, equipment, etc.)
- Review applicable procedures and work instructions
- Analyze trend data if available

**5.4.3 Root Cause Analysis**

Use appropriate RCA tools based on complexity:

**For Simple Issues:**
- 5 Whys technique
- Cause and effect analysis

**For Complex Issues:**
- Fishbone (Ishikawa) diagram
- Fault tree analysis
- Failure mode and effects analysis (FMEA)
- Statistical analysis

**RCA Requirements:**
- Dig beyond superficial causes to find root cause
- Distinguish between symptoms and causes
- Consider multiple contributing factors
- Ask "why" repeatedly until fundamental cause identified
- Consider human factors, procedural inadequacies, system weaknesses
- Document analysis process and findings

**5.4.4 Root Cause Documentation**

Document in CAPA record:
- Summary of investigation findings
- Root cause(s) identified
- Supporting data and analysis
- RCA tool(s) used
- Team members involved
- Date investigation completed

Quality Manager reviews and approves root cause determination.

### 5.5 Action Planning and Implementation

**5.5.1 Action Planning**

Based on root cause, CAPA Owner develops action plan:

**Actions must be:**
- **Effective:** Address root cause, not just symptoms
- **Achievable:** Realistic with available resources
- **Measurable:** Include objective success criteria
- **Timely:** Include target completion dates
- **Risk-appropriate:** Commensurate with severity and likelihood

**Action Plan includes:**
- Specific actions to be taken
- Responsible person for each action
- Target completion date for each action
- Resources required
- Expected outcome/success criteria
- How effectiveness will be measured

**5.5.2 Types of Actions**

Actions may include:
- Procedure revisions or clarifications
- Training or retraining
- Equipment repair, replacement, or modification
- Process changes or improvements
- Design changes (when applicable)
- Supplier corrective action requests
- Increased inspection or monitoring
- Software updates or validation
- Physical facility changes
- Organizational changes

**5.5.3 Action Approval**

- CAPA Owner submits action plan to Quality Manager
- Quality Manager reviews for adequacy and appropriateness
- Department Managers review actions affecting their areas
- Quality Manager approves action plan
- Actions assigned to responsible parties with due dates

**5.5.4 Implementation**

- Responsible parties implement assigned actions
- Implementation is documented (procedure revisions, training records, etc.)
- CAPA Owner tracks implementation progress
- CAPA Coordinator sends reminders for overdue actions
- Interim updates provided for long-duration CAPAs

**5.5.5 Documentation of Implementation**

For each action, document:
- Date implemented
- Evidence of implementation (updated procedures, training records, work orders, etc.)
- Any deviations from planned actions and justification
- Responsible person confirmation

### 5.6 Effectiveness Review

**5.6.1 Timing of Effectiveness Check**

Effectiveness is verified after:
- Sufficient time has passed to observe results
- Minimum: [X days/weeks] after implementation
- Extended period for process or trend verification: [X months]
- Timing based on priority and nature of issue

**5.6.2 Effectiveness Verification Methods**

Methods appropriate to the CAPA may include:
- Review of process or product data for improved performance
- Inspection or test results showing improvement
- Absence of recurrence over defined period
- Customer feedback or complaint trends
- Internal audit verification
- Process capability analysis
- Statistical analysis of relevant metrics
- Re-audit of corrective action area
- Follow-up inspection or testing

**5.6.3 Effectiveness Determination**

CAPA Owner:
- Collects effectiveness data using planned method
- Analyzes data to determine if actions achieved intended result
- Documents findings in CAPA record
- Recommends effectiveness status:
  - **Effective:** Actions achieved intended result, no recurrence
  - **Not Effective:** Actions did not achieve intended result, recurrence observed
  - **Additional Data Needed:** Insufficient time or data to determine effectiveness

**5.6.4 Ineffective Actions**

If actions determined not effective:
- CAPA remains open
- Re-investigation performed
- Alternative actions developed
- Cycle repeats until effectiveness achieved

### 5.7 CAPA Closure

**5.7.1 Closure Criteria**

CAPA may be closed when:
- All planned actions implemented and verified
- Effectiveness check completed and actions determined effective
- All documentation complete
- No recurrence of issue during effectiveness period

**5.7.2 Closure Process**

1. CAPA Owner:
   - Verifies all closure criteria met
   - Completes final CAPA summary
   - Submits closure request to Quality Manager

2. Quality Manager:
   - Reviews entire CAPA record for completeness
   - Verifies effectiveness evidence
   - Approves closure or requests additional information
   - Signs and dates CAPA closure

3. CAPA Coordinator:
   - Updates CAPA status to "Closed"
   - Files CAPA record per retention requirements
   - Updates metrics and reports

**5.7.3 CAPA Extension**

If additional time needed:
- CAPA Owner submits extension request with justification
- Quality Manager reviews and approves/denies extension
- New due date established
- Extension documented in CAPA record

---

## 6. RECORDS

Records generated and maintained per this procedure:

| Record | Retention Period | Location | Responsible Party |
|--------|------------------|----------|-------------------|
| CAPA Request Forms | [X years or device lifetime] | [LOCATION/SYSTEM] | CAPA Coordinator |
| CAPA Investigation Records | [X years or device lifetime] | [LOCATION/SYSTEM] | CAPA Coordinator |
| Root Cause Analysis Documentation | [X years or device lifetime] | [LOCATION/SYSTEM] | CAPA Coordinator |
| Action Plans | [X years or device lifetime] | [LOCATION/SYSTEM] | CAPA Coordinator |
| Implementation Evidence | [X years or device lifetime] | [LOCATION/SYSTEM] | CAPA Coordinator |
| Effectiveness Verification Records | [X years or device lifetime] | [LOCATION/SYSTEM] | CAPA Coordinator |
| CAPA Closure Approvals | [X years or device lifetime] | [LOCATION/SYSTEM] | CAPA Coordinator |
| CAPA Metrics and Trend Reports | [X years] | [LOCATION] | Quality Manager |

---

## 7. REFERENCES

- ISO 13485:2016, Clause 8.5.2 - Corrective Action
- ISO 13485:2016, Clause 8.5.3 - Preventive Action
- Quality Manual, Section 8.5
- SOP-[NUMBER] - Control of Nonconforming Product
- SOP-[NUMBER] - Complaint Handling
- SOP-[NUMBER] - Internal Audit
- SOP-[NUMBER] - Risk Management
- SOP-[NUMBER] - Analysis of Data

---

## 8. ATTACHMENTS

**Attachment A:** CAPA Request Form
**Attachment B:** Root Cause Analysis Worksheet
**Attachment C:** CAPA Action Plan Template
**Attachment D:** Effectiveness Verification Checklist
**Attachment E:** 5 Whys Worksheet
**Attachment F:** Fishbone Diagram Template
**Attachment G:** CAPA Flowchart

---

**END OF PROCEDURE**

---

**Document Number:** SOP-8.5-001
**Revision:** 00
**Page:** [X] of [X]
