# ISO 13485:2016 Gap Analysis Checklist

This comprehensive checklist helps identify gaps between your current Quality Management System and ISO 13485:2016 requirements.

## How to Use This Checklist

**Status Indicators:**
- ✅ **Compliant:** Requirement fully implemented and documented
- ⚠️ **Partial:** Requirement partially implemented, needs improvement
- ❌ **Non-compliant:** Requirement not implemented or documented
- N/A **Not Applicable:** Requirement doesn't apply (must be justified)

**For Each Item:**
1. Assess current status
2. Identify existing documentation
3. Note gaps or deficiencies
4. Prioritize actions needed
5. Assign responsibility and target dates

---

## Clause 4: Quality Management System

### 4.1 General Requirements

| # | Requirement | Status | Evidence | Gaps | Action Required |
|---|------------|--------|----------|------|-----------------|
| 4.1.1 | QMS established, documented, implemented, and maintained | | | | |
| 4.1.2 | QMS processes identified with sequence and interaction | | | | |
| 4.1.3 | Outsourced processes controlled and documented | | | | |
| 4.1.4 | QMS requirements and applicable regulatory requirements met | | | | |
| 4.1.5 | Risk management requirements documented and maintained | | | | |
| 4.1.6 | Computer software applications validated before use | | | | |

### 4.2 Documentation Requirements

| # | Requirement | Status | Evidence | Gaps | Action Required |
|---|------------|--------|----------|------|-----------------|
| 4.2.1 | QMS documentation includes policy, manual, procedures, records | | | | |
| 4.2.2 | Quality Manual established with required content | | | | |
| 4.2.2.a | Scope of QMS with justified exclusions | | | | |
| 4.2.2.b | Documented procedures or references | | | | |
| 4.2.2.c | Description of process interactions | | | | |
| 4.2.2.d | Structure of documentation described | | | | |
| 4.2.3 | Medical Device File established for each device type/family | | | | |
| 4.2.3.a | General description and intended use documented | | | | |
| 4.2.3.b | Label and IFU specifications | | | | |
| 4.2.3.c | Product specifications | | | | |
| 4.2.3.d | Manufacturing specifications | | | | |
| 4.2.3.e | Purchasing, manufacturing, servicing procedures | | | | |
| 4.2.3.f | Measurement and monitoring procedures | | | | |
| 4.2.3.g | Installation requirements (if applicable) | | | | |
| 4.2.3.h | Risk management file(s) | | | | |
| 4.2.3.i | Verification and validation information | | | | |
| 4.2.3.j | Design and development file(s) when applicable | | | | |
| 4.2.4 | Control of Documents procedure established | | | | |
| 4.2.4.a | Documents approved before issue | | | | |
| 4.2.4.b | Documents reviewed, updated, and re-approved | | | | |
| 4.2.4.c | Changes and current revision status identified | | | | |
| 4.2.4.d | Relevant versions available at point of use | | | | |
| 4.2.4.e | Documents remain legible and identifiable | | | | |
| 4.2.4.f | External documents controlled | | | | |
| 4.2.4.g | Obsolete documents prevented from unintended use | | | | |
| 4.2.4.h | Obsolete documents identified if retained | | | | |
| 4.2.5 | Control of Records procedure established | | | | |
| 4.2.5.a | Records remain legible, identifiable, and retrievable | | | | |
| 4.2.5.b | Changes to records remain identifiable | | | | |
| 4.2.5.c | Retention time at least device lifetime | | | | |
| 4.2.5.d | Storage, security, integrity, retrieval, disposition defined | | | | |

---

## Clause 5: Management Responsibility

### 5.1 Management Commitment

| # | Requirement | Status | Evidence | Gaps | Action Required |
|---|------------|--------|----------|------|-----------------|
| 5.1.a | Importance of meeting requirements communicated | | | | |
| 5.1.b | Quality policy established | | | | |
| 5.1.c | Quality objectives established | | | | |
| 5.1.d | Management reviews conducted | | | | |
| 5.1.e | Resource availability ensured | | | | |

### 5.2 Customer Focus

| # | Requirement | Status | Evidence | Gaps | Action Required |
|---|------------|--------|----------|------|-----------------|
| 5.2 | Customer and regulatory requirements determined and met | | | | |

### 5.3 Quality Policy

| # | Requirement | Status | Evidence | Gaps | Action Required |
|---|------------|--------|----------|------|-----------------|
| 5.3.a | Policy appropriate to organization | | | | |
| 5.3.b | Includes commitment to meet requirements and maintain effectiveness | | | | |
| 5.3.c | Provides framework for quality objectives | | | | |
| 5.3.d | Communicated and understood within organization | | | | |
| 5.3.e | Reviewed for continuing suitability | | | | |

### 5.4 Planning

| # | Requirement | Status | Evidence | Gaps | Action Required |
|---|------------|--------|----------|------|-----------------|
| 5.4.1 | Quality objectives established at relevant functions/levels | | | | |
| 5.4.1 | Objectives measurable and consistent with policy | | | | |
| 5.4.2 | QMS planning meets general requirements and objectives | | | | |
| 5.4.2 | QMS integrity maintained when changes occur | | | | |

### 5.5 Responsibility, Authority and Communication

| # | Requirement | Status | Evidence | Gaps | Action Required |
|---|------------|--------|----------|------|-----------------|
| 5.5.1 | Responsibilities and authorities defined and communicated | | | | |
| 5.5.1 | Roles for QMS management, performance, verification documented | | | | |
| 5.5.1 | Interrelation of personnel identified | | | | |
| 5.5.2 | Management representative appointed | | | | |
| 5.5.2.a | Representative ensures QMS processes established and maintained | | | | |
| 5.5.2.b | Representative reports to top management on performance | | | | |
| 5.5.2.c | Representative ensures awareness of requirements | | | | |
| 5.5.3 | Internal communication processes established | | | | |

### 5.6 Management Review

| # | Requirement | Status | Evidence | Gaps | Action Required |
|---|------------|--------|----------|------|-----------------|
| 5.6.1 | QMS reviewed at planned intervals (at least annually) | | | | |
| 5.6.1 | Review ensures suitability, adequacy, effectiveness | | | | |
| 5.6.1 | Review includes improvement opportunities | | | | |
| 5.6.1 | Records of reviews maintained | | | | |
| 5.6.2 | Review includes audit results | | | | |
| 5.6.2 | Review includes customer feedback | | | | |
| 5.6.2 | Review includes process performance and product conformity | | | | |
| 5.6.2 | Review includes status of corrective and preventive actions | | | | |
| 5.6.2 | Review includes follow-up from previous reviews | | | | |
| 5.6.2 | Review includes changes affecting QMS | | | | |
| 5.6.2 | Review includes recommendations for improvement | | | | |
| 5.6.2 | Review includes new/revised regulatory requirements | | | | |
| 5.6.3 | Review output includes QMS improvements | | | | |
| 5.6.3 | Review output includes product improvements | | | | |
| 5.6.3 | Review output includes resource needs | | | | |
| 5.6.3 | Review output includes changes to maintain effectiveness | | | | |

---

## Clause 6: Resource Management

### 6.1 Provision of Resources

| # | Requirement | Status | Evidence | Gaps | Action Required |
|---|------------|--------|----------|------|-----------------|
| 6.1 | Resources determined and provided for QMS | | | | |
| 6.1 | Resources provided to meet regulatory and customer requirements | | | | |

### 6.2 Human Resources

| # | Requirement | Status | Evidence | Gaps | Action Required |
|---|------------|--------|----------|------|-----------------|
| 6.2 | Personnel competent based on education, training, skills, experience | | | | |
| 6.2 | Documented evidence of competence maintained | | | | |

### 6.3 Infrastructure

| # | Requirement | Status | Evidence | Gaps | Action Required |
|---|------------|--------|----------|------|-----------------|
| 6.3 | Infrastructure determined, provided, and maintained | | | | |
| 6.3.a | Buildings, workspace, and utilities provided | | | | |
| 6.3.b | Process equipment (hardware and software) provided | | | | |
| 6.3.c | Supporting services provided | | | | |
| 6.3 | Maintenance requirements documented (when affecting quality) | | | | |
| 6.3 | Maintenance activity records maintained | | | | |

### 6.4 Work Environment and Contamination Control

| # | Requirement | Status | Evidence | Gaps | Action Required |
|---|------------|--------|----------|------|-----------------|
| 6.4.1 | Work environment determined and managed | | | | |
| 6.4.1 | Work environment requirements documented | | | | |
| 6.4.2 | Contamination control requirements documented (if applicable) | | | | |
| 6.4.2 | Special arrangements for contaminated product established | | | | |

---

## Clause 7: Product Realization

### 7.1 Planning of Product Realization

| # | Requirement | Status | Evidence | Gaps | Action Required |
|---|------------|--------|----------|------|-----------------|
| 7.1.a | Quality objectives and requirements determined | | | | |
| 7.1.b | Need for processes, documentation, and resources determined | | | | |
| 7.1.c | Verification, validation, monitoring, measurement activities determined | | | | |
| 7.1.c | Handling, storage, distribution, traceability determined | | | | |
| 7.1.d | Records to provide evidence of conformity determined | | | | |
| 7.1 | Risk management requirements documented | | | | |
| 7.1 | Risk management records maintained | | | | |

### 7.2 Customer-Related Processes

| # | Requirement | Status | Evidence | Gaps | Action Required |
|---|------------|--------|----------|------|-----------------|
| 7.2.1.a | Requirements specified by customer determined | | | | |
| 7.2.1.b | Requirements not stated but necessary determined | | | | |
| 7.2.1.c | Applicable regulatory requirements determined | | | | |
| 7.2.1.d | Additional requirements determined by organization | | | | |
| 7.2.2 | Product requirements reviewed before commitment | | | | |
| 7.2.2 | Requirements defined and documented | | | | |
| 7.2.2 | Differences resolved | | | | |
| 7.2.2 | Ability to meet requirements ensured | | | | |
| 7.2.2 | Records of review and follow-up maintained | | | | |
| 7.2.3 | Arrangements for communication with customers documented | | | | |
| 7.2.3.a | Communication on product information | | | | |
| 7.2.3.b | Communication on inquiry, contract, order handling | | | | |
| 7.2.3.c | Communication on customer feedback including complaints | | | | |
| 7.2.3.d | Communication on advisory notices | | | | |

### 7.3 Design and Development

| # | Requirement | Status | Evidence | Gaps | Action Required |
|---|------------|--------|----------|------|-----------------|
| 7.3.1 | Design and development procedures documented | | | | |
| 7.3.1 | Design and development plan documented for each device | | | | |
| 7.3.1 | Design and development files maintained | | | | |
| 7.3.2 | Design and development stages determined | | | | |
| 7.3.2 | Required review, verification, validation determined | | | | |
| 7.3.2 | Responsibilities and authorities defined | | | | |
| 7.3.2 | Resources and interfaces managed | | | | |
| 7.3.2 | Plans updated as design progresses | | | | |
| 7.3.3 | Design inputs determined and recorded | | | | |
| 7.3.3 | Functional, performance, usability, safety requirements included | | | | |
| 7.3.3 | Regulatory requirements and standards included | | | | |
| 7.3.3 | Risk management outputs included | | | | |
| 7.3.3 | Previous similar design information included | | | | |
| 7.3.3 | Inputs reviewed for adequacy | | | | |
| 7.3.4 | Design outputs meet input requirements | | | | |
| 7.3.4 | Outputs provide information for purchasing, production, service | | | | |
| 7.3.4 | Outputs contain acceptance criteria | | | | |
| 7.3.4 | Outputs specify characteristics for safe and proper use | | | | |
| 7.3.4 | Outputs documented and maintained as records | | | | |
| 7.3.5 | Systematic reviews conducted at suitable stages | | | | |
| 7.3.5 | Review evaluates ability to meet requirements | | | | |
| 7.3.5 | Review identifies problems and proposes actions | | | | |
| 7.3.5 | Representatives of functions concerned included | | | | |
| 7.3.5 | Records of reviews and follow-up maintained | | | | |
| 7.3.6 | Verification performed per planned arrangements | | | | |
| 7.3.6 | Verification ensures outputs meet inputs | | | | |
| 7.3.6 | Records of verification and follow-up maintained | | | | |
| 7.3.7 | Validation performed per planned arrangements | | | | |
| 7.3.7 | Validation ensures product meets specified application | | | | |
| 7.3.7 | Validation conducted before delivery or implementation | | | | |
| 7.3.7 | Validation includes defined operating conditions | | | | |
| 7.3.7 | Records of validation and follow-up maintained | | | | |
| 7.3.8 | Transfer procedures documented | | | | |
| 7.3.8 | Manufacturing output verified against design output | | | | |
| 7.3.8 | Specifications appropriate for manufacturing | | | | |
| 7.3.8 | Transfer records maintained | | | | |
| 7.3.9 | Design changes identified, documented, and controlled | | | | |
| 7.3.9 | Changes reviewed, verified, validated, and approved | | | | |
| 7.3.9 | Effects on constituent parts and delivered product evaluated | | | | |
| 7.3.9 | Records of changes and review maintained | | | | |
| 7.3.10 | Design and development files maintained including all required content | | | | |

### 7.4 Purchasing

| # | Requirement | Status | Evidence | Gaps | Action Required |
|---|------------|--------|----------|------|-----------------|
| 7.4.1 | Purchased product conforms to purchase information | | | | |
| 7.4.1 | Purchasing activities documented | | | | |
| 7.4.1 | Criteria for supplier evaluation and selection established | | | | |
| 7.4.1 | Criteria based on supplier ability to supply per requirements | | | | |
| 7.4.1 | Supplier performance monitored | | | | |
| 7.4.1 | Records of supplier evaluations and follow-up maintained | | | | |
| 7.4.1 | Process for notifying suppliers of changes established | | | | |
| 7.4.2 | Purchasing information includes product approval requirements | | | | |
| 7.4.2 | Purchasing information includes qualification of personnel | | | | |
| 7.4.2 | Purchasing information includes QMS requirements | | | | |
| 7.4.2 | Purchasing information includes notification requirements | | | | |
| 7.4.2 | Purchasing information includes supplier change notification | | | | |
| 7.4.2 | Purchasing information communicated to sub-tier suppliers | | | | |
| 7.4.3 | Verification activities to ensure purchased product conformity | | | | |
| 7.4.3 | Extent of verification documented | | | | |
| 7.4.3 | Verification at supplier's premises documented (if applicable) | | | | |

### 7.5 Production and Service Provision

| # | Requirement | Status | Evidence | Gaps | Action Required |
|---|------------|--------|----------|------|-----------------|
| 7.5.1.a | Documented procedures and work instructions available | | | | |
| 7.5.1.b | Suitable infrastructure and work environment available | | | | |
| 7.5.1.c | Monitoring and measuring equipment available | | | | |
| 7.5.1.d | Monitoring and measuring activities available and used | | | | |
| 7.5.1.e | Product release, delivery, post-delivery activities implemented | | | | |
| 7.5.1.f | Operations for labelling and packaging defined | | | | |
| 7.5.1.g | Procedures for servicing documented (if applicable) | | | | |
| 7.5.1 | Requirements for product cleanliness documented | | | | |
| 7.5.1 | Requirements for installation and verification documented | | | | |
| 7.5.2 | Cleanliness requirements documented (if applicable) | | | | |
| 7.5.2 | Hygiene requirements in manufacturing documented | | | | |
| 7.5.3 | Installation requirements documented (if applicable) | | | | |
| 7.5.3 | Verification of installation conducted | | | | |
| 7.5.3 | Records of installation and verification maintained | | | | |
| 7.5.4 | Servicing procedures documented (if applicable) | | | | |
| 7.5.4 | Servicing records analyzed for feedback | | | | |
| 7.5.4 | Records of servicing maintained | | | | |
| 7.5.5 | Records of sterilization process parameters maintained (if applicable) | | | | |
| 7.5.6 | Processes validated where output cannot be verified | | | | |
| 7.5.6 | Defined criteria for review and approval | | | | |
| 7.5.6 | Equipment approval and personnel qualification | | | | |
| 7.5.6 | Specific methods, procedures, and acceptance criteria used | | | | |
| 7.5.6 | Requirements for records defined | | | | |
| 7.5.6 | Revalidation criteria defined | | | | |
| 7.5.6 | Software validation for production documented | | | | |
| 7.5.6 | Sterilization process validation documented (if applicable) | | | | |
| 7.5.6 | Aseptic processing validation documented (if applicable) | | | | |
| 7.5.6 | Clean room validation documented (if applicable) | | | | |
| 7.5.7 | Sterilization process validation records maintained (if applicable) | | | | |
| 7.5.7 | Sterile barrier system validation records maintained (if applicable) | | | | |
| 7.5.8 | Product identification procedures documented | | | | |
| 7.5.8 | Product identified by suitable means throughout realization | | | | |
| 7.5.8 | Records of identification maintained where traceability required | | | | |
| 7.5.9.1 | Traceability extent defined and documented | | | | |
| 7.5.9.1 | Distribution and location documented | | | | |
| 7.5.9.2 | Consignee name and address recorded | | | | |
| 7.5.9.2 | Quantity shipped recorded | | | | |
| 7.5.9.2 | Regulatory traceability requirements included | | | | |
| 7.5.9.2 | Traceability records maintained for defined period | | | | |
| 7.5.10 | Customer property identified, verified, protected (if applicable) | | | | |
| 7.5.10 | Loss, damage, unsuitability reported to customer | | | | |
| 7.5.10 | Records of customer property maintained | | | | |
| 7.5.11 | Product preservation during processing and delivery | | | | |
| 7.5.11 | Identification, handling, packaging, storage, protection included | | | | |
| 7.5.11 | Preservation applies to constituent parts | | | | |
| 7.5.11 | Special handling requirements documented (if applicable) | | | | |

### 7.6 Control of Monitoring and Measuring Equipment

| # | Requirement | Status | Evidence | Gaps | Action Required |
|---|------------|--------|----------|------|-----------------|
| 7.6 | Monitoring and measurement to be undertaken determined | | | | |
| 7.6 | Monitoring and measuring equipment needed determined | | | | |
| 7.6.a | Calibration or verification at specified intervals | | | | |
| 7.6.b | Adjustment or re-adjustment as necessary | | | | |
| 7.6.c | Identification to determine calibration status | | | | |
| 7.6.d | Safeguarding from adjustments invalidating calibration | | | | |
| 7.6.e | Protection from damage and deterioration | | | | |
| 7.6 | Validity of previous results assessed when non-conforming | | | | |
| 7.6 | Records of calibration and verification maintained | | | | |
| 7.6 | Computer software confirmed for intended application | | | | |
| 7.6 | Software confirmation before initial use and reconfirmation | | | | |

---

## Clause 8: Measurement, Analysis and Improvement

### 8.1 General

| # | Requirement | Status | Evidence | Gaps | Action Required |
|---|------------|--------|----------|------|-----------------|
| 8.1 | Monitoring, measurement, analysis, improvement processes planned | | | | |
| 8.1 | Product conformity demonstrated | | | | |
| 8.1 | QMS conformity ensured | | | | |
| 8.1 | QMS effectiveness maintained | | | | |
| 8.1 | Applicable methods including statistical techniques determined | | | | |

### 8.2 Monitoring and Measurement

| # | Requirement | Status | Evidence | Gaps | Action Required |
|---|------------|--------|----------|------|-----------------|
| 8.2.1 | Feedback procedure established | | | | |
| 8.2.1 | Early warning system for quality issues established | | | | |
| 8.2.1 | Post-production information collected | | | | |
| 8.2.1 | Requirements for regulatory reporting included | | | | |
| 8.2.1 | Feedback used as input to risk management | | | | |
| 8.2.1 | Feedback used as input to corrective/preventive action | | | | |
| 8.2.2 | Complaint handling procedure established | | | | |
| 8.2.2 | Requirements for receiving, recording, evaluating complaints | | | | |
| 8.2.2 | Requirements for handling, investigating complaints | | | | |
| 8.2.2 | Requirements for reporting to regulatory authorities | | | | |
| 8.2.2 | Requirements for informing customer of actions | | | | |
| 8.2.2 | Complaint information transferred to organization | | | | |
| 8.2.2 | Records of complaints and investigations maintained | | | | |
| 8.2.3 | Regulatory reporting procedure established | | | | |
| 8.2.3 | Notification to regulatory authorities per requirements | | | | |
| 8.2.3 | Advisory notices per applicable requirements | | | | |
| 8.2.3 | Records of reporting maintained | | | | |
| 8.2.4 | Internal audits conducted at planned intervals | | | | |
| 8.2.4 | QMS conformity to ISO 13485 and requirements determined | | | | |
| 8.2.4 | QMS effective implementation and maintenance determined | | | | |
| 8.2.4 | Audit program considers importance, changes, previous results | | | | |
| 8.2.4 | Audit criteria, scope, frequency, methods defined | | | | |
| 8.2.4 | Audit procedure includes responsibilities and reporting | | | | |
| 8.2.4 | Objective and impartial auditors selected | | | | |
| 8.2.4 | Records of audits and results maintained | | | | |
| 8.2.4 | Need for corrections or corrective actions identified | | | | |
| 8.2.4 | Follow-up activities conducted | | | | |
| 8.2.5 | Suitable methods for process monitoring and measurement | | | | |
| 8.2.5 | Ability to achieve planned results demonstrated | | | | |
| 8.2.5 | Corrections and corrective actions implemented when needed | | | | |
| 8.2.5 | Records maintained | | | | |
| 8.2.6 | Product characteristics monitored and measured | | | | |
| 8.2.6 | Conducted at appropriate stages per planned arrangements | | | | |
| 8.2.6 | Records show conformity to acceptance criteria | | | | |
| 8.2.6 | Authority responsible for release recorded | | | | |
| 8.2.6 | Release and delivery not proceed until arrangements completed | | | | |

### 8.3 Control of Nonconforming Product

| # | Requirement | Status | Evidence | Gaps | Action Required |
|---|------------|--------|----------|------|-----------------|
| 8.3.1 | Nonconforming product identified and controlled | | | | |
| 8.3.1 | Procedure for identification, documentation established | | | | |
| 8.3.1 | Procedure for evaluation, segregation, disposition established | | | | |
| 8.3.1 | Procedure for notification to external parties established | | | | |
| 8.3.1 | Review of nonconforming product conducted | | | | |
| 8.3.1 | Records of nonconformities and actions maintained | | | | |
| 8.3.2 | Action taken to eliminate detected nonconformity | | | | |
| 8.3.2 | Use under concession authorized (if applicable) | | | | |
| 8.3.2 | Action taken to preclude original intended use | | | | |
| 8.3.2 | Records of concessions maintained | | | | |
| 8.3.2 | Authority making concession identified | | | | |
| 8.3.3 | Appropriate action for nonconformity after delivery | | | | |
| 8.3.3 | Procedure includes regulatory notification requirements | | | | |
| 8.3.3 | Records maintained | | | | |
| 8.3.4 | Rework procedures documented | | | | |
| 8.3.4 | Potential effects on medical device evaluated | | | | |
| 8.3.4 | Approval before rework implementation | | | | |
| 8.3.4 | Records of results and actions maintained | | | | |
| 8.3.4 | Re-verification after rework | | | | |
| 8.3.4 | Rework procedure documented before beginning | | | | |

### 8.4 Analysis of Data

| # | Requirement | Status | Evidence | Gaps | Action Required |
|---|------------|--------|----------|------|-----------------|
| 8.4 | Appropriate data determined, collected, and analyzed | | | | |
| 8.4 | Continual improvement opportunities evaluated | | | | |
| 8.4 | Procedures for data analysis established | | | | |
| 8.4.a | Analysis provides information on customer satisfaction | | | | |
| 8.4.b | Analysis of conformity to product requirements | | | | |
| 8.4.c | Analysis of process and product characteristics and trends | | | | |
| 8.4.d | Analysis of suppliers | | | | |
| 8.4.e | Analysis of feedback and risk management outputs | | | | |
| 8.4 | Statistical techniques used if necessary | | | | |
| 8.4 | Records of analysis results maintained | | | | |

### 8.5 Improvement

| # | Requirement | Status | Evidence | Gaps | Action Required |
|---|------------|--------|----------|------|-----------------|
| 8.5.1 | Changes identified and implemented to ensure effectiveness | | | | |
| 8.5.1 | Quality policy, objectives, audits, data, CAPA, reviews used | | | | |
| 8.5.2 | Corrective action procedure established | | | | |
| 8.5.2.a | Nonconformities including complaints reviewed | | | | |
| 8.5.2.b | Causes of nonconformities determined | | | | |
| 8.5.2.c | Need for actions to prevent recurrence evaluated | | | | |
| 8.5.2.d | Actions needed planned, documented, and implemented | | | | |
| 8.5.2.e | Results of actions documented | | | | |
| 8.5.2.f | Effectiveness of corrective actions reviewed | | | | |
| 8.5.2 | Records of investigation and follow-up maintained | | | | |
| 8.5.3 | Preventive action procedure established | | | | |
| 8.5.3.a | Potential nonconformities and causes determined | | | | |
| 8.5.3.b | Need for action to prevent occurrence evaluated | | | | |
| 8.5.3.c | Actions needed planned, documented, and implemented | | | | |
| 8.5.3.d | Results of actions documented | | | | |
| 8.5.3.e | Effectiveness of preventive actions reviewed | | | | |
| 8.5.3 | Appropriate information sources used | | | | |
| 8.5.3 | Records of investigation and follow-up maintained | | | | |

---

## Summary and Prioritization

### Gap Summary by Clause

| Clause | Total Items | Compliant | Partial | Non-Compliant | N/A | Compliance % |
|--------|-------------|-----------|---------|---------------|-----|--------------|
| 4. QMS | | | | | | |
| 5. Management | | | | | | |
| 6. Resources | | | | | | |
| 7. Product Realization | | | | | | |
| 8. Measurement & Improvement | | | | | | |
| **TOTAL** | | | | | | |

### Priority Actions

**Critical (Immediate Action Required):**
1.
2.
3.

**High Priority (Within 30 days):**
1.
2.
3.

**Medium Priority (Within 90 days):**
1.
2.
3.

**Low Priority (Within 180 days):**
1.
2.
3.

### Resource Requirements

**Personnel:**
-
-

**Training:**
-
-

**Tools/Systems:**
-
-

**External Support:**
-
-

### Timeline and Milestones

| Milestone | Target Date | Responsible | Status |
|-----------|-------------|-------------|--------|
| Gap analysis completion | | | |
| Priority 1 items complete | | | |
| Priority 2 items complete | | | |
| Priority 3 items complete | | | |
| Internal audit readiness | | | |
| Certification audit | | | |

---

## Notes and Additional Considerations

### Regulatory Requirements
Document any additional requirements beyond ISO 13485:
- FDA QMSR requirements
- EU MDR/IVDR requirements
- Health Canada requirements
- Other regional requirements

### Exclusions
Document and justify any clause exclusions:

| Clause | Exclusion | Justification |
|--------|-----------|---------------|
| | | |

### Additional Documentation Needed
List any additional documents identified during gap analysis:
-
-

### Lessons Learned and Best Practices
-
-

---

## Revision History

| Version | Date | Author | Changes |
|---------|------|--------|---------|
| 1.0 | | | Initial gap analysis |
