# ISO 13485:2016 Requirements Breakdown

This document provides a comprehensive breakdown of ISO 13485:2016 requirements for medical device Quality Management Systems (QMS).

## Table of Contents

1. [Clause 4: Quality Management System](#clause-4-quality-management-system)
2. [Clause 5: Management Responsibility](#clause-5-management-responsibility)
3. [Clause 6: Resource Management](#clause-6-resource-management)
4. [Clause 7: Product Realization](#clause-7-product-realization)
5. [Clause 8: Measurement, Analysis and Improvement](#clause-8-measurement-analysis-and-improvement)

## Clause 4: Quality Management System

### 4.1 General Requirements

#### 4.1.1 QMS Requirements
- Establish, document, implement, and maintain a QMS
- Maintain its effectiveness in accordance with ISO 13485
- Document the QMS processes and their interactions

#### 4.1.2 Process Approach
- Identify processes needed for the QMS
- Determine sequence and interaction of these processes
- Determine criteria and methods for effective operation and control
- Ensure availability of resources and information
- Monitor, measure, and analyze processes
- Implement actions to achieve planned results and maintain effectiveness

#### 4.1.3 Outsourced Processes
- Control any QMS process that is outsourced
- Ensure control is documented in the QMS
- Outsourcing does not relieve the organization of responsibility

#### 4.1.4 General QMS Requirements
- Establish, document, implement, and maintain QMS requirements per ISO 13485
- Include requirements for medical devices and applicable regulatory requirements
- Establish documented procedures for QMS activities

#### 4.1.5 Risk Management
- Establish documented requirements for risk management in product realization
- Maintain risk management records
- Ensure risk management is conducted according to documented requirements

#### 4.1.6 Software Validation
- Validate computer software applications used in QMS
- Validation must be conducted prior to initial use and after changes
- Establish documented approach including:
  - Risk associated with the software application
  - Validation activities
  - Acceptance criteria
  - User responsibilities
  - Validation records

### 4.2 Documentation Requirements

#### 4.2.1 General Documentation
QMS documentation must include:
- Quality policy and quality objectives
- Quality manual
- Documented procedures and records required by ISO 13485
- Documents required by organization for effective processes
- Records required by ISO 13485
- Medical device files as required by applicable regulatory requirements

#### 4.2.2 Quality Manual
Establish and maintain a quality manual that includes:
- Scope of the QMS with details and justification for exclusions
- Documented procedures or reference to them
- Description of interaction between QMS processes
- Structure of documentation used in the QMS

#### 4.2.3 Medical Device File
Establish and maintain a medical device file for each type or family that includes:
- General description, intended use/purpose
- Label and instructions for use specifications
- Specifications for product and/or manufacturing
- Specifications for procedures for purchasing, manufacturing, servicing
- Procedures for measuring and monitoring
- Installation requirements (if applicable)
- Risk management file(s)
- Verification and validation information
- Design and development file(s) when applicable

#### 4.2.4 Control of Documents
Establish documented procedure to:
- Approve documents before issue
- Review, update, and re-approve documents
- Ensure changes and current revision status are identified
- Ensure relevant versions are available at points of use
- Ensure documents remain legible and readily identifiable
- Control distribution of documents
- Prevent unintended use of obsolete documents
- Apply suitable identification if retained for any purpose

Document changes must:
- Be reviewed and approved by original function unless otherwise designated
- Have access to pertinent background information
- Be identified in the document or appropriate attachments

#### 4.2.5 Control of Records
Establish documented procedure for:
- Identification, storage, security, integrity, retrieval, retention time, and disposition
- Records must remain legible, readily identifiable, and retrievable
- Changes to records must remain identifiable
- Retention time must be at least the lifetime of the medical device
- Records may be stored on any media but must remain retrievable

## Clause 5: Management Responsibility

### 5.1 Management Commitment
Top management must provide evidence of commitment by:
- Communicating importance of meeting regulatory and customer requirements
- Establishing quality policy
- Establishing quality objectives
- Conducting management reviews
- Ensuring availability of resources

### 5.2 Customer Focus
- Determine customer requirements and regulatory requirements
- Ensure customer requirements are met to enhance satisfaction
- Maintain documented requirements related to the medical device

### 5.3 Quality Policy
- Appropriate to the organization
- Includes commitment to meet requirements and maintain QMS effectiveness
- Provides framework for quality objectives
- Communicated and understood within organization
- Reviewed for continuing suitability

### 5.4 Planning

#### 5.4.1 Quality Objectives
- Establish quality objectives at relevant functions and levels
- Must be measurable and consistent with quality policy
- Objectives must support conformity to product requirements

#### 5.4.2 QMS Planning
- Plan to meet general requirements and quality objectives
- Maintain QMS integrity when changes are planned and implemented
- Document planning

### 5.5 Responsibility, Authority and Communication

#### 5.5.1 Responsibility and Authority
- Define and communicate responsibilities and authorities
- Document roles that manage, perform, verify QMS work
- Identify interrelation of all personnel

#### 5.5.2 Management Representative
Appoint a member of management who:
- Ensures QMS processes are established, implemented, and maintained
- Reports to top management on QMS performance and improvement needs
- Ensures promotion of awareness of regulatory and customer requirements

#### 5.5.3 Internal Communication
- Ensure communication processes are established
- Ensure communication occurs regarding QMS effectiveness

### 5.6 Management Review

#### 5.6.1 General
- Review QMS at planned intervals (at least annually)
- Review to ensure continuing suitability, adequacy, and effectiveness
- Include assessment of opportunities for improvement
- Maintain records of management reviews

#### 5.6.2 Review Input
Include:
- Results of audits
- Customer feedback
- Process performance and product conformity
- Status of preventive and corrective actions
- Follow-up actions from previous reviews
- Changes affecting QMS
- Recommendations for improvement
- Applicable new or revised regulatory requirements

#### 5.6.3 Review Output
Include decisions and actions related to:
- Improvements to QMS effectiveness and processes
- Product improvements related to customer requirements
- Resource needs
- Changes necessary to maintain QMS effectiveness

## Clause 6: Resource Management

### 6.1 Provision of Resources
Determine and provide resources needed to:
- Implement and maintain QMS and its effectiveness
- Meet regulatory and customer requirements

### 6.2 Human Resources

#### 6.2 General
Personnel performing work affecting product quality must be competent based on:
- Education, training, skills, and experience
- Documented evidence of competence

#### 6.3 Infrastructure
Determine, provide, and maintain infrastructure including:
- Buildings, workspace, and associated utilities
- Process equipment (hardware and software)
- Supporting services

Infrastructure maintenance requirements:
- Document requirements including maintenance activities
- Document requirements when maintenance can affect product quality
- Maintain records of maintenance activities

### 6.4 Work Environment and Contamination Control

#### 6.4.1 Work Environment
- Determine and manage work environment needed for product conformity
- Document requirements for work environment
- Document requirements if work environment can adversely affect product quality

#### 6.4.2 Contamination Control
- When applicable to medical device, document requirements for control of contaminated or potentially contaminated product
- Establish special arrangements for control of contaminated product

## Clause 7: Product Realization

### 7.1 Planning of Product Realization
Plan and develop processes needed for product realization including:
- Quality objectives and requirements for the product
- Need to establish processes, documentation, and resources
- Required verification, validation, monitoring, measurement, inspection, handling, storage, distribution, and traceability
- Records to provide evidence of conformity

Risk management requirements:
- Establish documented requirements for risk management throughout product realization
- Maintain risk management records

### 7.2 Customer-Related Processes

#### 7.2.1 Determination of Requirements
Determine:
- Requirements specified by customer including delivery and post-delivery
- Requirements not stated but necessary for specified or intended use
- Applicable regulatory requirements
- Any additional requirements determined by organization

#### 7.2.2 Review of Requirements
- Review product requirements before commitment
- Ensure requirements are defined and documented
- Ensure differences are resolved
- Ensure ability to meet requirements
- Maintain records of review results and follow-up actions

#### 7.2.3 Communication
Establish and document effective arrangements for communication with customers concerning:
- Product information
- Inquiry, contract or order handling, amendments
- Customer feedback including complaints
- Advisory notices

### 7.3 Design and Development

#### 7.3.1 General
- Establish, document, and maintain design and development procedures
- Document design and development plan for each medical device
- Maintain design and development files

#### 7.3.2 Design and Development Planning
Plan and control design and development including:
- Stages of design and development
- Required review, verification, and validation activities
- Responsibilities and authorities
- Resources and interfaces
- Update plans as design progresses
- Document plans

#### 7.3.3 Design and Development Inputs
- Determine inputs relating to product requirements
- Include functional, performance, usability, and safety requirements
- Include applicable regulatory requirements and standards
- Include applicable outputs of risk management
- Include appropriate information from previous similar designs
- Review inputs for adequacy and completeness
- Resolve incomplete, ambiguous, or conflicting requirements
- Maintain records

#### 7.3.4 Design and Development Outputs
Provide outputs that:
- Meet design input requirements
- Provide appropriate information for purchasing, production, and service
- Contain or reference product acceptance criteria
- Specify characteristics essential for safe and proper use
- Document outputs and maintain as records

#### 7.3.5 Design and Development Review
- Conduct systematic reviews at suitable stages
- Evaluate ability to meet requirements
- Identify problems and propose actions
- Include representatives of functions concerned
- Maintain records including results and follow-up actions

#### 7.3.6 Design and Development Verification
- Perform verification per planned arrangements
- Ensure outputs meet input requirements
- Maintain records of verification results and follow-up actions

#### 7.3.7 Design and Development Validation
- Perform validation per planned arrangements
- Ensure product meets specified application or intended use
- Conduct validation before delivery or implementation
- Include validation under defined operating conditions
- Maintain records of validation results and follow-up actions

#### 7.3.8 Design and Development Transfer
- Document procedures for transfer to manufacturing
- Verify manufacturing output meets design output
- Ensure specification for materials, production, QC, servicing are appropriate
- Maintain records

#### 7.3.9 Control of Design and Development Changes
- Identify, document, and control changes
- Review, verify, validate, and approve changes before implementation
- Evaluate effects on constituent parts, in-process product, and delivered product
- Maintain records of changes, review results, and follow-up actions

#### 7.3.10 Design and Development Files
Establish and maintain design and development files for each type or family including:
- Design and development plan
- Design inputs
- Design outputs
- Design review, verification, validation records
- Design change records
- Risk management file

### 7.4 Purchasing

#### 7.4.1 Purchasing Process
- Ensure purchased product conforms to purchase information
- Establish documented processes for purchasing activities
- Establish criteria for evaluation and selection of suppliers
- Base criteria on ability to supply per organization's requirements
- Monitor supplier performance
- Maintain records of evaluations and follow-up actions
- Establish process for notifying suppliers of changed product requirements

#### 7.4.2 Purchasing Information
Purchasing information must include:
- Requirements for approval of product, procedures, processes, equipment
- Requirements for qualification of personnel
- Quality management system requirements
- Requirements for notification to organization of nonconforming product
- Agreement that suppliers provide notification of changes to purchased product
- Agreement that purchase information be communicated to sub-tier suppliers

#### 7.4.3 Verification of Purchased Product
- Establish and implement inspection or other activities to ensure conformity
- Document extent of verification
- Verify at supplier's premises when customer intends to perform verification at supplier
- Document verification arrangements and method of product release

### 7.5 Production and Service Provision

#### 7.5.1 Control of Production and Service Provision
Plan and carry out production under controlled conditions including:
- Availability of documented procedures and work instructions
- Availability of suitable infrastructure and work environment
- Availability of monitoring and measuring equipment
- Availability and use of suitable monitoring and measuring activities
- Implementation of product release, delivery, and post-delivery activities
- Implementation of defined operations for labelling and packaging
- Procedures for servicing if applicable

Document requirements for:
- Control of product cleanliness if applicable
- Control during installation and verification if applicable

#### 7.5.2 Cleanliness of Product
Document requirements if:
- Product is cleaned per specified requirements before sterilization and/or use
- Product cannot be cleaned before sterilization
- Product is supplied non-sterile to be cleaned and then sterilized

Establish requirements for product hygiene in manufacturing, handling, and storage.

#### 7.5.3 Installation Activities
If applicable:
- Document requirements for installation and verification
- Maintain records of installation and verification

#### 7.5.4 Servicing Activities
If servicing is specified requirement:
- Establish documented procedures, reference materials, and measurements for servicing
- Analyze records of servicing for feedback into post-production phase
- Maintain records of servicing activities

#### 7.5.5 Particular Requirements for Sterile Medical Devices
Maintain records of process parameters for sterilization of each batch.

#### 7.5.6 Validation of Processes
Validate processes where resulting output cannot be verified by subsequent monitoring or measurement, including:
- Defined criteria for review and approval
- Approval of equipment and qualification of personnel
- Use of specific methods, procedures, and acceptance criteria
- Requirements for records
- Revalidation including criteria for revalidation
- Approval of changes to process

Document requirements for validation of:
- Computer software used in production and service provision
- Sterilization processes
- Aseptic processing
- Clean room requirements if applicable

#### 7.5.7 Particular Requirements for Validation of Processes for Sterilization and Sterile Barrier Systems
Maintain records of validation of:
- Sterilization processes for each batch
- Sterile barrier systems

#### 7.5.8 Identification
- Establish documented procedures for product identification throughout realization
- Identify product by suitable means
- Maintain records of identification where traceability is a requirement

#### 7.5.9 Traceability

##### 7.5.9.1 General
Establish documented procedures defining extent of traceability including:
- Distribution and location of medical device

##### 7.5.9.2 Particular Requirements
Document procedures to maintain records of:
- Name and address of shipping package consignee
- Identification of quantity shipped
- Include requirements of applicable regulatory requirements
- Maintain traceability records for defined period

#### 7.5.10 Customer Property
- Exercise care with customer property while under organization's control
- Identify, verify, protect, and safeguard customer property
- Record and report to customer if lost, damaged, or unsuitable
- Maintain records

#### 7.5.11 Preservation of Product
- Preserve product during internal processing and delivery
- Include identification, handling, packaging, storage, and protection
- Apply to constituent parts of product
- Document requirements for special handling if applicable

### 7.6 Control of Monitoring and Measuring Equipment
- Determine monitoring and measurement to be undertaken
- Determine monitoring and measuring equipment needed
- Establish documented procedures for:
  - Calibration or verification at specified intervals before use
  - Adjustment or re-adjustment as necessary
  - Identification to enable determination of calibration status
  - Safeguarding from adjustments that would invalidate calibration
  - Protection from damage and deterioration
- Assess and record validity of previous results when found not to conform
- Maintain records of calibration and verification
- Confirm ability of computer software to satisfy intended application when used
- Undertake confirmation before initial use and reconfirm as necessary

## Clause 8: Measurement, Analysis and Improvement

### 8.1 General
- Plan and implement monitoring, measurement, analysis, and improvement processes
- Demonstrate product conformity
- Ensure QMS conformity
- Maintain QMS effectiveness
- Include determination of applicable methods including statistical techniques

### 8.2 Monitoring and Measurement

#### 8.2.1 Feedback
Establish documented procedure for feedback including early warning system for:
- Post-production information including complaints
- Requirements for reporting to regulatory authorities
- Use as potential input to risk management for monitoring and maintaining product requirements
- Use as potential input for corrective and preventive action

#### 8.2.2 Complaint Handling
Establish documented procedures for timely complaint handling including:
- Requirements and responsibilities for receiving, recording, and evaluating complaints
- Requirements and responsibilities for handling, investigating, and evaluating complaints
- Requirements and responsibilities for reporting complaint information to regulatory authorities
- Requirements for informing customer of organization's actions
- Requirements to ensure complaint information not handled by organization is transferred to organization
- Maintain records of complaints and investigations

#### 8.2.3 Reporting to Regulatory Authorities
Establish documented procedures to:
- Provide notification to regulatory authorities per applicable requirements
- Provide advisory notices per applicable requirements
- Maintain records of reporting

#### 8.2.4 Internal Audit
- Conduct internal audits at planned intervals
- Determine if QMS conforms to ISO 13485 and organization's requirements
- Determine if QMS is effectively implemented and maintained
- Plan audit program considering importance of processes, changes, and previous results
- Define audit criteria, scope, frequency, and methods
- Establish documented procedure for audits including responsibilities, requirements, and reporting
- Select objective and impartial auditors
- Maintain records of audits and results
- Identify need for corrections or corrective actions
- Conduct follow-up activities to verify implementation and effectiveness

#### 8.2.5 Monitoring and Measurement of Processes
- Apply suitable methods for monitoring and measurement of QMS processes
- Demonstrate ability to achieve planned results
- Implement corrections and corrective actions when planned results not achieved
- Maintain records

#### 8.2.6 Monitoring and Measurement of Product
- Monitor and measure product characteristics to verify conformity
- Conduct at appropriate stages per planned arrangements
- Maintain records showing conformity to acceptance criteria
- Record authority responsible for release
- Ensure product release and delivery not proceed until planned arrangements completed
- Allow release by relevant authority and customer when applicable

### 8.3 Control of Nonconforming Product

#### 8.3.1 General
- Ensure nonconforming product is identified and controlled
- Establish documented procedures for:
  - Identification, documentation, evaluation, segregation, and disposition
  - Notification to external parties
  - Review of nonconforming product
- Maintain records of nonconformities and subsequent actions including concessions

#### 8.3.2 Actions in Response to Nonconforming Product Detected Before Delivery
Deal with nonconforming product by:
- Taking action to eliminate detected nonconformity
- Authorizing use, release, or acceptance under concession per applicable regulatory requirements
- Taking action to preclude original intended use or application
- Taking action appropriate to effects of nonconformity when detected after delivery or use

Maintain records of concessions and identify authority making concession.

#### 8.3.3 Actions in Response to Nonconforming Product Detected After Delivery
When nonconforming product detected after delivery or use:
- Take action appropriate to effects of nonconformity
- Establish documented procedure including notification requirements to regulatory authorities
- Maintain records

#### 8.3.4 Rework
Establish documented procedures for rework including:
- Requirements to evaluate potential effects on medical device
- Approval before implementation
- Records of results and actions including nonconformities and rework
- Re-verification after rework
- Documentation of rework procedure before rework begins

### 8.4 Analysis of Data
- Determine, collect, and analyze appropriate data from monitoring and measurement
- Evaluate where continual improvement of QMS effectiveness can be made
- Establish documented procedures for:
  - Analysis of data to provide information on customer satisfaction
  - Analysis of conformity to product requirements
  - Analysis of characteristics and trends of processes and products including preventive action opportunities
  - Analysis of suppliers
  - Analysis of other relevant data including feedback and output from risk management
- Include use of statistical techniques if necessary
- Maintain records of analysis results

### 8.5 Improvement

#### 8.5.1 General
- Identify and implement changes to ensure and maintain QMS effectiveness
- Include use of quality policy, objectives, audit results, data analysis, corrective and preventive actions, and management review

#### 8.5.2 Corrective Action
- Establish documented procedures to:
  - Review nonconformities including complaints
  - Determine causes of nonconformities
  - Evaluate need for actions to ensure nonconformities do not recur
  - Plan and document actions needed and implement
  - Document results of actions taken
  - Review effectiveness of corrective actions taken
- Maintain records including investigation results and follow-up

#### 8.5.3 Preventive Action
- Establish documented procedures to:
  - Determine potential nonconformities and their causes
  - Evaluate need for action to prevent occurrence
  - Plan and document actions needed and implement
  - Document results of actions taken
  - Review effectiveness of preventive actions taken
- Use appropriate sources of information including:
  - Work processes and operations affecting product quality
  - Concessions
  - Analysis of data and risk management outputs
  - Medical device performance data
  - Records of nonconformities
- Maintain records including investigation results and follow-up

## Key Regulatory Updates

### FDA QMSR Harmonization (Effective February 2, 2026)
- FDA 21 CFR Part 820 has been harmonized with ISO 13485:2016
- Renamed to QMSR (Quality Management System Regulation)
- Medical Device File (MDF) replaces separate DHF, DMR, and DHR
- Organizations should prepare for transition to unified documentation approach

## References and Resources

This requirements breakdown is based on ISO 13485:2016, which was last reviewed and confirmed in 2025.

For additional guidance, refer to:
- ISO 13485:2016 standard document
- FDA Quality Management System Regulation (QMSR)
- Applicable regional regulatory requirements (EU MDR, Health Canada, etc.)
