# Data Analysis Patterns for Market Research

Templates and frameworks for conducting rigorous market analysis.

---

## Market Sizing Frameworks

### TAM/SAM/SOM Analysis

**Total Addressable Market (TAM)** represents the total revenue opportunity if 100% market share was achieved.

#### Top-Down Approach
```
TAM = Total Industry Revenue (from market research reports)

Example:
- Global AI Software Market (2024): $184 billion
- Source: Gartner, IDC, or similar
```

#### Bottom-Up Approach
```
TAM = Number of Potential Customers × Average Revenue per Customer

Example:
- Number of enterprises globally: 400 million
- Target segment (large enterprises): 50,000
- Average annual spend on solution: $500,000
- TAM = 50,000 × $500,000 = $25 billion
```

**Serviceable Addressable Market (SAM)** represents the portion of TAM that can be served given product/service capabilities.

```
SAM = TAM × Applicable Segment %

Example:
- TAM: $25 billion
- Geographic constraint (North America only): 40%
- Product fit (enterprise only): 60%
- SAM = $25B × 40% × 60% = $6 billion
```

**Serviceable Obtainable Market (SOM)** represents realistic market share capture.

```
SOM = SAM × Achievable Market Share %

Example:
- SAM: $6 billion
- Conservative market share (5%): $300 million
- Base case market share (10%): $600 million
- Optimistic market share (15%): $900 million
```

### Growth Rate Calculation

#### CAGR (Compound Annual Growth Rate)
```
CAGR = (End Value / Start Value)^(1/n) - 1

Where n = number of years

Example:
- 2020 market size: $10 billion
- 2024 market size: $18 billion
- n = 4 years
- CAGR = (18/10)^(1/4) - 1 = 15.8%
```

#### Year-over-Year Growth
```
YoY Growth = (Current Year - Previous Year) / Previous Year × 100

Example:
- 2023: $15 billion
- 2024: $18 billion
- YoY Growth = (18-15)/15 × 100 = 20%
```

---

## Porter's Five Forces Analysis

### Framework Template

For each force, assess: **HIGH**, **MEDIUM**, or **LOW**

#### 1. Threat of New Entrants

**Factors to evaluate:**
| Factor | Assessment | Notes |
|--------|------------|-------|
| Capital requirements | High/Med/Low | $ required to enter |
| Economies of scale | Strong/Moderate/Weak | Incumbent advantages |
| Brand loyalty | High/Med/Low | Customer switching cost |
| Access to distribution | Easy/Moderate/Difficult | Channel availability |
| Regulatory barriers | High/Med/Low | Licensing, certifications |
| Proprietary technology | Critical/Important/Minor | IP and know-how |
| Expected retaliation | Aggressive/Moderate/Passive | Incumbent response |

**Overall Assessment:** [HIGH/MEDIUM/LOW]

**Key Insights:** [Summary of implications]

#### 2. Bargaining Power of Suppliers

**Factors to evaluate:**
| Factor | Assessment | Notes |
|--------|------------|-------|
| Supplier concentration | High/Med/Low | Number of suppliers |
| Switching costs | High/Med/Low | Cost to change suppliers |
| Supplier differentiation | High/Med/Low | Uniqueness of inputs |
| Forward integration threat | High/Med/Low | Can suppliers compete? |
| Importance to supplier | Critical/Important/Minor | Your share of their revenue |
| Substitute inputs | Many/Some/Few | Alternatives available |

**Overall Assessment:** [HIGH/MEDIUM/LOW]

#### 3. Bargaining Power of Buyers

**Factors to evaluate:**
| Factor | Assessment | Notes |
|--------|------------|-------|
| Buyer concentration | High/Med/Low | Few large vs. many small |
| Purchase volume | Large/Medium/Small | Relative importance |
| Switching costs | Low/Med/High | Cost to change vendors |
| Price sensitivity | High/Med/Low | Focus on price vs. value |
| Backward integration threat | High/Med/Low | Can buyers self-supply? |
| Information availability | Full/Partial/Limited | Market transparency |

**Overall Assessment:** [HIGH/MEDIUM/LOW]

#### 4. Threat of Substitutes

**Factors to evaluate:**
| Factor | Assessment | Notes |
|--------|------------|-------|
| Substitute availability | Many/Some/Few | Number of alternatives |
| Price-performance ratio | Better/Same/Worse | Value comparison |
| Switching costs | Low/Med/High | Friction to substitute |
| Buyer propensity to switch | High/Med/Low | Willingness to change |
| Perceived differentiation | Low/Med/High | Unique value |

**Overall Assessment:** [HIGH/MEDIUM/LOW]

#### 5. Competitive Rivalry

**Factors to evaluate:**
| Factor | Assessment | Notes |
|--------|------------|-------|
| Number of competitors | Many/Several/Few | Market fragmentation |
| Industry growth | Slow/Moderate/Fast | Growth rate impact |
| Fixed costs | High/Med/Low | Pressure to fill capacity |
| Product differentiation | Low/Med/High | Commoditization level |
| Exit barriers | High/Med/Low | Difficulty leaving market |
| Strategic stakes | High/Med/Low | Importance to competitors |

**Overall Assessment:** [HIGH/MEDIUM/LOW]

### Five Forces Summary Table

| Force | Rating | Key Drivers | Implications |
|-------|--------|-------------|--------------|
| New Entrants | [H/M/L] | [Top factors] | [Strategic impact] |
| Supplier Power | [H/M/L] | [Top factors] | [Strategic impact] |
| Buyer Power | [H/M/L] | [Top factors] | [Strategic impact] |
| Substitutes | [H/M/L] | [Top factors] | [Strategic impact] |
| Rivalry | [H/M/L] | [Top factors] | [Strategic impact] |

**Overall Industry Attractiveness:** [ATTRACTIVE / MODERATE / UNATTRACTIVE]

---

## PESTLE Analysis

### Framework Template

#### Political Factors

| Factor | Current State | Trend | Impact | Time Horizon |
|--------|---------------|-------|--------|--------------|
| Government stability | | ↑ ↓ → | H/M/L | Short/Med/Long |
| Trade policies | | ↑ ↓ → | H/M/L | |
| Tax regulations | | ↑ ↓ → | H/M/L | |
| Government support | | ↑ ↓ → | H/M/L | |
| Political relations | | ↑ ↓ → | H/M/L | |

**Key Political Implications:** [Summary]

#### Economic Factors

| Factor | Current State | Trend | Impact | Time Horizon |
|--------|---------------|-------|--------|--------------|
| GDP growth | X.X% | ↑ ↓ → | H/M/L | |
| Interest rates | X.X% | ↑ ↓ → | H/M/L | |
| Inflation | X.X% | ↑ ↓ → | H/M/L | |
| Exchange rates | | ↑ ↓ → | H/M/L | |
| Consumer spending | | ↑ ↓ → | H/M/L | |
| Unemployment | X.X% | ↑ ↓ → | H/M/L | |

**Key Economic Implications:** [Summary]

#### Social Factors

| Factor | Current State | Trend | Impact | Time Horizon |
|--------|---------------|-------|--------|--------------|
| Demographics | | ↑ ↓ → | H/M/L | |
| Cultural attitudes | | ↑ ↓ → | H/M/L | |
| Consumer behavior | | ↑ ↓ → | H/M/L | |
| Education levels | | ↑ ↓ → | H/M/L | |
| Health consciousness | | ↑ ↓ → | H/M/L | |
| Work-life balance | | ↑ ↓ → | H/M/L | |

**Key Social Implications:** [Summary]

#### Technological Factors

| Factor | Current State | Trend | Impact | Time Horizon |
|--------|---------------|-------|--------|--------------|
| R&D activity | | ↑ ↓ → | H/M/L | |
| Technology adoption | | ↑ ↓ → | H/M/L | |
| Automation | | ↑ ↓ → | H/M/L | |
| Digital infrastructure | | ↑ ↓ → | H/M/L | |
| Innovation rate | | ↑ ↓ → | H/M/L | |
| Disruptive tech | | ↑ ↓ → | H/M/L | |

**Key Technological Implications:** [Summary]

#### Legal Factors

| Factor | Current State | Trend | Impact | Time Horizon |
|--------|---------------|-------|--------|--------------|
| Industry regulations | | ↑ ↓ → | H/M/L | |
| Data protection | | ↑ ↓ → | H/M/L | |
| Employment law | | ↑ ↓ → | H/M/L | |
| Consumer protection | | ↑ ↓ → | H/M/L | |
| IP rights | | ↑ ↓ → | H/M/L | |
| Antitrust | | ↑ ↓ → | H/M/L | |

**Key Legal Implications:** [Summary]

#### Environmental Factors

| Factor | Current State | Trend | Impact | Time Horizon |
|--------|---------------|-------|--------|--------------|
| Climate change | | ↑ ↓ → | H/M/L | |
| Sustainability reqs | | ↑ ↓ → | H/M/L | |
| Resource availability | | ↑ ↓ → | H/M/L | |
| Waste management | | ↑ ↓ → | H/M/L | |
| Carbon regulations | | ↑ ↓ → | H/M/L | |
| Environmental awareness | | ↑ ↓ → | H/M/L | |

**Key Environmental Implications:** [Summary]

---

## SWOT Analysis

### Framework Template

#### Strengths (Internal, Positive)
| Strength | Evidence | Strategic Value |
|----------|----------|-----------------|
| [Strength 1] | [Data/proof] | High/Med/Low |
| [Strength 2] | [Data/proof] | High/Med/Low |
| [Strength 3] | [Data/proof] | High/Med/Low |

**Core Strengths Summary:** [2-3 sentence synthesis]

#### Weaknesses (Internal, Negative)
| Weakness | Evidence | Severity |
|----------|----------|----------|
| [Weakness 1] | [Data/proof] | Critical/Moderate/Minor |
| [Weakness 2] | [Data/proof] | Critical/Moderate/Minor |
| [Weakness 3] | [Data/proof] | Critical/Moderate/Minor |

**Key Vulnerabilities Summary:** [2-3 sentence synthesis]

#### Opportunities (External, Positive)
| Opportunity | Size/Potential | Timeframe |
|-------------|----------------|-----------|
| [Opportunity 1] | $X / High/Med/Low | Short/Med/Long |
| [Opportunity 2] | $X / High/Med/Low | Short/Med/Long |
| [Opportunity 3] | $X / High/Med/Low | Short/Med/Long |

**Priority Opportunities Summary:** [2-3 sentence synthesis]

#### Threats (External, Negative)
| Threat | Likelihood | Impact |
|--------|------------|--------|
| [Threat 1] | High/Med/Low | High/Med/Low |
| [Threat 2] | High/Med/Low | High/Med/Low |
| [Threat 3] | High/Med/Low | High/Med/Low |

**Critical Threats Summary:** [2-3 sentence synthesis]

### SWOT Strategy Matrix

| | **Strengths** | **Weaknesses** |
|---|---------------|----------------|
| **Opportunities** | **SO Strategies** (use strengths to capture opportunities) | **WO Strategies** (overcome weaknesses to capture opportunities) |
| **Threats** | **ST Strategies** (use strengths to mitigate threats) | **WT Strategies** (minimize weaknesses and avoid threats) |

---

## BCG Growth-Share Matrix

### Framework Template

**Axes:**
- X-axis: Relative Market Share (High → Low, logarithmic scale)
- Y-axis: Market Growth Rate (High → Low, typically 10% as midpoint)

### Quadrant Definitions

| Quadrant | Growth | Share | Characteristics | Strategy |
|----------|--------|-------|-----------------|----------|
| **Stars** | High | High | Market leaders in growing markets | Invest to maintain position |
| **Cash Cows** | Low | High | Market leaders in mature markets | Harvest for cash flow |
| **Question Marks** | High | Low | Small share in growing markets | Invest selectively or divest |
| **Dogs** | Low | Low | Small share in mature markets | Divest or minimize investment |

### Product/Business Unit Analysis

| Product/BU | Market Growth | Relative Share | Quadrant | Recommended Strategy |
|------------|---------------|----------------|----------|---------------------|
| [Product A] | X.X% | X.X | Star/Cow/QM/Dog | [Strategy] |
| [Product B] | X.X% | X.X | Star/Cow/QM/Dog | [Strategy] |
| [Product C] | X.X% | X.X | Star/Cow/QM/Dog | [Strategy] |

### Portfolio Balance Assessment

| Quadrant | Number of Products | Revenue % | Investment Priority |
|----------|-------------------|-----------|---------------------|
| Stars | X | X% | High |
| Cash Cows | X | X% | Maintain |
| Question Marks | X | X% | Selective |
| Dogs | X | X% | Low/Divest |

---

## Value Chain Analysis

### Framework Template

#### Primary Activities

| Activity | Description | Value Created | Cost | Competitive Position |
|----------|-------------|---------------|------|---------------------|
| **Inbound Logistics** | Receiving, storing, inventory | | $X | Strong/Average/Weak |
| **Operations** | Manufacturing, assembly | | $X | Strong/Average/Weak |
| **Outbound Logistics** | Distribution, delivery | | $X | Strong/Average/Weak |
| **Marketing & Sales** | Promotion, sales force | | $X | Strong/Average/Weak |
| **Service** | Installation, support, repair | | $X | Strong/Average/Weak |

#### Support Activities

| Activity | Description | Value Created | Cost | Competitive Position |
|----------|-------------|---------------|------|---------------------|
| **Infrastructure** | Management, finance, legal | | $X | Strong/Average/Weak |
| **HR Management** | Recruiting, training, comp | | $X | Strong/Average/Weak |
| **Technology Dev** | R&D, process improvement | | $X | Strong/Average/Weak |
| **Procurement** | Purchasing, supplier mgmt | | $X | Strong/Average/Weak |

### Value Chain Margin Analysis

```
Total Revenue:           $XXX
- Inbound Logistics:     ($XX)
- Operations:            ($XX)
- Outbound Logistics:    ($XX)
- Marketing & Sales:     ($XX)
- Service:               ($XX)
- Support Activities:    ($XX)
= Margin:                $XX (X%)
```

### Competitive Comparison

| Activity | Company | Industry Avg | Best-in-Class | Gap |
|----------|---------|--------------|---------------|-----|
| [Activity] | X% | Y% | Z% | +/-X% |

---

## Competitive Positioning Analysis

### Framework Template

#### Positioning Dimensions

Common positioning dimension pairs:
- Price vs. Quality
- Market Focus (Niche vs. Broad)
- Solution Type (Product vs. Platform)
- Geographic Scope (Regional vs. Global)
- Customer Focus (Enterprise vs. SMB vs. Consumer)
- Innovation Level (Leader vs. Follower)

#### Competitor Mapping

| Competitor | Dimension 1 Score (1-10) | Dimension 2 Score (1-10) | Market Share | Notes |
|------------|-------------------------|-------------------------|--------------|-------|
| Company A | X | X | X% | [Position description] |
| Company B | X | X | X% | [Position description] |
| Company C | X | X | X% | [Position description] |

#### Strategic Group Identification

| Strategic Group | Companies | Characteristics | Market Share |
|-----------------|-----------|-----------------|--------------|
| Group 1: [Name] | A, B, C | [Description] | X% |
| Group 2: [Name] | D, E | [Description] | X% |
| Group 3: [Name] | F, G, H | [Description] | X% |

---

## Risk Assessment Framework

### Risk Identification

#### Risk Categories
1. **Market Risks**: Demand changes, price pressure, market shifts
2. **Competitive Risks**: New entrants, competitor moves, disruption
3. **Regulatory Risks**: New regulations, compliance requirements
4. **Technology Risks**: Obsolescence, security, integration
5. **Operational Risks**: Supply chain, quality, capacity
6. **Financial Risks**: Currency, interest rates, credit
7. **Reputational Risks**: Brand damage, social media, ethics

### Risk Assessment Matrix

| Risk ID | Risk Description | Category | Probability | Impact | Score | Priority |
|---------|------------------|----------|-------------|--------|-------|----------|
| R1 | [Description] | Market | 1-5 | 1-5 | P×I | H/M/L |
| R2 | [Description] | Competitive | 1-5 | 1-5 | P×I | H/M/L |

**Scoring Guide:**
- Probability: 1=Very Unlikely, 2=Unlikely, 3=Possible, 4=Likely, 5=Very Likely
- Impact: 1=Minimal, 2=Minor, 3=Moderate, 4=Major, 5=Severe
- Priority: Score 15-25=High, 8-14=Medium, 1-7=Low

### Risk Mitigation Planning

| Risk ID | Risk | Mitigation Strategy | Owner | Timeline | Cost |
|---------|------|---------------------|-------|----------|------|
| R1 | [Risk] | [Prevention + Response] | [Name] | [Date] | $X |

---

## Financial Analysis Patterns

### Revenue Projection Model

```
Year N Revenue = Year N-1 Revenue × (1 + Growth Rate)

Or bottom-up:
Revenue = Customers × Revenue per Customer × Retention Rate
        + New Customers × Revenue per Customer × (1 - Churn Rate)
```

### Scenario Analysis Template

| Metric | Conservative | Base Case | Optimistic |
|--------|--------------|-----------|------------|
| Market Growth | X% | Y% | Z% |
| Market Share | X% | Y% | Z% |
| Pricing | $X | $Y | $Z |
| Gross Margin | X% | Y% | Z% |
| **Revenue Y5** | $X | $Y | $Z |
| **EBITDA Y5** | $X | $Y | $Z |

### Key Financial Metrics

| Metric | Formula | Target |
|--------|---------|--------|
| Gross Margin | (Revenue - COGS) / Revenue | X% |
| EBITDA Margin | EBITDA / Revenue | X% |
| Customer Acquisition Cost | Sales & Marketing / New Customers | $X |
| Lifetime Value | ARPU × Gross Margin × Lifetime | $X |
| LTV/CAC Ratio | LTV / CAC | >3x |
| Payback Period | CAC / (ARPU × Gross Margin × 12) | <X months |

---

## Data Collection Checklist

### Market Size Data
- [ ] Current market size (with year and source)
- [ ] Historical market size (5-10 years)
- [ ] Market growth projections (5-10 years)
- [ ] CAGR (historical and projected)
- [ ] Regional breakdown
- [ ] Segment breakdown

### Competitive Data
- [ ] Market share by company (top 10)
- [ ] Revenue by competitor
- [ ] Growth rates by competitor
- [ ] Strategic moves (M&A, partnerships, launches)
- [ ] Pricing information
- [ ] Product/service offerings

### Customer Data
- [ ] Customer segments and sizes
- [ ] Segment growth rates
- [ ] Average deal size by segment
- [ ] Customer acquisition cost
- [ ] Customer lifetime value
- [ ] Churn rates

### Industry Data
- [ ] Key industry trends
- [ ] Regulatory developments
- [ ] Technology trends
- [ ] Economic indicators
- [ ] Demographic trends

---

## Research Sources

### Primary Research
- Customer interviews
- Expert interviews
- Surveys
- Focus groups

### Secondary Research
- Market research reports (Gartner, Forrester, IDC, McKinsey)
- Industry associations
- Government statistics
- Company annual reports
- SEC filings (10-K, 10-Q)
- Earnings call transcripts
- Trade publications
- Academic journals
- News articles

### Data Validation
- Cross-reference multiple sources
- Check date currency (prefer <2 years old)
- Verify methodology
- Note confidence levels
- Document assumptions
