# Research Grants Skill

## Overview

Comprehensive skill for writing competitive research grant proposals focused on four major U.S. funding agencies:
- **NSF** (National Science Foundation)
- **NIH** (National Institutes of Health)
- **DOE** (Department of Energy)
- **DARPA** (Defense Advanced Research Projects Agency)

## What This Skill Provides

### Agency-Specific Guidance

Detailed reference materials for each funding agency including:
- Mission and priorities
- Review criteria and scoring
- Proposal structure and page limits
- Budget requirements
- Submission processes
- Tips for competitive applications

### Core Components

- **Specific Aims Pages** (NIH): Template and detailed guide for the critical 1-page aims page
- **Project Summaries** (NSF): Template for the required Overview, Intellectual Merit, and Broader Impacts
- **Broader Impacts**: Comprehensive strategies for NSF's equally-weighted review criterion
- **Budget Justification**: Templates and examples for personnel, equipment, travel, and supplies
- **Review Criteria**: Understanding what reviewers look for at each agency

### Templates

Ready-to-use templates for:
- NSF Project Summary
- NIH Specific Aims Page
- Budget Justifications
- (Additional templates in development)

## How to Use This Skill

### Quick Start

When writing a grant proposal, specify the agency and grant type:

```
> Help me write an NSF proposal for computational biology research
> I need to draft NIH R01 Specific Aims for my cancer research project
> What should I include in a DOE ARPA-E concept paper?
> I'm applying for a DARPA program - help me structure the proposal
```

### Detailed Guidance

For in-depth help on specific components:

```
> Help me write compelling broader impacts for my NSF proposal
> Review my NIH Specific Aims page
> What should I include in my budget justification?
> How do I respond to reviewer comments in an NIH resubmission?
```

### Agency Comparison

```
> What are the key differences between NSF and NIH proposals?
> Should I apply to DOE or DARPA for my energy technology project?
```

## Key Features

### NSF Proposals

- **Intellectual Merit + Broader Impacts** (equally weighted)
- Strategies for substantive, measurable broader impacts
- Integration of research and education
- Broadening participation in STEM
- 15-page project description limits (most programs)

### NIH Proposals

- **Specific Aims Page**: The most critical page (detailed 1-page guide included)
- **Research Strategy**: Significance, Innovation, Approach sections
- **Preliminary Data**: Essential for R01 applications
- Rigor and reproducibility requirements
- Modular vs. detailed budgets
- Resubmission strategies (A1 applications)

### DOE Proposals

- **Energy relevance** and alignment with DOE mission
- **Technology readiness levels** (TRLs)
- National laboratory collaborations
- Cost sharing requirements (especially ARPA-E)
- Commercialization pathways
- User facilities access

### DARPA Proposals

- **DARPA-hard problems**: High-risk, high-reward
- **Heilmeier Catechism**: The 8 critical questions
- Program Manager engagement (critical!)
- Phase-based structure with milestones
- Technology transition planning
- Demonstration and prototypes

## Reference Materials

### Agency Guidelines
- `references/nsf_guidelines.md` - Comprehensive NSF guidance
- `references/nih_guidelines.md` - NIH mechanisms and review criteria
- `references/doe_guidelines.md` - DOE offices and programs
- `references/darpa_guidelines.md` - DARPA structure and strategy

### Specialized Guides
- `references/broader_impacts.md` - NSF broader impacts strategies
- `references/specific_aims_guide.md` - NIH Specific Aims page mastery
- `references/budget_preparation.md` - Budget development (coming soon)
- `references/review_criteria.md` - Comparative review criteria (coming soon)
- `references/timeline_planning.md` - Project management (coming soon)

### Templates
- `assets/nsf_project_summary_template.md`
- `assets/nih_specific_aims_template.md`
- `assets/budget_justification_template.md`

## Success Metrics

Typical success rates by agency:
- **NSF**: 15-30% (varies by program)
- **NIH R01**: ~20% overall (~27% for Early Stage Investigators)
- **DOE Office of Science**: 20-40% (varies by program)
- **ARPA-E**: 2-5% (concept papers to awards)
- **DARPA**: Highly variable by program

## Common Use Cases

### First-Time Applicants
```
> I've never written a grant before. Help me understand NSF proposal structure.
> What are the most common mistakes in first NIH R01 applications?
```

### Experienced Investigators
```
> Help me strengthen the innovation section for my NIH resubmission
> I need to address broader impacts more substantively for NSF
> What's the best way to show technology transition for DARPA?
```

### Career Development
```
> Help me write a competitive NSF CAREER proposal
> What should I emphasize in an NIH K99/R00 application?
```

### Multi-Agency Strategy
```
> Should I submit this to NSF or NIH?
> Can I submit similar proposals to DOE and DARPA?
```

## Best Practices

### Start Early
- NSF/NIH proposals: Start 3-6 months before deadline
- DOE/DARPA proposals: 4-6 months (especially if involving national labs)

### Get Feedback
- Mock review sessions
- Colleagues in and outside your field
- Institutional grant support offices
- Program officers (when appropriate)

### Understand Review Criteria
- NSF: Intellectual Merit + Broader Impacts (equal weight)
- NIH: Significance, Investigator, Innovation, Approach, Environment (scored 1-9)
- DOE: Technical merit, qualifications, budget, relevance
- DARPA: Innovation, impact, team, feasibility, transition

### Common Success Factors

✅ Clear, compelling significance and innovation
✅ Strong preliminary data (NIH, DOE)
✅ Detailed, rigorous methodology
✅ Realistic timeline and budget
✅ Specific, measurable outcomes
✅ Strong team with relevant expertise
✅ Integration of broader impacts (NSF)
✅ Technology transition plan (DOE, DARPA)

## Integration with Other Skills

This skill works well with:
- **Scientific Writing**: For clear, compelling prose
- **Literature Review**: For background sections
- **Research Lookup**: For finding relevant citations
- **Peer Review**: For self-assessment before submission

## Updates and Additions

This skill is continuously updated with:
- Current agency priorities
- Recent policy changes
- New funding mechanisms
- Additional templates and examples

### Coming Soon
- More budget examples
- Timeline templates
- Collaboration letter templates
- Data management plan templates
- Facilities and equipment description templates

## Tips for Maximum Effectiveness

### For NSF Proposals
1. Start with Specific Aims/Objectives (even though not required)
2. Develop broader impacts with same rigor as research plan
3. Use figures and diagrams liberally (make it skimmable)
4. Address both review criteria explicitly
5. Get feedback from outside your immediate field

### For NIH Proposals
1. Perfect your Specific Aims page first (10+ drafts)
2. Include substantial preliminary data
3. Address rigor and reproducibility explicitly
4. Identify potential problems proactively with alternatives
5. Make sure your aims are independent but synergistic

### For DOE Proposals
1. Emphasize energy relevance and impact
2. Include quantitative metrics (cost, efficiency, emissions)
3. Develop pathway to deployment or commercialization
4. Consider national laboratory partnerships
5. Address technology readiness levels

### For DARPA Proposals
1. Contact the Program Manager early (essential!)
2. Attend Proposers Day events
3. Focus on breakthrough innovation (10x, not 10%)
4. Answer the Heilmeier Catechism explicitly
5. Develop clear transition strategy

## Resources Beyond This Skill

### Official Resources
- NSF: https://www.nsf.gov/funding/
- NIH: https://grants.nih.gov/
- DOE: https://science.osti.gov/grants/
- DARPA: https://www.darpa.mil/work-with-us/opportunities

### Institutional Resources
- Your institution's Office of Sponsored Research
- Grant writing workshops
- Internal review programs
- Successful proposal archives

### Professional Development
- Grant writing courses and webinars
- Agency-specific guidance documents
- Professional society resources
- Mentoring networks

## Questions or Issues?

This skill is designed to be comprehensive but may not cover every specific situation. When using this skill:

1. **Be specific** about your agency, program, and grant type
2. **Provide context** about your research area and career stage
3. **Ask follow-up questions** for clarification
4. **Request examples** for specific sections you're working on

## Version History

- **v1.0** (January 2025): Initial release with NSF, NIH, DOE, DARPA guidance
- Comprehensive reference materials for all four agencies
- Templates for key proposal components
- Specific Aims and Broader Impacts detailed guides

---

**Remember**: Grant writing is both an art and a science. This skill provides the frameworks, strategies, and best practices—but your unique research vision, preliminary data, and team expertise are what will ultimately win funding. Start early, seek feedback, revise extensively, and don't be discouraged by rejection. Even the most successful scientists face many declined proposals before achieving funding success.

Good luck with your proposals! 🎯
