# DOE (Department of Energy) Grant Writing Guidelines

## Agency Overview

**Mission**: Ensure America's security and prosperity by addressing energy, environmental, and nuclear challenges through transformative science and technology solutions

**Annual Budget**: ~$50 billion (includes national laboratories, energy programs, nuclear security)

**Website**: https://www.energy.gov

**Key Characteristics**:
- Focus on energy, climate, environmental, computational, and physical sciences
- Operates 17 national laboratories (largest science infrastructure in US)
- Strong emphasis on industry partnerships and commercialization
- Basic science through applied research and development
- Cost sharing often required
- National security and energy security priorities

## Major DOE Offices and Programs

### Office of Science (SC)

**Budget**: ~$8 billion (largest supporter of physical sciences research in US)

**Mission**: Deliver scientific discoveries and major scientific tools to transform our understanding of nature and advance energy, economic, and national security

**Program Offices**:

1. **Advanced Scientific Computing Research (ASCR)**
   - High-performance computing
   - Applied mathematics
   - Computational sciences
   - Exascale computing

2. **Basic Energy Sciences (BES)**
   - Materials science and engineering
   - Chemical sciences
   - Condensed matter and materials physics
   - User facilities (light sources, neutron sources)

3. **Biological and Environmental Research (BER)**
   - Biological systems science
   - Climate and environmental sciences
   - Environmental molecular sciences laboratory

4. **Fusion Energy Sciences (FES)**
   - Plasma physics
   - Fusion energy development
   - ITER collaboration

5. **High Energy Physics (HEP)**
   - Particle physics
   - Accelerator science
   - Quantum information science

6. **Nuclear Physics (NP)**
   - Nuclear structure and dynamics
   - Relativistic heavy ions
   - Fundamental symmetries

**Funding Mechanisms**:
- **Early Career Research Program**: $750K over 5 years for early career scientists
- **Funding Opportunity Announcements (FOAs)**: Program-specific solicitations
- **Laboratory Directed Research and Development (LDRD)**: For national lab staff

### ARPA-E (Advanced Research Projects Agency-Energy)

**Mission**: Advance high-potential, high-impact energy technologies that are too early for private-sector investment

**Characteristics**:
- High-risk, high-reward transformative energy technologies
- Requires cost sharing (typically 20% for universities, more for industry)
- Emphasis on pathway to commercialization
- Strong project management and milestones
- Budget: ~$500M annually

**Program Types**:
- **Focused Programs**: Specific technology areas (announced via FOAs)
- **OPEN**: General solicitation across all energy technologies
- **SCALEUP**: Bridging from lab to market

**Typical Funding**:
- $1-10M per project
- 1-3 years duration
- Technology transition focus

### Office of Energy Efficiency and Renewable Energy (EERE)

**Mission**: Accelerate development and deployment of clean energy technologies

**Program Areas**:
- **Solar Energy Technologies Office (SETO)**
- **Wind Energy Technologies Office (WETO)**
- **Water Power Technologies Office (WPTO)**
- **Geothermal Technologies Office (GTO)**
- **Building Technologies Office (BTO)**
- **Advanced Manufacturing Office (AMO)**
- **Vehicle Technologies Office (VTO)**
- **Bioenergy Technologies Office (BETO)**
- **Hydrogen and Fuel Cell Technologies Office (HFTO)**

**Funding Mechanisms**:
- FOAs for specific technology areas
- Small Business Innovation Research (SBIR)
- Technology Commercialization Fund (TCF)

### Office of Fossil Energy and Carbon Management (FECM)

**Focus**: Carbon capture, utilization, and storage; hydrogen; critical minerals

### Office of Nuclear Energy (NE)

**Focus**: Advanced reactor technologies, nuclear fuel cycle, university programs

## DOE Proposal Structure

DOE proposal requirements vary significantly by program office and FOA. **Always read the specific FOA carefully.**

### Common Elements

#### Project Narrative (varies, typically 10-20 pages)

**Typical Structure**:

1. **Executive Summary / Abstract** (1 page)
   - Project objectives and technical approach
   - Expected outcomes and impact
   - Team qualifications
   - Alignment with DOE mission

2. **Background and Motivation** (2-3 pages)
   - Current state of technology or knowledge
   - Problem or opportunity
   - Why DOE investment is needed
   - Alignment with program goals

3. **Technical Approach and Innovation** (5-10 pages)
   - Detailed technical plan
   - Methodology and approach
   - Innovation and novelty
   - Risk assessment and mitigation
   - Go/no-go decision points
   - Performance metrics

4. **Impact and Energy Relevance** (1-2 pages)
   - Expected technical outcomes
   - Energy impact (cost, efficiency, emissions)
   - Pathway to deployment or commercialization
   - Economic benefits
   - Timeline to market (for applied programs)

5. **Management Plan** (1-2 pages)
   - Team organization and roles
   - Timeline and milestones
   - Risk management
   - Communication and reporting

6. **Qualifications and Resources** (1-2 pages)
   - Team expertise and experience
   - Relevant prior work
   - Facilities and equipment
   - National lab or industry partners

#### Budget and Budget Justification

**Federal Cost Share**:
- Specify DOE funding requested by year
- Break down by category (labor, equipment, travel, etc.)
- Detailed justification for each item

**Cost Share** (often required):
- Specify source (cash vs. in-kind)
- Document commitment (letters from sponsors)
- Typical requirements:
  - Universities: 20% (ARPA-E)
  - Industry: 50% or more
  - National labs: Varies

**Budget Categories**:
- Labor (personnel with hours/rates)
- Fringe benefits
- Travel
- Equipment and capital items
- Materials and supplies
- Other direct costs
- Subawards/subcontracts
- Indirect costs (F&A)

#### Biographical Sketches

**Format**: Often DOE-specific or NSF-style
- Professional preparation
- Appointments
- Relevant publications (5-10 most relevant)
- Synergistic activities
- Collaborators

#### Work Breakdown Structure (WBS)

**Often Required**: Detailed breakdown of tasks, milestones, and deliverables
- Task structure aligned with budget
- Quarterly or annual milestones
- Deliverables for each task
- Responsible parties

#### Letters of Commitment

**Required for**:
- Cost share partners
- Collaborating institutions
- National laboratory partnerships
- Industry partners
- Access to facilities or resources

**Must Include**:
- Specific commitment (funding, personnel, equipment)
- Signed by authorized representative
- On institutional letterhead

#### Facilities and Equipment

**Describe**:
- Available facilities relevant to project
- Major equipment accessible
- Computational resources
- Unique capabilities

#### Data Management Plan (DMP)

**Increasingly Required**:
- Types of data to be generated
- Standards and formats
- Access and sharing policies
- Long-term preservation
- Compliance with DOE policies

## Review Criteria

### Office of Science (SC) General Criteria

Proposals typically evaluated on:

1. **Scientific and/or Technical Merit** (35-40%)
   - Importance and relevance of research
   - Appropriateness of proposed method or approach
   - Scientific or technical innovation
   - Clarity of objectives and expected outcomes

2. **Appropriateness of Proposed Method or Approach** (25-30%)
   - Technical feasibility
   - Likelihood of success
   - Adequacy of project design
   - Rigor of technical approach

3. **Competency of Personnel and Adequacy of Facilities** (20-25%)
   - Qualifications of PI and team
   - Track record in relevant areas
   - Access to necessary facilities and equipment
   - Institutional support

4. **Reasonableness and Appropriateness of Budget** (10-15%)
   - Budget aligned with proposed work
   - Appropriate allocation of resources
   - Cost effectiveness

5. **Relevance to DOE Mission and Program Goals** (10-15%)
   - Alignment with program priorities
   - Contribution to DOE mission
   - Potential impact on energy/environment

### ARPA-E Review Criteria

**ARPA-E uses concept paper → full application process**

**Concept Paper Review** (typically 3-5 pages):
- Technical innovation and impact
- Potential for transformative advance
- Relevance to energy applications
- Feasibility (team, approach)

**Full Application Review** (if invited):

1. **Impact** (40%)
   - Potential to dramatically improve energy technology
   - Energy and economic impact
   - Transformative vs. incremental
   - Pathway to market adoption

2. **Innovation/Technical Merit** (30%)
   - Novel approach or technology
   - Technical rigor and feasibility
   - Likelihood of meeting targets
   - Risk and risk mitigation

3. **Qualifications** (20%)
   - Team expertise and experience
   - Resources and capabilities
   - Management plan
   - Track record

4. **Workplan** (10%)
   - Clear milestones and go/no-go points
   - Realistic timeline
   - Appropriate budget
   - Risk management

### Technology-to-Market (T2M) Evaluation (ARPA-E)

**Critical Component**: Path to commercialization

**Assessed**:
- Market opportunity and size
- Competitive landscape
- Barriers to adoption
- Go-to-market strategy
- Partnership and commercialization plan
- Economic viability

**Common Mistakes**:
- Underestimating time to market
- Ignoring competing technologies
- Unrealistic cost projections
- No clear adoption pathway

## DOE-Specific Considerations

### National Laboratory Collaboration

**Benefits**:
- Access to unique facilities and expertise
- Leveraging world-class capabilities
- Credibility and track record

**Mechanisms**:
- **Subcontract**: Lab is subcontractor to university/company
- **Cooperative Research and Development Agreement (CRADA)**: Partnership with industry
- **User Facility Proposal**: Access to major DOE user facilities
- **Strategic Partnership Project (SPP)**: Formal collaboration

**Process**:
- Identify appropriate lab partner early
- Contact lab scientist to discuss collaboration
- Develop work scope and budget together
- Obtain lab approval (can take 2-3 months)
- Include letter of commitment

**Major National Labs**:
- Argonne (ANL), Brookhaven (BNL), Lawrence Berkeley (LBNL)
- Oak Ridge (ORNL), Pacific Northwest (PNNL), SLAC
- Sandia (SNL), Los Alamos (LANL), Lawrence Livermore (LLNL)
- National Renewable Energy Lab (NREL), Idaho (INL), Fermilab

### User Facilities

**DOE operates 28 major user facilities** open to researchers

**Types**:
- **Light Sources**: X-ray and neutron scattering (APS, NSLS-II, ALS, etc.)
- **Nanoscale Science Centers**: Fabrication and characterization
- **High-Performance Computing**: Supercomputing centers (OLCF, NERSC, ALCF)
- **Genomic Science**: JGI, EMSL
- **Accelerators and Detectors**: Particle and nuclear physics facilities

**Access**:
- Submit user proposal (separate from research proposal)
- Peer-reviewed allocation of beam time or computing hours
- No cost for non-proprietary research
- Can include user facility access in grant proposals

### Cost Sharing Requirements

**Varies by Program**:
- **Office of Science**: Generally not required (except specific FOAs)
- **ARPA-E**: Required (typically 20% universities, 50%+ industry)
- **EERE**: Often required (varies by program)
- **FECM**: Often required

**Types**:
- **Cash**: Direct contribution of funds
- **In-kind**: Personnel time, equipment use, materials
- **Third-party**: Contribution from collaborator or sponsor

**Requirements**:
- Must be documented and verifiable
- Cannot be used for other federal awards
- Must be from non-federal sources (generally)
- Need letters of commitment

### Technology Readiness Levels (TRLs)

**DOE uses TRL scale 1-9** for technology development programs

**TRL Definitions**:
- **TRL 1-3**: Basic research (idea → proof of concept)
- **TRL 4-6**: Development (component → system prototype)
- **TRL 7-9**: Demonstration and deployment (prototype → commercial)

**Funding by TRL**:
- **Office of Science**: TRL 1-3 (basic research)
- **ARPA-E**: TRL 2-5 (proof of concept → prototype)
- **EERE**: TRL 4-8 (development → demonstration)

**Specify in Proposal**:
- Current TRL of technology
- Target TRL at project end
- Path from current to target

### Intellectual Property and Data Rights

**Standard Terms**:
- Awardee generally retains IP rights
- Government retains license for government purposes
- Must report inventions to DOE
- May have data sharing requirements

**Industry Partners**:
- Negotiate IP and data rights in advance
- Protected CRADA information (5 years)
- Background IP vs. foreground IP

### Teaming and Partnerships

**Encouraged for**:
- University-national lab partnerships
- University-industry partnerships
- Multi-institutional teams
- International collaborations (with approval)

**Teaming Partner Lists**: ARPA-E and other programs often provide teaming lists or events

## Submission Process

### Finding Opportunities

**Sources**:
- **EERE Exchange**: https://eere-exchange.energy.gov
- **ARPA-E OPEN**: https://arpa-e.energy.gov
- **Office of Science FOAs**: https://science.osti.gov/grants/Funding-Opportunities
- **Grants.gov**: Federal grants database
- **FedConnect**: Subscribe to FOA announcements

### Application Systems

**Varies by Office**:
- **EERE Exchange**: EERE programs
- **PAMS (Portfolio Analysis and Management System)**: Office of Science
- **ARPA-E OPEN**: ARPA-E submissions
- **Grants.gov**: Some programs

**Registration Required** (can take 2-4 weeks):
- SAM.gov (System for Award Management)
- Grants.gov
- DOE program-specific systems

### Proposal Development Timeline

**Recommended Timeline**:
- **3-6 months before deadline**: Identify FOA, assemble team, contact lab partners
- **2-3 months**: Develop technical approach, secure commitments
- **1-2 months**: Draft proposal, prepare budget
- **2-4 weeks**: Internal review, revisions
- **1 week**: Final preparation, institutional approvals
- **48 hours early**: Submit (don't wait for deadline)

### Required Registrations

**Before First Submission**:
1. **SAM.gov**: System for Award Management (2-3 weeks)
2. **Grants.gov**: Account and authorization (1 week)
3. **FedConnect**: Optional, for notifications
4. **PAMS/EERE Exchange**: Program-specific (immediate)

**Institutional Requirements**:
- Authorized Organizational Representative (AOR)
- Institutional approvals
- Cost accounting systems

## Review and Award Process

### Timeline

**Varies by Program**:
- **Office of Science**: 3-6 months
- **ARPA-E**: 4-6 months (after full application invitation)
- **EERE**: 3-6 months

**Steps**:
1. Administrative compliance check
2. Peer review (external reviewers)
3. Program manager evaluation
4. Selection for award negotiation
5. Budget negotiation
6. Award issuance

### Reviewer Feedback

**Provided**:
- Reviewer comments (often anonymized)
- Strengths and weaknesses
- Scores by criterion

**Not Always Provided**: Some programs provide limited feedback

### Success Rates

**Varies Widely**:
- **Office of Science Early Career**: ~10-15%
- **ARPA-E OPEN**: ~2-5% (concept papers → awards)
- **EERE FOAs**: 10-30% (depends on program)
- **Office of Science FOAs**: 20-40% (varies)

## Writing Tips for Competitive DOE Proposals

### Do's

✅ **Align with DOE mission** - Energy, environment, or national security relevance
✅ **Emphasize impact** - How will this advance energy technology or science?
✅ **Quantify outcomes** - Energy savings, efficiency gains, cost reductions
✅ **Show pathway to deployment** - For applied programs, how will technology reach market?
✅ **Leverage DOE capabilities** - National labs, user facilities, unique resources
✅ **Include strong management plan** - Milestones, go/no-go, risk mitigation
✅ **Demonstrate team qualifications** - Track record in relevant area
✅ **Be specific about innovation** - What's new and why it matters
✅ **Address technology readiness** - Current TRL and path forward
✅ **Secure cost share commitments** - If required, get letters early

### Don'ts

❌ **Don't ignore FOA requirements** - Each FOA is different, read carefully
❌ **Don't underestimate timeline** - Allow time for registrations and approvals
❌ **Don't forget cost share** - If required, must be documented
❌ **Don't overlook lab partnerships** - Can strengthen proposal significantly
❌ **Don't be vague about impact** - Need quantitative energy/economic metrics
❌ **Don't ignore commercialization** - For applied programs, market path is critical
❌ **Don't submit without institutional approval** - Need AOR sign-off
❌ **Don't wait for deadline** - Systems crash, submit 48 hours early
❌ **Don't propose basic science to ARPA-E** - Or applied research to Office of Science
❌ **Don't forget TRL discussion** - Important for technology programs

### Common Mistakes

1. **Wrong Program**: Proposing to inappropriate office or program
2. **Insufficient Energy Relevance**: Not clearly tied to DOE mission
3. **Weak Commercialization Plan**: For ARPA-E and EERE, lack of market strategy
4. **Unrealistic Milestones**: Overly optimistic timelines
5. **Poor Budget Justification**: Budget doesn't align with technical plan
6. **Missing Cost Share**: If required, not documented properly
7. **Weak Team**: Insufficient expertise or track record
8. **Ignoring Competing Technologies**: Not addressing competitive landscape

## Recent DOE Priorities (2024-2025)

### Key Focus Areas

- **Clean Energy Transition**: Renewable energy, storage, grid modernization
- **Carbon Management**: Carbon capture, utilization, storage, removal
- **Critical Materials**: Supply chain security, recycling, substitutes
- **Advanced Manufacturing**: Energy-efficient processes, sustainable materials
- **Quantum Information Science**: Computing, sensing, communications
- **Fusion Energy**: Accelerating fusion development
- **Hydrogen Economy**: Production, storage, utilization
- **Nuclear Energy**: Advanced reactors, microreactors, fuel cycle
- **Climate Adaptation**: Climate modeling, resilience, impacts
- **Energy Equity**: Environmental justice, workforce development

### Major Initiatives

- **Energy Earthshots**: Ambitious R&D goals (Hydrogen Shot, Long Duration Storage, Carbon Negative, etc.)
- **Bipartisan Infrastructure Law**: $62B for DOE programs
- **Inflation Reduction Act**: Clean energy tax credits and programs
- **CHIPS and Science Act**: Microelectronics, quantum, clean energy manufacturing

## Resources

- **DOE Office of Science**: https://science.osti.gov
- **ARPA-E**: https://arpa-e.energy.gov
- **EERE**: https://www.energy.gov/eere
- **DOE National Laboratories**: https://www.energy.gov/national-laboratories
- **EERE Exchange**: https://eere-exchange.energy.gov
- **Grants.gov**: https://www.grants.gov
- **SAM.gov**: https://sam.gov

---

**Key Takeaway**: DOE proposals require strong alignment with energy and national security missions, clear pathway to impact (especially for applied programs), and often benefit from partnerships with national laboratories or industry. Cost sharing, technology readiness levels, and commercialization strategies are critical considerations for competitive proposals.

