# Goal Setting Frameworks for Treatment Plans

## Overview

Effective treatment goals are the cornerstone of successful patient care. This reference provides comprehensive guidance on creating SMART goals, patient-centered outcome selection, and shared decision-making processes for treatment planning across all medical specialties.

## SMART Goals Framework

### Definition

**SMART** is a mnemonic for goal criteria that ensure objectives are well-defined and achievable:
- **S**pecific
- **M**easurable
- **A**chievable
- **R**elevant
- **T**ime-bound

### 1. Specific

Goals must be clear, well-defined, and unambiguous.

**Components of Specificity**:
- **What**: Exactly what will be accomplished
- **Who**: Who is responsible (patient, provider, both)
- **Where**: Context or setting if relevant
- **Which**: Specific aspect of health/function addressed

**Examples**:

| Poor (Vague) | Good (Specific) |
|--------------|-----------------|
| "Feel better" | "Reduce depressive symptoms as measured by PHQ-9 score" |
| "Improve diabetes" | "Reduce HbA1c from current 8.5% to less than 7%" |
| "Get stronger" | "Increase right quadriceps strength from 3/5 to 4/5 on manual muscle testing" |
| "Lose weight" | "Reduce body weight by 10 pounds (from 210 to 200 lbs)" |
| "Exercise more" | "Walk 30 minutes, 5 days per week" |

### 2. Measurable

Goals must include quantifiable metrics or observable criteria to track progress.

**Types of Measurement**:
- **Quantitative**: Numbers, percentages, scores, scales
  - Lab values: HbA1c, LDL cholesterol, eGFR
  - Vital signs: BP, heart rate, weight
  - Scales: Pain (0-10 NRS), PHQ-9, GAD-7, FIM
  - Functional: Distance walked, ROM degrees, strength grades
  
- **Qualitative Observable**: Behaviors that can be observed and verified
  - "Patient demonstrates proper insulin injection technique"
  - "Patient ambulates 150 feet with walker independently"
  - "Patient follows 2-step commands"

**Examples**:

| Not Measurable | Measurable |
|----------------|------------|
| "Better blood pressure" | "Systolic BP <130 mmHg and diastolic BP <80 mmHg" |
| "Less pain" | "Pain intensity reduced from 7/10 to ≤4/10 on numeric rating scale" |
| "Improved mobility" | "Ambulate 300 feet with front-wheeled walker, supervision level" |
| "Take medications regularly" | "Medication adherence >90% as measured by refill rates" |
| "Sleep better" | "Sleep 7-8 hours nightly with <2 awakenings per night" |

### 3. Achievable

Goals must be realistic given patient's capabilities, resources, and circumstances.

**Factors to Consider**:
- **Patient capabilities**: Physical, cognitive, psychological capacity
- **Severity of condition**: Advanced disease may have limited improvement potential
- **Treatment efficacy**: What can realistically be achieved with available treatments
- **Resources**: Access to care, medications, equipment, support
- **Time available**: Adequate time to achieve the goal
- **Motivation**: Patient's readiness to change and engagement

**Setting Achievable Goals**:
- Start with baseline assessment
- Know expected treatment effects (e.g., metformin reduces HbA1c by 1-1.5%)
- Set incremental goals for large changes (lose 5 lbs, then 10 lbs, rather than jump to 50 lbs)
- Challenge but don't overwhelm patient
- Adjust goals based on progress

**Examples**:

| Not Achievable | Achievable |
|----------------|------------|
| "Marathon ready in 1 month" (sedentary 70-year-old post-MI) | "Walk 1 mile continuously in 3 months" |
| "HbA1c from 12% to <6% in 6 weeks" | "HbA1c from 12% to <9% in 3 months, <7% in 6 months" |
| "Full knee ROM 0-140° by POD 3" (post-TKA) | "Knee ROM 0-90° by week 2, 0-110° by week 6" |
| "Cure chronic pain" | "Reduce pain from 7/10 to 4/10 and improve function by 30%" |

### 4. Relevant

Goals must align with patient values, priorities, and overall treatment objectives.

**Relevance Criteria**:
- **Patient-centered**: Matters to the patient, reflects their priorities
- **Clinically meaningful**: Achieving goal improves health or quality of life
- **Aligned with diagnosis**: Goal addresses the condition being treated
- **Appropriate timing**: Right goal for current phase of treatment
- **Integrated**: Fits with other treatment goals

**Assessing Relevance**:
- Ask patient: "What's most important to you?" "What do you want to be able to do?"
- Ensure goals address functional limitations that matter to patient
- Connect clinical metrics to patient-meaningful outcomes (e.g., "HbA1c <7% reduces risk of vision loss")
- Avoid provider-driven goals that don't resonate with patient

**Examples**:

| Less Relevant | More Relevant |
|---------------|---------------|
| "Reduce medication count" (when medications controlling symptoms well) | "Simplify regimen to improve adherence" (if missing doses due to complexity) |
| "Perfect blood sugars" (patient's priority is energy) | "Improve energy levels through better glucose control" |
| "Walk 5 miles" (patient just wants to shop independently) | "Walk through grocery store without assistance" |

### 5. Time-Bound

Goals must have specific deadlines or timeframes for achievement.

**Timeframe Considerations**:
- **Short-term goals**: Days to 3 months
- **Intermediate goals**: 3-6 months
- **Long-term goals**: 6-12 months or longer for chronic conditions
- **Reassessment intervals**: Check progress at defined intervals

**Time Elements to Include**:
- Target date or timeframe
- Checkpoint dates for progress review
- Frequency of actions (e.g., "exercise 30 min, 5x/week")

**Examples**:

| Not Time-Bound | Time-Bound |
|----------------|------------|
| "Eventually lose weight" | "Lose 15 pounds within 6 months (approximately 1-2 lbs/week)" |
| "Attend physical therapy" | "Complete 12 physical therapy sessions over 8 weeks, 1-2x weekly" |
| "When ready, return to work" | "Return to modified duty work within 12 weeks post-surgery" |
| "Improve depression symptoms" | "Reduce PHQ-9 score from 18 to <10 within 8 weeks of starting SSRI and CBT" |

## Creating SMART Goals: Step-by-Step Process

### Step 1: Assess Baseline
- Identify current status: symptoms, lab values, functional level
- Use standardized assessments when available
- Document quantitative baseline

### Step 2: Identify Desired Outcome
- What needs to improve?
- Engage patient: "What would you like to be different?"
- Consider clinical needs and patient priorities

### Step 3: Make It Specific
- Define exact outcome
- Eliminate vague language
- Include all relevant details

### Step 4: Add Measurement
- How will progress be tracked?
- What metric or observable behavior?
- Baseline → Target value

### Step 5: Reality Check (Achievable?)
- Is this possible given patient's condition, resources, treatment effects?
- May need to adjust expectations
- Set incremental goals if needed

### Step 6: Ensure Relevance
- Does patient care about this goal?
- Is it clinically meaningful?
- Does it align with overall treatment plan?

### Step 7: Set Timeline
- When will goal be achieved?
- When will progress be reviewed?
- Break into short-term and long-term if needed

### Step 8: Document and Communicate
- Write goal in clear SMART format
- Share with patient and care team
- Ensure patient understanding

## Goal Hierarchies and Levels

### ICF Framework (International Classification of Functioning, Disability and Health)

Useful for rehabilitation and functional goals:

1. **Impairment-Level Goals**: Body structure/function
   - Example: "Increase shoulder flexion ROM from 90° to 140°"
   
2. **Activity-Level Goals**: Task performance
   - Example: "Dress upper body independently"
   
3. **Participation-Level Goals**: Life role engagement
   - Example: "Return to work as teacher"

### Medical Outcome Levels

1. **Biological/Clinical Goals**: Lab values, vital signs, disease markers
   - Example: "HbA1c <7%, BP <130/80, LDL <70 mg/dL"
   
2. **Symptom Goals**: Patient-reported symptoms
   - Example: "Pain ≤4/10, no dyspnea with ADLs"
   
3. **Functional Goals**: What patient can do
   - Example: "Walk 1 mile, climb 2 flights of stairs"
   
4. **Quality of Life Goals**: Overall well-being
   - Example: "Return to hobbies, improve sleep quality"

## Patient-Centered Outcome Measures (PCOMs)

### Definition
Outcomes that matter most to patients, beyond traditional clinical metrics.

### Common PCOMs

**Patient-Reported Outcome Measures (PROMs)**:
- SF-36 or SF-12 (general health-related quality of life)
- PROMIS (Patient-Reported Outcomes Measurement Information System)
- Disease-specific QoL scales (e.g., Kansas City Cardiomyopathy Questionnaire for HF)

**Functional Outcomes**:
- Activities of Daily Living (ADLs): Bathing, dressing, toileting, transferring, feeding, continence
- Instrumental ADLs (IADLs): Shopping, cooking, housekeeping, managing finances, transportation
- Occupational/educational functioning
- Social functioning and relationships
- Recreation and leisure participation

**Patient Priorities**:
- What matters most to individual patient
- May differ from clinician priorities
- Examples: "Play with grandchildren," "Travel to daughter's wedding," "Avoid nursing home"

### Integrating PCOMs into Goals

**Approach**:
1. Ask patient about priorities early in assessment
2. Link clinical goals to patient-meaningful outcomes
3. Include at least some goals directly addressing patient priorities
4. Use patient's language in documenting goals when possible

**Example Integration**:
- **Clinical goal**: "Reduce HbA1c from 8.5% to <7% in 3 months"
- **Linked patient-centered goal**: "Improve energy levels to play with grandchildren without fatigue"
- Both goals documented, progress on both tracked

## Shared Decision-Making in Goal Setting

### What is Shared Decision-Making (SDM)?

Collaborative process where clinicians and patients jointly:
- Discuss treatment options
- Weigh risks and benefits
- Consider patient values and preferences
- Make decisions together

### SDM in Treatment Goal Setting

**Steps**:

1. **Choice Awareness**: Acknowledge multiple possible goals/approaches
   - "We could focus on aggressive HbA1c lowering vs. minimizing hypoglycemia risk. What's more important to you?"

2. **Option Presentation**: Present goal options with pros/cons
   - "Option A: Intensive BP control (<120/80) reduces stroke risk but requires more medications. Option B: Standard control (<140/90) is easier but slightly higher stroke risk."

3. **Values Clarification**: Understand patient priorities
   - "How do you feel about taking multiple medications?" "How much does avoiding injections matter to you?"

4. **Preference Integration**: Incorporate preferences into goals
   - If patient prioritizes avoiding medications → "Control BP with lifestyle changes and one medication if possible"

5. **Decision**: Agree on goals together
   - "It sounds like you'd like to try intensive lifestyle changes for 3 months before adding another medication. Let's plan for that."

6. **Document**: Record shared decision-making process
   - "Goals established through shared decision-making. Patient expressed preference for..."

### Decision Aids

Tools to facilitate SDM:
- Option grids comparing approaches
- Numerical risk/benefit data
- Patient stories/testimonials
- Visual aids (pictures, diagrams)
- "What matters to you" worksheets

## Special Considerations for Different Populations

### Older Adults
- Functional independence often priority over disease-specific metrics
- Balance aggressive treatment vs. treatment burden
- Consider life expectancy and time to benefit
- Fall prevention, polypharmacy reduction may be key goals
- Quality over quantity of life

### Pediatric
- Developmental stage-appropriate goals
- Family-centered (involve parents/caregivers)
- Growth and development milestones
- School/social functioning
- Transition planning (pediatric to adult care)

### Chronic Disease
- Long-term sustainable goals
- Balance ambition with realistic expectations
- Complication prevention
- Quality of life maintenance
- Adaptation and acceptance alongside improvement

### Palliative/End-of-Life
- Comfort and symptom management primary
- Functional goals focused on valued activities
- Psychosocial and spiritual needs
- Caregiver support
- Dignity and autonomy

### Complex Multi-Morbidity
- Prioritize most impactful goals
- Coordinate goals across conditions (when treatments overlap, even better)
- Avoid conflicting treatments
- Minimize treatment burden
- Realistic expectations with multiple conditions

## Common Goal-Setting Pitfalls

### Pitfall 1: Provider-Centric Goals
**Problem**: Goals reflect what provider thinks is important, not patient priorities  
**Solution**: Ask patient early in visit what they hope to achieve, incorporate their language

### Pitfall 2: Too Many Goals
**Problem**: Overwhelming patient with 10+ goals  
**Solution**: Prioritize 3-5 key goals, build on success

### Pitfall 3: All-or-Nothing Thinking
**Problem**: Goal is "cure" or "perfection"  
**Solution**: Incremental goals, meaningful improvement valued

### Pitfall 4: Ignoring Barriers
**Problem**: Goals set without assessing feasibility (resources, support, access)  
**Solution**: Identify barriers during assessment, problem-solve or adjust goals

### Pitfall 5: Static Goals
**Problem**: Set goals and never revisit  
**Solution**: Regular reassessment, modify as patient progresses or circumstances change

### Pitfall 6: Purely Clinical Metrics
**Problem**: All goals are lab values, no functional or QoL goals  
**Solution**: Balance clinical markers with functional, symptom, and QoL outcomes

### Pitfall 7: No Patient Buy-In
**Problem**: Patient doesn't believe goal is achievable or important  
**Solution**: Shared decision-making, motivational interviewing to explore ambivalence

## Examples of SMART Goals by Condition

### Diabetes
**Short-term**: "Reduce HbA1c from 8.5% to <7.5% within 3 months by initiating metformin 1000mg BID and reducing carbohydrate intake to 45-60g per meal."

**Long-term**: "Maintain HbA1c <7% for 6+ months, prevent microvascular complications, and improve energy levels to engage in daily walking for 30 minutes."

### Heart Failure
**Short-term**: "Achieve euvolemia (no edema, stable weight within 2 lbs) within 2 weeks through furosemide dose optimization and sodium restriction <2000mg/day."

**Long-term**: "Maintain NYHA Class II functional status, prevent HF hospitalizations, and walk 1/4 mile without dyspnea within 3 months."

### Depression
**Short-term**: "Reduce PHQ-9 score from 18 to <10 within 8 weeks by starting escitalopram 10mg daily and attending weekly CBT sessions."

**Long-term**: "Achieve depression remission (PHQ-9 <5), return to work full-time, and re-engage in social activities with friends 2-3x/week within 4 months."

### Post-Stroke Rehabilitation
**Short-term**: "Increase right arm strength from 2/5 to 3+/5 and improve Functional Independence Measure (FIM) score from 85 to 100 within 4 weeks through PT/OT 5x/week."

**Long-term**: "Achieve independence in all ADLs, ambulate 500 feet with cane on level surfaces, and return home (not nursing facility) within 3 months."

### Chronic Low Back Pain
**Short-term**: "Reduce pain intensity from 7/10 to 4/10 and increase walking tolerance from 10 minutes to 30 minutes within 6 weeks using multimodal analgesia (SNRI, NSAID, PT)."

**Long-term**: "Return to modified duty work within 3 months, engage in hobbies (fishing, gardening with adaptations), and reduce pain interference on daily life by 50% (Brief Pain Inventory)."

### Hypertension
**Short-term**: "Reduce blood pressure from 152/94 to <140/90 mmHg within 4 weeks by initiating lisinopril 10mg daily and reducing sodium intake to <2300mg/day."

**Long-term**: "Achieve and maintain BP <130/80 mmHg, reduce ASCVD 10-year risk from 15% to <10%, and prevent cardiovascular events."

## Tools and Resources

### Goal-Setting Templates
- SMART goal worksheet (fill-in-the-blank format)
- Goal-tracking sheets for patients
- Motivational interviewing "change talk" to elicit goals

### Assessment Tools
- Goal Attainment Scaling (GAS): Personalized outcome measure
- Canadian Occupational Performance Measure (COPM): Patient-identified functional goals
- Patient-Reported Outcomes Measurement Information System (PROMIS)

### Patient Education
- "Setting Health Goals" handouts
- Goal visualization exercises
- Tracking apps and logs

---

**Document Version**: 1.0  
**Last Updated**: January 2025  
**Next Review**: January 2026

