# Medical Journal Writing Style Guide

Comprehensive writing guide for NEJM, Lancet, JAMA, BMJ, Annals of Internal Medicine, and other major medical journals.

**Last Updated**: 2024

---

## Overview

Medical journals prioritize **clinical relevance**, **patient outcomes**, and **evidence-based practice**. Writing must be precise, evidence-focused, and directly applicable to clinical decision-making.

### Key Philosophy

> "Every sentence should help a clinician make better decisions for their patients."

**Primary Goal**: Communicate research findings that can improve patient care and clinical practice.

---

## Audience and Tone

### Target Reader

- Practicing physicians and clinicians
- Clinical researchers
- Healthcare policymakers
- Medical educators
- Some public health and patient advocacy readers

### Tone Characteristics

| Characteristic | Description |
|---------------|-------------|
| **Evidence-focused** | Appropriate hedging based on study design |
| **Patient-centered** | Focus on patient outcomes, not just biomarkers |
| **Clinical** | Emphasize practical applicability |
| **Precise** | Exact numbers, confidence intervals, NNT |
| **Measured** | Claims match evidence strength |

### Voice

- **Passive voice common**: "Patients were randomized to..."
- **First person acceptable**: "We conducted a trial..."
- **Third person for patients**: "Patients" not "subjects"

---

## Abstract: Structured Format

### Overview

Most major medical journals require **structured abstracts** with labeled sections. This is one of the few venues where structured abstracts are expected.

### Standard Structure (IMRAD-based)

```
Background: [Why this study was needed - 1-2 sentences]

Methods: [Study design, setting, participants, intervention, 
main outcomes - 2-4 sentences]

Results: [Primary and key secondary outcomes with statistics - 
3-5 sentences]

Conclusions: [Clinical implications, with appropriate hedging - 
1-2 sentences]
```

### Word Limits by Journal

| Journal | Abstract Limit |
|---------|---------------|
| NEJM | 250 words |
| Lancet | 300 words |
| JAMA | 350 words |
| BMJ | 300 words |
| Annals | 325 words |

### Example Structured Abstract (NEJM Style)

```
BACKGROUND
Type 2 diabetes is associated with increased cardiovascular risk, but 
the effects of intensive glucose control on cardiovascular outcomes 
remain uncertain.

METHODS
We randomly assigned 10,251 patients with type 2 diabetes and established 
cardiovascular disease to receive intensive glucose-lowering therapy 
(target HbA1c <6.0%) or standard therapy (target HbA1c 7.0-7.9%). The 
primary outcome was a composite of nonfatal myocardial infarction, 
nonfatal stroke, or death from cardiovascular causes.

RESULTS
After a median follow-up of 3.5 years, the primary outcome occurred in 
352 patients (6.9%) in the intensive-therapy group and in 371 patients 
(7.2%) in the standard-therapy group (hazard ratio, 0.90; 95% CI, 0.78 
to 1.04; P=0.16). Severe hypoglycemia was more common with intensive 
therapy (3.1% vs. 1.0%; P<0.001). All-cause mortality was similar 
between groups (5.0% vs. 4.8%; hazard ratio, 1.04; 95% CI, 0.87 to 1.24).

CONCLUSIONS
In patients with type 2 diabetes and established cardiovascular disease, 
intensive glucose lowering did not significantly reduce major 
cardiovascular events compared with standard therapy and was associated 
with increased severe hypoglycemia.
```

---

## Evidence Language

### The Cardinal Rule

**Match your language to your evidence strength.**

### Language by Study Design

| Study Design | Appropriate Language |
|-------------|---------------------|
| **Meta-analysis of RCTs** | "Treatment X reduces mortality..." |
| **Large RCT** | "Treatment X reduced mortality in this trial..." |
| **Small RCT** | "Treatment X was associated with reduced mortality..." |
| **Cohort study** | "Treatment X was associated with lower mortality..." |
| **Case-control** | "Treatment X was associated with reduced odds of death..." |
| **Cross-sectional** | "Treatment X use was associated with lower mortality..." |
| **Case series** | "These cases suggest that treatment X may..." |
| **Case report** | "This case illustrates that treatment X can..." |

### Causal Language Rules

❌ **Never say** (unless RCT): "Treatment X prevents..." / "Treatment X causes..."

✅ **Use for observational**: "Treatment X was associated with..." / "Treatment X was linked to..."

✅ **Use for RCTs**: "Treatment X resulted in..." / "Treatment X reduced..."

### Hedging Phrases

| Certainty Level | Phrases |
|----------------|---------|
| **High** | "demonstrates," "shows," "confirms" |
| **Moderate** | "suggests," "indicates," "supports" |
| **Low** | "may," "might," "could potentially" |
| **Speculative** | "it is possible that," "one interpretation is" |

---

## Reporting Numbers

### Absolute vs. Relative Risk

**Always report both absolute and relative measures.**

❌ **Incomplete**: "Treatment reduced mortality by 50%"

✅ **Complete**: "Treatment reduced relative mortality by 50% (absolute risk reduction, 2.5 percentage points; number needed to treat, 40)"

### Confidence Intervals

**Always include 95% confidence intervals.**

❌ "The hazard ratio was 0.75"

✅ "The hazard ratio was 0.75 (95% CI, 0.62 to 0.91)"

### P-values

- Report exact P-values when possible: P=0.003
- Use P<0.001 for very small values
- Consider clinical significance alongside statistical significance

### Number Needed to Treat (NNT)

Include NNT for clinically important outcomes:

```
"The intervention prevented one additional death for every 40 patients 
treated (NNT=40; 95% CI, 28 to 67)."
```

---

## Introduction

### Length and Structure

- **3-4 paragraphs** (500-700 words)
- Focus on clinical problem and rationale

### Paragraph Structure

**Paragraph 1: Clinical Problem**
- Burden of disease (incidence, prevalence, mortality)
- Impact on patients and healthcare system
- Why this matters clinically

```
"Type 2 diabetes affects more than 450 million adults worldwide and is 
a leading cause of cardiovascular disease, renal failure, and premature 
death. Despite advances in glucose-lowering therapies, patients with 
diabetes continue to face a two- to four-fold increased risk of 
cardiovascular events compared with the general population."
```

**Paragraph 2: Current Knowledge and Limitations**
- What treatments/approaches exist
- What evidence gaps remain
- Why more research was needed

**Paragraph 3: Rationale and Objectives**
- Why this study was conducted
- Clear statement of objectives/hypothesis
- Primary outcome stated

```
"We therefore conducted a randomized, controlled trial to evaluate 
whether intensive glucose-lowering therapy, compared with standard 
therapy, would reduce major cardiovascular events in patients with 
type 2 diabetes and established cardiovascular disease."
```

---

## Methods

### Structure (CONSORT/STROBE Aligned)

Medical methods sections follow reporting guidelines:

```
METHODS
├── Study Design
├── Setting and Participants
│   ├── Eligibility Criteria
│   └── Recruitment
├── Randomization and Blinding (for RCTs)
├── Interventions
├── Outcomes
│   ├── Primary Outcome
│   └── Secondary Outcomes
├── Sample Size Calculation
├── Statistical Analysis
├── Ethics Approval
└── Registration
```

### Key Elements

**Eligibility Criteria**
- List inclusion and exclusion criteria explicitly
- Be specific (age ranges, disease definitions, lab values)

**Primary Outcome**
- Define precisely, including timing of assessment
- State how it was measured

**Statistical Analysis**
- Pre-specified analysis plan
- Handling of missing data
- Subgroup analyses (pre-specified vs. exploratory)

### Example Methods Paragraph

```
We enrolled adults aged 40 years or older with type 2 diabetes (defined 
as HbA1c ≥6.5% or use of glucose-lowering medication) and established 
cardiovascular disease (previous myocardial infarction, stroke, or 
revascularization procedure). Patients were excluded if they had an 
HbA1c level below 7.5% or above 11.0%, estimated glomerular filtration 
rate below 30 ml per minute per 1.73 m² of body-surface area, or a 
cardiovascular event within the past 30 days.
```

---

## Results

### Structure

**Opening: Participant Flow**
- Screening, enrollment, randomization, follow-up, analysis
- Reference CONSORT flow diagram

**Baseline Characteristics**
- Table 1: Baseline demographics and clinical characteristics
- Note any imbalances

**Primary Outcome**
- Report first and prominently
- Include point estimate, CI, P-value
- State clinical significance

**Secondary Outcomes**
- Report all pre-specified secondary outcomes
- Be cautious about multiple comparisons

**Adverse Events**
- Report serious adverse events systematically
- Include deaths, hospitalizations, SAEs by category

### Example Results Paragraph

```
Of 12,537 patients assessed for eligibility, 10,251 underwent 
randomization: 5,128 were assigned to intensive therapy and 5,123 to 
standard therapy (Figure 1). Baseline characteristics were similar 
between groups (Table 1). Median follow-up was 3.5 years (interquartile 
range, 2.8 to 4.2), with vital status available for 99.2% of patients.

The primary outcome occurred in 352 patients (6.9%) in the intensive-
therapy group and 371 patients (7.2%) in the standard-therapy group 
(hazard ratio, 0.90; 95% confidence interval [CI], 0.78 to 1.04; 
P=0.16). The absolute difference was 0.3 percentage points (95% CI, 
-0.7 to 1.4). Results were consistent across pre-specified subgroups 
(Figure 3).
```

---

## Discussion

### Structure

**Paragraph 1: Summary of Main Findings**
- Restate primary outcome result
- State whether hypothesis was supported

**Paragraphs 2-3: Interpretation and Context**
- How do findings compare with prior evidence?
- What mechanisms might explain findings?
- Clinical interpretation

**Paragraph 4: Strengths**
- Study design features
- Generalizability
- Completeness of follow-up

**Paragraph 5: Limitations**
- Be specific and thoughtful
- Discuss how limitations might affect interpretation
- Avoid generic statements

**Final Paragraph: Conclusions and Implications**
- Clinical implications
- Policy implications
- Future research needs

### Example Limitations Paragraph

```
Our study has several limitations. First, despite randomization, we 
cannot exclude residual confounding from unmeasured factors. Second, 
the open-label design may have introduced bias in outcome assessment 
for subjective endpoints, though the primary outcome of death was 
objective. Third, our findings may not generalize to patients without 
established cardiovascular disease or to healthcare settings with 
different resources. Fourth, the 3.5-year follow-up may have been 
insufficient to detect cardiovascular benefits that emerge over 
longer periods.
```

---

## Journal-Specific Requirements

### NEJM (New England Journal of Medicine)

- **Word limit**: 2,700 words (excluding abstract, references)
- **Abstract**: 250 words, structured
- **References**: ~40-50 typical
- **Figures/Tables**: 4-5 combined
- **Style**: Definitive, authoritative
- **Emphasis**: Major clinical trials, transformative research

### Lancet

- **Word limit**: 3,500 words for research articles
- **Abstract**: 300 words, structured
- **Summary box (Panel)**: Key messages highlighted
- **Research in Context**: Required section explaining contribution
- **Style**: Global health perspective valued

### JAMA (Journal of the American Medical Association)

- **Word limit**: 3,000 words for original investigations
- **Abstract**: 350 words, structured
- **Key Points box**: Required summary
- **Visual abstract**: Encouraged
- **Style**: Policy-relevant, public health focus

### BMJ (British Medical Journal)

- **Word limit**: 3,000 words for research
- **Abstract**: 300 words, structured
- **What this paper adds**: Required box
- **Strengths and limitations box**: Explicit section
- **Style**: Practical, evidence-based

### Annals of Internal Medicine

- **Word limit**: 3,000 words
- **Abstract**: 325 words, structured
- **Style**: Focused on internal medicine practice
- **Clinical Trials and Meta-analyses**: Specialty

---

## Reporting Guidelines Compliance

### CONSORT (RCTs)

**25-item checklist** including:
- Trial design, randomization, blinding
- Participant flow (diagram required)
- All outcomes with effect sizes and CIs
- Harms and adverse events

### STROBE (Observational)

**22-item checklist** for:
- Cohort, case-control, cross-sectional studies
- Setting, participants, variables, data sources
- Bias assessment, sensitivity analyses

### PRISMA (Systematic Reviews)

**27-item checklist** including:
- Search strategy
- Study selection process (diagram)
- Risk of bias assessment
- Synthesis methods

### STARD (Diagnostic Studies)

**30 items** for diagnostic accuracy studies

---

## Tables and Figures

### Table 1: Baseline Characteristics

Standard format:
```
                              Intensive Therapy  Standard Therapy
                                  (N=5128)          (N=5123)
Age — yr                        63.4 ± 8.7        63.6 ± 8.5
Male sex — no. (%)              3389 (66.1)       3401 (66.4)
Body-mass index                 32.1 ± 5.4        32.0 ± 5.3
HbA1c — %                        8.3 ± 1.1         8.3 ± 1.0
Duration of diabetes — yr       10.2 ± 7.8        10.1 ± 7.6
Prior MI — no. (%)              2435 (47.5)       2411 (47.1)
```

### CONSORT Flow Diagram

Required for RCTs:
```
Assessed for eligibility (n=12,537)
    │
    ├─► Excluded (n=2,286)
    │     ├─ Not meeting criteria (n=1,854)
    │     ├─ Declined to participate (n=389)
    │     └─ Other reasons (n=43)
    │
Randomized (n=10,251)
    │
    ├─► Intensive therapy (n=5,128)
    │     ├─ Lost to follow-up (n=52)
    │     └─ Analyzed (n=5,076)
    │
    └─► Standard therapy (n=5,123)
          ├─ Lost to follow-up (n=48)
          └─ Analyzed (n=5,075)
```

### Kaplan-Meier Curves

Standard presentation:
- Survival curves with shaded confidence bands
- Number at risk table below
- Hazard ratio with 95% CI
- Log-rank P-value

---

## Common Mistakes in Medical Writing

1. **Overclaiming causation**: Using "caused" for observational data
2. **Relative risk only**: Not reporting absolute measures
3. **Missing CIs**: Reporting point estimates without uncertainty
4. **Vague limitations**: "Our study has limitations" without specifics
5. **Ignoring negative results**: Selective reporting of outcomes
6. **Clinical significance confusion**: Statistically significant ≠ clinically meaningful
7. **Subgroup fishing**: Post-hoc subgroup analyses presented as confirmatory
8. **Missing CONSORT/STROBE items**: Incomplete reporting

---

## Pre-Submission Checklist

### Required Elements
- [ ] Structured abstract (journal-specific format)
- [ ] Trial registration number (for RCTs)
- [ ] Ethics committee approval statement
- [ ] Conflict of interest disclosures
- [ ] CONSORT/STROBE checklist completed

### Statistical Reporting
- [ ] Primary outcome reported with CI and P-value
- [ ] Absolute and relative measures included
- [ ] All pre-specified outcomes reported
- [ ] NNT calculated for significant clinical outcomes

### Evidence Language
- [ ] Claims match study design
- [ ] Appropriate hedging used
- [ ] Causal language only for RCTs

### Clinical Relevance
- [ ] Clinical implications stated
- [ ] Patient-centered outcomes emphasized
- [ ] Generalizability discussed

---

## See Also

- `venue_writing_styles.md` - Master style overview
- `journals_formatting.md` - Technical formatting requirements
- `reviewer_expectations.md` - What medical reviewers seek
- Reporting guideline resources: consort-statement.org, strobe-statement.org

