---
name: deep-researcher
description: Performs comprehensive, multi-layered research on any topic with structured analysis and synthesis of information from multiple sources. Use when the user needs thorough investigation, market research, technical deep-dives, due diligence, or comprehensive analysis on any subject.
license: MIT
metadata:
  author: ksd
  version: "1.0"
---

# Deep Researcher

A comprehensive research workflow skill that guides Claude through systematic, multi-layered research on any topic.

## When to use this skill

Use this skill when the user:
- Asks for "deep research" or "comprehensive research" on a topic
- Needs thorough investigation or due diligence
- Requests market research or competitive analysis
- Wants technical deep-dives or architecture reviews
- Needs literature reviews or trend analysis
- Asks for detailed reports with multiple perspectives

## Research Workflow

### Step 1: Define Research Scope and Objectives

Start by clearly establishing research parameters:

1. **Identify the main research question** - What is the primary question to investigate?
2. **Define scope boundaries** - What aspects should be included or excluded?
3. **Determine depth requirements** - How detailed should the research be?
4. **Clarify expected deliverables** - What format and structure for output?
5. **List key areas of focus** - What specific subtopics to explore?

Document these parameters before proceeding.

### Step 2: Conduct Initial Exploratory Research

Begin with broad reconnaissance to map the landscape:

1. **Search for overview information** - Find general information, definitions, and context
2. **Identify key sources** - Look for authoritative sources, recent publications, expert opinions
3. **Note initial findings** - Create preliminary list of important concepts, terms, themes
4. **Discover related topics** - Identify adjacent areas that may be relevant
5. **Assess information gaps** - Note what's available vs. what needs deeper investigation

Create an initial research map with main themes and subtopics.

### Step 3: Deep Dive into Key Areas

For each identified key area, conduct detailed investigation:

1. **Targeted searches** - Use specific queries for each subtopic
2. **Multiple perspectives** - Seek diverse viewpoints and approaches
3. **Technical details** - Gather specific data, statistics, methodologies
4. **Historical context** - Understand evolution and background
5. **Current state** - Identify latest developments and trends
6. **Future outlook** - Look for predictions, projections, emerging patterns

Document findings systematically, noting sources and credibility.

### Step 4: Cross-Reference and Validate Findings

Ensure accuracy and reliability:

1. **Verify key facts** - Cross-check important information across multiple sources
2. **Identify contradictions** - Note where sources disagree and investigate why
3. **Assess source credibility** - Evaluate authority and reliability
4. **Check recency** - Ensure information is current and relevant
5. **Look for consensus** - Identify where experts or multiple sources agree
6. **Flag uncertainties** - Mark areas where information is unclear or disputed

### Step 5: Synthesize and Analyze Information

Transform collected data into insights:

1. **Identify patterns** - Look for common themes, trends, relationships
2. **Draw connections** - Link concepts across sources and subtopics
3. **Generate insights** - Develop original observations based on research
4. **Compare and contrast** - Analyze similarities and differences
5. **Evaluate implications** - Consider significance and consequences
6. **Address the research question** - Directly answer original question with evidence

### Step 6: Generate Structured Research Report

Create comprehensive, well-organized final report:

```
## Report Structure

1. **Executive Summary**
   - Brief overview of research question
   - Key findings (3-5 main points)
   - Main conclusions

2. **Introduction**
   - Research scope and objectives
   - Methodology overview
   - Key areas explored

3. **Main Body** (organized by themes)
   - Detailed findings for each key area
   - Supporting evidence and examples
   - Multiple perspectives where relevant
   - Data and statistics

4. **Analysis & Synthesis**
   - Patterns and connections identified
   - Cross-cutting themes
   - Insights and interpretations

5. **Conclusions**
   - Direct answers to research questions
   - Summary of most significant findings
   - Limitations of the research

6. **Sources & References**
   - List of key sources consulted
   - Credibility notes where relevant
```

## Research Strategies

### Information Quality Standards

- **Prefer primary sources** - Go to original sources when possible
- **Recent is better** - Prioritize current information for fast-moving topics
- **Multiple sources** - Don't rely on single source for important facts
- **Expert opinion** - Seek recognized authorities in the field
- **Data over anecdotes** - Prefer statistical evidence to individual stories

### Analysis Techniques

Use these frameworks as appropriate:

- **SWOT analysis** - Strengths, Weaknesses, Opportunities, Threats
- **Compare/Contrast** - Systematic comparison of approaches
- **Timeline analysis** - Historical development and trends
- **Stakeholder analysis** - Different perspectives and interests
- **Gap analysis** - What's missing or needs further research

## Pitfalls to Avoid

- **Confirmation bias** - Look for information that challenges assumptions
- **Information overload** - Know when enough research has been done
- **Outdated information** - Always check dates and currency
- **Single-source dependence** - Diversify sources
- **Analysis paralysis** - Balance thoroughness with timely completion
- **Losing focus** - Stay aligned with original objectives

## Progress Tracking

Copy and update this checklist as you work:

```
Research Progress:
- [ ] Step 1: Define scope and objectives
- [ ] Step 2: Initial exploratory research  
- [ ] Step 3: Deep dive into key areas
- [ ] Step 4: Cross-reference and validate
- [ ] Step 5: Synthesize and analyze
- [ ] Step 6: Generate structured report
```
