---
name: reminder
description: 当用户提到需要记住的未来任务、约会或事件时创建提醒和日历事件。在诸如"提醒我"、"设置提醒"、"我有个会"、"别忘了"或任何提及未来基于时间的任务时触发。
---

# 提醒与日历事件技能

此技能可从自然语言输入中智能创建提醒和日历事件。

## 何时使用

在用户执行以下操作时激活此技能：
- 明确要求设置提醒（"提醒我..."、"设置一个提醒..."）
- 提到带有时间的未来任务（"我下午 3 点有个会"）
- 表达需要记住某事（"别忘了..."、"我需要..."）
- 讨论带有时间信息的即将到来的事件或约会

**当触发此技能时，你有责任实际调用 shell 脚本，而不是仅仅说明如何做。**

## 使用方法

### 步骤 1：解析用户输入

分析用户消息以提取（可能不止一组）：
1. **标题**：需要记住的事情的简短描述
2. **消息**：详细信息（可选，可以与标题相同）
3. **时间**：提醒应何时触发

**关键点**：完成此解析后，立即进行第 2 步（调用工具）。不要仅停留在解析阶段。

### 步骤 2：创建提醒

对于识别出的每个提醒，**必须**使用 Bash 工具调用 `node` 并让它调用 `./create-reminder.js` 脚本来发送提醒与日历事件请求。

**重要**：不仅仅是说明要创建提醒，而是要实际调用此脚本。

脚本路径：
- 相对于技能目录：`./create-reminder.js`
- 绝对路径：需要根据 HeadlessKnight 的安装位置确定

脚本参数：
- **--title**：简洁摘要（例如，"团队会议"、"给妈妈打电话"）
- **--message**：附加详情或上下文
- **--time**：**必须是以下英文格式之一**：
  - 相对时间（英文）："in 10 seconds"、"in 30 minutes"、"in 2 hours"、"in 1 day"、"in 2 weeks"、"in 1 month"、"in 1 year"
  - 绝对时间：ISO 格式，如 "2025-11-24T15:30:00"
  - ⚠️ **禁止**传递中文时间格式如"十秒"、"一小时"等，必须先转换为英文

**执行方式**：
1. 使用 Bash 工具调用脚本，而不是模拟或说明
2. **确保 `--time` 参数已转换为英文格式**（按照下面"时间解析指南"中的转换规则）
3. 命令格式：`node /path/to/create-reminder.js --title="标题" --message="消息" --time="时间"`

### 步骤 3：实际调用脚本

调用完成后，检查脚本的输出。脚本会返回确认信息，包括提醒 ID 和计划时间。

### 步骤 4：确认创建

根据脚本的输出，确认用户的提醒已创建。告知用户：
- 设置了什么
- 何时触发
- 系统通知将在指定时间自动显示（由 CCCore 守护进程处理）

## 示例

### 示例 1：单个提醒
**用户**："30 分钟后提醒我给 John 打电话"

**你应该做的**：
1. 解析输入：标题="给 John 打电话"，时间="in 30 minutes"
2. **实际调用脚本**（不仅仅是说明）：
   ```bash
   node ${CLAUDE_PLUGIN_ROOT}/skills/reminder/create-reminder.js --title="给 John 打电话" --message="给 John 打电话" --time="in 30 minutes"
   ```
3. 等待脚本返回结果
4. 告诉用户："✅ 已设置提醒，30 分钟后你会收到通知"

### 示例 2：多个事件
**用户**："我今天下午 2 点有个会，5 点前需要提交报告"

**你应该做的**：
1. 识别两个事件
2. **实际调用脚本**两次：

   **第一个提醒**：
   ```bash
   node ${CLAUDE_PLUGIN_ROOT}/skills/reminder/create-reminder.js --title="会议" --message="参加预定会议" --time="2025-11-24T14:00:00"
   ```

   **第二个提醒**：
   ```bash
   node ${CLAUDE_PLUGIN_ROOT}/skills/reminder/create-reminder.js --title="提交报告" --message="提交报告" --time="2025-11-24T17:00:00"
   ```

3. 等待两个脚本都返回结果
4. 确认两个提醒都已创建

### 示例 3：相对时间
**用户**："别让我忘了 45 分钟后把蛋糕从烤箱拿出来！"

**你应该做的**：
1. 解析输入：标题="把蛋糕从烤箱拿出来"，时间="in 45 minutes"
2. **实际调用脚本**：
   ```bash
   node ${CLAUDE_PLUGIN_ROOT}/skills/reminder/create-reminder.js --title="把蛋糕从烤箱拿出来" --message="从烤箱取出蛋糕" --time="in 45 minutes"
   ```
3. 等待脚本返回结果
4. 告诉用户："✅ 45 分钟后我会提醒你"

## 时间解析指南

⚠️ **关键提醒**：create-reminder.js 脚本**仅接受英文时间格式**。如果你传递中文时间格式，脚本会返回错误。

### 相对时间转换

**必须执行**：用户可能用中文表达时间，你**必须**在调用脚本之前转换为英文格式。

#### 中文到英文转换规则（必须按此规则执行）

第 1 步：将中文数字转换为阿拉伯数字：
- "十" → 10、"一" → 1、"二" → 2、"三" → 3、"四" → 4、"五" → 5、"六" → 6、"七" → 7、"八" → 8、"九" → 9
- "两" / "二" → 2、"半" → 0.5（30分钟时为 30）
- "十秒" → 10秒、"一分钟" → 1分钟、"两小时" → 2小时、"三周" → 3周、"四个月" → 4月、"五年" → 5年

第 2 步：将中文时间单位转换为英文单词：
- "秒" / "秒后" → "seconds"
- "分钟" / "分钟后" / "分" → "minutes"
- "小时" / "小时后" / "钟头" → "hours"
- "天" / "天后" → "days"
- "周" / "星期" / "周后" → "weeks"（注意：1周 = 7天）
- "月" / "个月" / "月后" → "months"（注意：1月按30天计算）
- "年" / "年后" → "years"（注意：1年按365天计算）

第 3 步：组合成脚本要求的格式：`"in {数字} {英文单位}"`
- 中文："十秒后" → 阿拉伯数字："10秒" → 英文："seconds" → **最终格式：`"in 10 seconds"`**
- 中文："半小时后" → 阿拉伯数字："30分钟" → 英文："minutes" → **最终格式：`"in 30 minutes"`**

#### 具体转换例子（展示完整过程）
- 用户说："十秒后提醒我"
  1. 解析：时间部分 = "十秒后"
  2. 转换数字："十" → 10
  3. 转换单位："秒" → "seconds"
  4. **最终传给脚本：`--time="in 10 seconds"`**

- 用户说："半小时后提醒"
  1. 解析：时间部分 = "半小时后"
  2. 转换数字："半" → 30（分钟）
  3. 转换单位："小时" → "minutes"
  4. **最终传给脚本：`--time="in 30 minutes"`**

- 用户说："2小时后提醒"
  1. 解析：时间部分 = "2小时后"
  2. 转换数字：2（已是数字）
  3. 转换单位："小时" → "hours"
  4. **最终传给脚本：`--time="in 2 hours"`**

- 用户说："一周后提醒我"
  1. 解析：时间部分 = "一周后"
  2. 转换数字："一" → 1
  3. 转换单位："周" → "weeks"
  4. **最终传给脚本：`--time="in 1 week"`**

- 用户说："三个月后提醒"
  1. 解析：时间部分 = "三个月后"
  2. 转换数字："三" → 3
  3. 转换单位："个月" → "months"
  4. **最终传给脚本：`--time="in 3 months"`**

- 用户说："明年这个时候提醒我"
  1. 解析：时间部分 = "一年后"
  2. 转换数字："一" → 1
  3. 转换单位："年" → "years"
  4. **最终传给脚本：`--time="in 1 year"`**

- 用户说："明天下午3点"
  - 这不是相对时间格式，**使用下面的绝对时间规则**，转换为 ISO 格式

### 相对时间
- "in X seconds"：秒级提醒
- "in X minutes"：分钟级提醒
- "in X hours"：小时级提醒
- "in X days"：天级提醒
- "in X weeks"：周级提醒（1周 = 7天）
- "in X months"：月级提醒（1月 = 30天）
- "in X years"：年级提醒（1年 = 365天）

### 绝对时间
将自然语言转换为 ISO 格式：
- "今天下午 3 点" → 计算当前日期下午 3 点的 ISO 日期时间
- "明天上午 9 点" → 计算次日上午 9 点的 ISO 日期时间
- "下周一下午 2 点" → 计算下周一下午 2 点的 ISO 日期时间

### 当前上下文
始终考虑：
- 今天的日期：检查系统上下文获取当前日期/时间
- 用户的时区：使用本地时间进行计算
- 默认时间：如果未指定时间，询问用户或建议合理的默认值

## 其他功能

### 列出活动提醒
当用户询问"我有哪些提醒？"或"显示我即将到来的事件"时，可以通过以下方式查看：
- 使用 CCCore 的客户端命令：`cccore-client list-reminders`
- 或者告知用户提醒已创建并保存在 CCCore 中

### 取消提醒
当用户想取消特定提醒时，可以使用 CCCore 的客户端命令：
- `cccore-client cancel-reminder <reminder-id>`
- 需要提供具体的提醒 ID

## 重要说明

1. **必须调用脚本**：这不是可选的！当用户请求提醒时，你**必须**实际使用 Bash 工具调用 `create-reminder.js` 脚本。如果你只是说明你会做什么而不实际调用脚本，用户不会收到提醒。

2. **时间格式必须是英文**：⚠️ **关键**：无论用户用什么语言输入，传给脚本的 `--time` 参数**必须是英文格式**：
   - ✅ 正确格式：`"in 10 seconds"`、`"in 30 minutes"`、`"in 2 hours"`、`"in 1 day"`、`"in 2 weeks"`、`"in 1 month"`、`"in 1 year"`、`"2025-11-24T15:30:00"`
   - ❌ 错误格式：`"十秒后"`、`"一小时"`、`"半小时后"`、`"一周后"`、`"三个月后"`、`"一年后"`
   - 如果你传递中文时间格式，脚本会返回错误，提醒不会被创建！
   - **必须按照"时间解析指南"进行转换**

3. **依赖 CCCore**：此脚本通过 Socket IPC 与 CCCore 守护进程通信。确保：
   - CCCore 守护进程正在运行
   - Socket 文件存在且可访问
   - 如果脚本报错"CCCore 守护进程未运行"，提示用户启动 CCCore

4. **系统通知**：提醒将显示为系统级警报，由 CCCore 守护进程处理。该过程是完全自动化的，你不需要手动触发通知。

5. **持久化**：提醒存储在 CCCore 的数据文件中（`~/.cccore-reminders/reminders.json`），在重启后仍然存在。

6. **多个提醒**：如果用户提到多个事件，为每个事件分别调用脚本创建提醒。

7. **确认**：等待脚本返回结果后，再确认创建了什么以及何时触发。

8. **脚本路径**：脚本的绝对路径为 `${CLAUDE_PLUGIN_ROOT}/skills/reminder/create-reminder.js`，使用 `node` 命令执行。

## 故障排除与常见问题

### 提醒未创建？

如果用户说没有收到提醒，可能的原因：

1. **脚本未被调用**：检查 Claude Code 是否实际调用了 Bash 工具执行脚本。如果没有看到脚本执行，这就是问题所在。

2. **CCCore 守护进程未运行**：脚本依赖 CCCore 守护进程。
   - 检查 Socket 文件是否存在
   - 提示用户启动 CCCore 守护进程
   - 验证 Socket 路径是否正确

3. **时间格式错误（最常见的原因）**：⚠️ 检查传递给脚本的 `--time` 参数是否为英文格式：
   - ✅ 正确格式（英文）：`"in 10 seconds"`、`"in 30 minutes"`、`"in 2 hours"`、`"in 1 day"`、`"in 2 weeks"`、`"in 1 month"`、`"in 1 year"`、`"2025-11-24T15:30:00"`
   - ❌ 错误格式（中文）：`"十秒后"`、`"一小时"`、`"半小时"`、`"一周后"`、`"三个月后"`、`"一年后"`
   - 如果脚本返回错误消息如"无效的时间格式"，一定是时间格式不是英文
   - **解决方案**：按照"时间解析指南"进行转换

4. **时间转换失败**：如果无法将中文时间转换为英文：
   - 向用户请求更清晰的时间表达
   - 提供示例："请说'10秒后'、'30分钟后'、'2小时后'、'1周后'、'3个月后'或'1年后'这样的格式"
   - 参考"时间解析指南"中的转换规则

5. **参数缺失**：确保提供了所有必需参数：`--title`、`--message`、`--time`

### 时间解析失败

如果脚本返回错误（通常是时间格式错误）：
- 首先检查是否传递了中文时间格式（这会导致错误）
- 应该已经按照"时间解析指南"转换为英文格式
- 如果转换有困难，向用户请求澄清
- 建议用户使用英文格式如"in 30 minutes"、"in 2 hours"、"in 1 day"、"in 2 weeks"、"in 1 month"、"in 1 year"或具体时间"2025-11-24T15:30:00"
- 提供有效时间格式的示例

### 提醒已创建但未显示通知

- 检查 CCCore 守护进程是否正常运行
- 检查系统通知设置是否已启用
- macOS：系统设置 > 通知
- Windows：设置 > 系统 > 通知
- Linux：确保 `notify-send` 已安装
- 查看提醒数据文件：`~/.cccore-reminders/reminders.json`
