---
name: forgotten-elements-reminder
description: "当重要的故事元素（角色、情节线、伏笔）10章以上未出现时自动提醒 - 防止长篇小说中的'角色消失综合症'和遗漏的情节线"
allowed-tools: Read, Grep
---

# 遗忘元素提醒器

## 核心功能

**防止长篇小说常见问题**：

- 角色突然消失（"配角A去哪了？"）
- 情节线被遗忘（"那个伏笔后来呢？"）
- 伏笔没回收（"前文说的宝藏呢？"）

**解决方案**：后台监控，主动提醒已经很久未出现的元素。

---

## 监控内容

### 1. 角色出场频率

```
监控：character-state.json中的所有角色
阈值：10章未出现

提醒示例：
⚠️ 角色提醒：
"配角李明"已经10章未出现（上次：第5章）
- 是否应该安排他再次出场？
- 还是这个角色的故事已结束？
```

### 2. 情节线进度

```
监控：plot-tracker.json中的活跃情节线
阈值：12章无进展

提醒示例：
⚠️ 情节线提醒：
"寻找父亲仇人"情节线已12章无进展
- 上次推进：第8章
- 当前状态：pending
- 建议：安排相关情节或标记为暂停
```

### 3. 伏笔回收

```
监控：在前文埋下的重要伏笔
阈值：20章未回收

提醒示例：
⚠️ 伏笔提醒：
第3章提到"神秘盒子"，至今未揭秘（已过23章）
- 读者可能已经忘记
- 建议：尽快回收或在对话中提及
```

---

## 提醒时机

### 写作前提醒

```
执行 `/write` 时，如果检测到遗忘元素：

📋 写作前检查...
⚠️ 发现3个被遗忘的元素：

1. 角色"张婶"已15章未出现
2. 情节线"寻宝"已13章无进展
3. 伏笔"神秘信件"已20章未揭秘

💡 本章是否考虑处理？
```

### 分析时汇总

```
执行 `/analyze` 时，生成完整报告：

## 遗忘元素报告

### 失踪角色（3个）
1. 张婶（15章未出场）
2. 李老板（11章未出场）
3. 王医生（10章未出场）

### 停滞情节线（2个）
1. 寻宝线（13章无进展）
2. 复仇线（12章无进展）

### 未回收伏笔（1个）
1. 神秘信件（20章未揭秘）

建议：
- 优先处理失踪角色（读者可能已忘记）
- 推进停滞情节线或标记为"暂停"
- 伏笔及时回收（否则成烂尾）
```

---

## 配置选项

### 调整阈值

```
"角色未出场提醒阈值改为15章"
"情节线停滞提醒阈值改为20章"
```

### 排除特定元素

```
"张婶角色已完结，不再提醒"
"寻宝线有意暂停，30章后才推进，不提醒"
```

---

## 最佳实践

1. **定期查看**：每10章运行一次 `/analyze` 查看报告
2. **及时处理**：不要让太多元素堆积
3. **主动标记**：已完结的角色标记为"retired"

---

## 总结

forgotten-elements-reminder = 你的**记忆助手**

✓ 自动监控角色/情节/伏笔
✓ 超过阈值主动提醒
✓ 防止长篇小说烂尾

**长篇小说必备！** 📝

---

**本Skill版本**: v1.0
**最后更新**: 2025-10-18
