---
name: in-app-messaging-kit
description: Library of in-product message patterns, triggers, and targeting rules.
---

# In-App Messaging Kit Skill

## When to Use
- Designing nudges, tooltips, and walkthroughs for onboarding or feature launches.
- Coordinating lifecycle messaging across in-app surfaces, chat, and email.
- Testing personalization ideas tied to usage milestones or cohorts.

## Framework
1. **Trigger Matrix** – event-based, state-based, and contextual triggers.
2. **Message Patterns** – tooltip, modal, checklist, banner, coachmark, chat prompt.
3. **Targeting Rules** – persona, plan/tier, usage depth, lifecycle stage.
4. **Measurement Plan** – success metrics (CTR, completion, conversion) and guardrails.
5. **Localization + Accessibility** – copy guidelines, fallback flows, and escalation options.

## Templates
- Message brief (goal, trigger, variant, CTA, measurement).
- Component library reference with best practices.
- Experiment tracker linking messages to outcomes.

## Tips
- Keep copy concise; pair visuals or GIFs where possible.
- Schedule “quiet hours” to avoid notification overload.
- Tie each message to a single next-best-action to reduce decision fatigue.

---
