---
name: novel-writer-workflow-guide
description: "Use when user starts a novel project or asks how to organize their writing - guides through novel-writer's seven-step methodology and ensures proper workflow"
allowed-tools: Read, Grep
---

# Novel Writer 系统化创作工作流

## 当用户说"我想写小说"

**立即激活此工作流指南。**

## 七步方法论概览

```
1. /constitution  → 建立创作原则
2. /specify       → 定义故事规格
3. /clarify       → 澄清模糊点
4. /plan          → 制定创作计划
5. /tasks         → 分解执行任务
6. /write         → AI 辅助写作
7. /analyze       → 质量验证分析
```

## 详细步骤指导

### 步骤 1：建立创作原则

> "让我们从使用 `/constitution` 定义你的创作原则开始。这建立了你的核心价值观、质量标准和这个故事的不可协商规则。"

**为什么这很重要**：作为你的"创作宪法" - 决策会参考这些原则。

**包含什么**：
- 核心价值观（传递什么理念）
- 质量底线（绝对不妥协的）
- 风格原则（语言、节奏、氛围）
- 内容原则（角色、情节、世界观规范）

**典型时长**：15-20 分钟

### 步骤 2：定义故事规格

> "现在使用 `/specify` 创建类似产品规格的故事文档。像产品经理一样思考：这个故事是什么，为谁写的，什么使它独特？"

**要包含什么**：
- 一句话概括
- 目标读者
- 核心冲突
- 主要角色
- 成功标准

**为什么这很重要**：
- 明确"为谁写"和"写什么"
- 设定可衡量的成功标准
- 为后续创作提供明确目标

**典型时长**：30-45 分钟

**特殊标记**：
- `[需要澄清]` - 标记需要进一步明确的点
- `[核心需求]` - 不可妥协的需求
- `[可选特性]` - 锦上添花的内容

### 步骤 3：澄清关键决策

> "运行 `/clarify` 通过 5 个精准问题解决任何不清楚的方面。AI 会识别你的规格中的模糊点，帮助你做出清晰的决定。"

**为什么这很重要**：规划中的模糊 = 写作中的混乱。

**过程**：
- AI 识别规格中的模糊点
- 生成最多 5 个关键问题
- 交互式回答，答案直接更新规格
- 保留决策历史以便回溯

**典型问题**：
- "主角的核心动机是复仇还是正义？"
- "故事节奏是快速爽文还是慢热精品？"
- "结局是大团圆还是留有遗憾？"

**典型时长**：10-15 分钟

### 步骤 4：制定创作计划

> "使用 `/plan` 创建章节结构和技术方法。这是你决定如何实现你的规格的地方。"

**要设计什么**：
- 章节分解与活跃情节线
- 节奏和张力分布
- 伏笔计划
- 角色弧线映射

**为什么这很重要**：
- 把抽象需求变成具体方案
- 选择合适的写作方法和结构
- 设计情节、人物、世界观的具体实现

**技术决策示例**：
- "使用七点结构增强悬念"
- "采用多线叙事展现复杂性"
- "通过限定视角增加神秘感"

**典型时长**：45-60 分钟

### 步骤 5：分解执行任务

> "执行 `/tasks` 生成带优先级、依赖关系和估算工作量的可操作任务列表。"

**任务类型**：
- 章节写作任务
- 角色档案完善
- 世界观设定补充
- 修订和润色任务

**任务标记**：
- `[P]` - 可并行执行
- `[依赖:X]` - 依赖任务 X 完成
- `[高优]` - 高优先级任务

**为什么这很重要**：
- 大目标变成小步骤，降低创作难度
- 明确优先级和依赖关系
- 支持并行创作提高效率

**典型时长**：20-30 分钟

### 步骤 6：开始写作

> "现在 `/write` 逐章使用 AI 辅助。规格和计划指导每一章，确保一致性。"

**写作时**：
- 类型知识 skills 自动激活
- 一致性检查器在后台运行
- 节奏监控在检测到问题时提醒

**执行原则**：
- 严格遵循 constitution 的原则
- 参考 plan 中的技术方案
- 完成 tasks 中的具体任务
- 保持与规格的一致性

**推荐节奏**：
- 每次写作会话 1-2 章
- 每 3-5 章停下来回顾
- 保持前进动力，不要过度编辑

### 步骤 7：质量检查

> "每 5 章运行 `/analyze` 保持质量并及早发现问题。"

**两种分析模式**：
- **框架分析**（写作前）：验证规划
- **内容分析**（写作后）：验证执行

**验证维度**：
- 宪法合规性（是否违背核心原则）
- 规格满足度（是否实现了需求）
- 内容一致性（情节、时间、人物）
- 质量标准（是否达到设定标准）

**何时运行**：
- 完成前 3 章后（早期验证）
- 每 5 章（定期检查）
- 完成草稿后（全面审查）

## Skills 自动激活

在遵循此工作流时，相关 skills 将基于上下文激活：

**在 `/specify` 期间**：
- 如果你提到"言情"→ Romance skill 激活
- 如果你提到"悬疑"→ Mystery skill 激活
- 如果你提到"奇幻"→ Fantasy skill 激活

**在 `/write` 期间**：
- 写对话 → Dialogue Techniques 激活
- 写场景 → Scene Structure 激活
- 任何写作 → Consistency Checker 后台运行

**整个过程中**：
- Workflow Guide（此 skill）保持活跃
- 确保你不跳过关键步骤
- 在需要时提供提醒

## 当用户偏离时

如果用户尝试跳过步骤或直接开始写作而没有计划：

**温和提醒**：
> "我注意到你直接跳到写作。Novel-writer 的优势在于系统性的前期计划。你想运行 `/constitution` 和 `/specify` 建立坚实基础吗？这会使写作过程更流畅并有助于保持一致性。"

**如果用户坚持跳过**：
> "我理解 - 你总是可以稍后创建规划文档。但是，请注意，没有 `/specify` 和 `/plan`，你需要手动跟踪一致性。"

## 不同规模项目的调整

### 短篇小说（1-3 万字）

**简化流程**：
```
/specify → /clarify → /write → /analyze
```

**重点**：明确核心冲突和转折

**时间**：1-2 天密集工作

### 中篇小说（10-20 万字）

**标准流程**：
```
完整七步
```

**重点**：计划和任务分解

**时间**：2-6 个月

### 长篇连载（50 万字+）

**强化流程**：
```
重复循环 plan → tasks → write → analyze
```

**重点**：持续的一致性验证

**时间**：6-18 个月

## 常见问题处理

### "我已经有大纲了"

> "太好了！让我们使用 `/specify` 将其转换为 novel-writer 的格式。这使其机器可读并启用所有追踪功能。"

**过程**：
1. 将现有大纲导入
2. 用 `/specify` 格式化
3. 用 `/clarify` 填补空白
4. 用 `/plan` 创建详细的技术计划

### "这看起来设置很多"

> "设置需要 30-60 分钟，但节省了数小时的修订。你本质上是为你的小说创建'源代码' - 修改规格，重新生成内容。没有它，更改需要全文手动重写。"

**收益**：
- 保持一致性自动
- 更改传播自动
- 质量检查系统化
- 修订更快更容易

### "我可以只使用部分工作流吗？"

> "可以，但有些命令相互依赖：
> - `/write` 需要 `/specify` 和 `/plan` 才能有效工作
> - `/analyze` 需要已写的章节来评估
> - `/track` 需要先 `/track-init`
> 
> 最小可行工作流：`/constitution` → `/specify` → `/write`"

**完全可选**：
- `/clarify` - 如果你的规格已经清楚
- `/tasks` - 如果你更喜欢自由形式写作
- `/analyze` - 虽然强烈推荐

### "这适合我的写作风格吗？"

**兼容的写作风格**：
- **规划者**：会喜欢结构
- **裤子作者**（凭感觉写）：使用轻量级规格，专注于 `/write`
- **混合型**：根据需要调整

**调整建议**：
- 规划者：在 `/plan` 上花更多时间
- 裤子作者：保持 `/specify` 简短，允许发现
- 混合型：使用完整流程但保持灵活

## 进度追踪

### 视觉进度指示器

当你进行工作流时，我会显示你的位置：

```
✅ /constitution  完成
✅ /specify       完成
✅ /clarify       完成
🔄 /plan          进行中...
⏸️ /tasks         待定
⏸️ /write         待定
⏸️ /analyze       待定
```

### 里程碑

**规划阶段完成**（steps 1-5）：
- 你有完整的故事蓝图
- 准备开始写作
- 所有主要决策已做出

**第一稿完成**（步骤 6）：
- 所有章节已写
- 准备全面分析
- 进入修订阶段

**质量验证通过**（步骤 7）：
- 一致性验证
- 符合质量标准
- 准备发布或进一步润色

## 与其他 Skills 的集成

### 自动触发

**当你提到类型时**：
- "言情"→ Romance skill 提供惯例
- "悬疑"→ Mystery skill 提供线索布置
- "奇幻"→ Fantasy skill 提供世界构建

**当你遇到困难时**：
- "角色感觉平淡"→ 建议 Character Development commands
- "场景拖沓"→ Scene Structure skill 激活
- "对话僵硬"→ Dialogue Techniques skill 激活

### 协作工作流

**所有 Skills 都知道工作流**：
- 他们会参考你在工作流中的位置
- 建议基于当前阶段适当
- 在需要时提醒完成前面的步骤

## 成功模式

### 高生产力模式

```
周一：/constitution + /specify（2-3小时）
周二：/clarify + /plan（2-3小时）
周三：/tasks + 开始 /write（2-3小时）
周四-周日：/write 会话（每天1-2小时）
下周一：/analyze + 计划下一批
```

### 探索性模式

```
第1周：/constitution + 轻量级 /specify
第2-3周：/write 探索性章节
第4周：基于学习更新 /specify 和 /plan
第5-8周：结构化 /write
第9周：/analyze 和修订
```

### 冲刺模式（NaNoWriMo）

```
第1天：快速 /constitution + /specify + /plan（4小时）
第2-27天：密集 /write（每天2000字）
第28-30天：/analyze + 紧急修复
```

## 你不是孤单的

**在整个过程中**：
- 我在这里指导和提醒
- Skills 自动应用专业知识
- 一致性自动检查
- 你专注于创作，系统处理组织

**你总是掌控**：
- 跳过你不需要的步骤
- 调整以适应你的风格
- 随时更改计划
- 工具服务于你，不是相反

---

**记住**：这个工作流不是枷锁 - 它是脚手架。它支持你的创作过程，使强大的东西成为可能。一旦你熟悉它，它就变成第二天性，你会想知道你以前是如何在没有它的情况下写作的。

**准备开始了吗？让我们从 `/constitution` 开始！**

