---
name: novelweave-workflow
description: 使用 NovelWeave 进行小说创作的完整工作流程，包括命令使用、最佳实践和高效创作技巧。适用于规划小说项目、组织创作过程或学习 NovelWeave 功能。
version: 1.0.0
keywords: [NovelWeave, 工作流, 小说命令, 创作流程, 最佳实践]
when_to_use: 开始新小说项目、优化创作流程、学习 NovelWeave 功能或需要创作指导时使用
allowed_tool_groups: [read]
---

# NovelWeave 小说创作工作流

## NovelWeave 核心理念

NovelWeave 是一个 AI 驱动的小说创作助手，设计用于支持从构思到完稿的整个创作过程。

### 三大支柱

1. **结构化创作** - 通过专用命令引导创作流程
2. **知识管理** - 使用 Knowledge Base 追踪世界观和角色
3. **AI 协作** - 与 AI 共同创作，而非让 AI 独立创作

## 完整创作工作流

### 阶段 1：构思和规划

#### 1.1 定义创作核心（Constitution）

使用 `/constitution` 命令建立小说的核心价值观和主题。

**目的**：

- 定义小说的核心主题和价值观
- 为创作决策建立指南针
- 保持整个创作过程的一致性

**示例**：

```
/constitution
主题：救赎与希望
价值观：即使在最黑暗的时刻，人性的善良仍会发光
避免：廉价的情感操纵、不必要的暴力
```

#### 1.2 制定创作计划

使用 `/plan` 命令构建小说大纲和结构。

**最佳实践**：

- 从简单大纲开始（三幕结构或章节概要）
- 确定关键转折点和高潮
- 保持灵活性 - 允许情节在创作中演变

### 阶段 2：世界构建和角色塑造

#### 2.1 建立角色档案

使用 Agent Rules 和 Knowledge Base 创建详细的角色档案。

**关键要素**：

- 外貌、性格、动机
- 背景故事和创伤
- 角色弧线和成长轨迹
- 语言风格和习惯用语

#### 2.2 构建世界设定

为奇幻、科幻或复杂背景建立世界观。

**记录内容**：

- 地理和地点
- 历史和文化
- 魔法系统或科技规则
- 社会结构和政治

### 阶段 3：场景创作

#### 3.1 使用 `/write` 命令

这是核心创作命令，用于生成场景内容。

**有效的 `/write` 请求**：

```
/write
场景：艾米在废弃工厂与追踪者对峙
情感：紧张、恐惧但决心坚定
重点：展示艾米的机智和勇气
长度：800-1000 字
```

**避免**：

- 过于宽泛的请求（"写第一章"）
- 缺乏情感方向
- 没有明确的场景目标

#### 3.2 追踪场景连续性

使用 `/track` 系统维护情节、角色和时间线的一致性。

**功能**：

- 追踪角色状态和情感弧线
- 记录重要事件和时间戳
- 识别潜在的情节漏洞

### 阶段 4：审稿和修订

#### 4.1 质量保证

使用一致性检查工具审查稿件。

**检查领域**：

- 角色一致性（外貌、性格、声音）
- 情节连续性
- 时间线准确性
- 主题一致性

#### 4.2 风格润色

审查对话、节奏和描写质量。

**常见改进点**：

- 对话真实性
- 展示 vs. 告知平衡
- 节奏和张力
- 感官细节

## NovelWeave 最佳实践

### 1. 增量创作

- 一次专注于一个场景
- 先完成粗稿，再精炼
- 允许灵感自然涌现

### 2. 充分利用 Knowledge Base

- 记录所有重要细节
- 定期审查以确保一致性
- 在创作时参考现有材料

### 3. 与 AI 有效协作

- 提供明确的方向和上下文
- 审查并编辑 AI 生成的内容
- 保持你独特的创作声音

### 4. 保持灵活性

- 允许故事自然演变
- 不要过度规划
- 相信创作过程

## 常见陷阱避免

❌ **过度依赖 AI** - 你是作者，AI 是助手
❌ **跳过规划** - 一些结构能防止后期大返工
❌ **忽视一致性** - 小错误会累积破坏可信度
❌ **一次写太多** - 专注质量而非数量

## 快速参考：关键命令

- `/constitution` - 定义核心价值观和主题
- `/plan` - 创建和管理小说大纲
- `/write` - 生成场景内容
- `/track` - 追踪情节和角色一致性
- `/clarify` - 解决情节问题和填补漏洞
- `/analyze` - 深入分析文本和结构

## 与其他 Skills 配合

- **类型知识** Skills（奇幻、言情、悬疑）提供类型特定指导
- **写作技巧** Skills（对话、场景结构）提升技艺水平
- **质量保证** Skills（一致性检查）确保专业品质

---

**记住**：NovelWeave 旨在增强你的创造力，而非替代它。保持你的独特声音，让 AI 帮助你实现愿景。
