---
name: romance-novel-conventions
description: "Use when user mentions romance, love story, or relationship-focused narrative - provides genre conventions, pacing guidelines, and emotional beats for romance writing"
allowed-tools: Read, Grep
---

# 言情小说创作规范

## 快速参考

| 元素 | 指导原则 | 示例 |
|------|---------|------|
| **初遇** | 故事的 0-10% | 意外的首次相遇，产生火花 |
| **初吻** | 50-60%（慢热）或 20-30%（快热） | 需要充分的情感铺垫 |
| **黑暗时刻** | 75-85% | 关系看似不可能继续 |
| **大结局** | 85-100% | 表白、承诺、HEA/HFN |

## 核心要素

### 必备组成部分

1. **情感连接**：主角之间必须有化学反应
   - 通过行动而非单纯描述来展现吸引力
   - 通过亲近和距离建立张力
   - 创造可信的相互吸引的理由

2. **内在冲突**：恐惧、过往创伤、自我怀疑
   - 每个角色都应该有情感包袱
   - 内在冲突必须与外在障碍同样强烈
   - 成长来自面对这些内在问题

3. **外在障碍**：家庭、事业、误会
   - 障碍应该是合理的，而非人为的
   - "只要好好沟通"不应该能解决所有问题
   - 风险应该逐步升级

4. **令人满意的结局**：HEA（永远幸福）或 HFN（暂时幸福）
   - 两个角色都必须成长才配得上结局
   - 结局应该解决内在和外在冲突
   - 读者应该感到满足，而非被欺骗

### 可选元素

- 三角恋（谨慎使用 - 可能让读者沮丧）
- 被迫亲密设定（被困在一起的场景）
- 欢喜冤家（需要精心处理）
- 第二次机会言情（重燃旧情）

## 节奏指南

| 故事阶段 | 百分比 | 关键事件 | 情感焦点 |
|---------|-------|---------|---------|
| **初遇** | 0-10% | 初次相遇，产生兴趣的火花 | 好奇、吸引 |
| **张力建立** | 10-60% | 吸引力增长，障碍出现 | 渴望、挫折 |
| **冲突升级** | 60-75% | 重大误会或真相揭露 | 怀疑、痛苦 |
| **黑暗时刻** | 75-85% | 关系看似不可能 | 绝望、失落 |
| **大结局** | 85-100% | 盛大表白、承诺 | 喜悦、圆满 |

## 情感节奏点

### 初吻时机

**慢热言情**（约 50-60%）：
- 初吻前有多次差点亲上的时刻
- 大量的情感铺垫
- 亲吻发生在建立重要信任之后
- 读者的期待值很高

**快热言情**（约 20-30%）：
- 立即的化学反应导致快速的身体接触
- 之后重点转移到情感亲密
- 仍必须展现合理的吸引力建立
- 避免"一见钟情" - 展示他们为何吸引

**黄金法则**：在没有足够铺垫的情况下，绝不要仓促。没有情感基础的身体亲密会显得空洞。

### 亲密关系进展

1. **情感亲密先于身体亲密**
   - 分享脆弱性
   - 揭露过去的伤痛
   - 信任必须赢得

2. **逐步展现脆弱**
   - 从小的袒露开始
   - 建立到更深层的情感分享
   - 身体亲密跟随情感信任

3. **尊重角色界限**
   - 角色可以说不
   - 同意是必不可少的
   - 尊重符合角色性格的节奏

## 常见陷阱

### ❌ 一见钟情

**问题**：角色在没有发展的情况下爱得太快

**为什么不好**：读者不相信这种连接；感觉勉强和不真实

**解决方法**：
- 在表白之前展示 3-5 次有意义的互动
- 通过行动而非想法建立吸引力
- 给出他们相互吸引的具体原因
- 允许时间让信任发展

### ❌ 误会是唯一冲突

**问题**："只要好好谈谈，一切都会好起来"

**为什么不好**：让读者沮丧；感觉像人为的戏剧

**解决方法**：
- 添加合理的外部障碍（工作、家庭、地点）
- 创造必须发生的内在成长（恐惧、创伤、身份认同）
- 让沟通因真实原因而困难（权力失衡、过去的背叛）
- 确保冲突需要角色成长才能解决

### ❌ 被动的主角

**问题**：等待被拯救或被选择；没有主动权

**为什么不好**：削弱角色，让言情感觉不平等

**解决方法**：
- 给他们关系之外的目标
- 展示他们主动追求
- 让他们为爱情积极做出牺牲
- 确保两个角色在关系中拥有平等的主动权

### ❌ 陈词滥调没有创新

**问题**：读者已经看过一千次的可预测情节

**为什么不好**：无聊；读者能预测每一个转折

**解决方法**：
- 添加独特的角色背景或情境
- 在熟悉的框架内扭转期望
- 以意想不到的方式结合套路
- 让角色性格驱动情节，而非反过来

## 子类型考虑

### 现代言情
- 现代关系动态
- 现实的障碍（事业、距离、时机）
- 短信/科技发挥作用
- 关注兼容性和沟通

### 古代言情
- 符合时代的限制（阶级、礼仪）
- 社会规则创造自然障碍
- 需要研究以确保真实性
- 平衡历史准确性与现代敏感性

### 超自然言情
- 超自然元素增加风险
- 不朽创造时间线问题
- 必须解决权力动态
- 危险可以迫使亲密

### 悬疑言情
- 外部危险将他们联系在一起
- 秘密使信任复杂化
- 悬疑情节必须同样强大
- 结局需要解决两个谜团

## 与 Novel-Writer 命令集成

### 当用户执行 `/specify` 时
- 提醒在故事结构中包含关系弧
- 建议定义：初遇、主要障碍、黑暗时刻、大结局
- 识别言情子类型以适应相应惯例

### 在 `/plan` 期间
- 将情感节奏映射到章节结构
- 计划被迫亲密或分离的时刻
- 设计内外冲突升级
- 确保身体/情感亲密的适当节奏

### 在 `/write` 时
- 为浪漫张力应用对话技巧
- 通过行动而非想法展现化学反应
- 通过潜台词建立性张力
- 确保两个角色都有主动权

### 当 `/analyze` 运行时
- 根据言情惯例检查节奏
- 验证两个角色都有完整的弧线
- 确保障碍感觉合理，而非人为
- 确认令人满意的 HEA/HFN 结局

## 实用检查清单

写言情时，确保你有：

- [ ] 早期建立强烈的化学反应（10% 前）
- [ ] 两位主角都有清晰的内在冲突
- [ ] 不能通过一次对话解决的外部障碍
- [ ] 整个故事中跟踪的情感亲密发展
- [ ] 适合子类型的身体亲密节奏
- [ ] 感觉毁灭性且真实的黑暗时刻
- [ ] 解决两个角色成长的结局
- [ ] 满足读者期望的 HEA 或 HFN

## 常见读者期望

**言情读者想要什么**：
- 情感满足胜过惊喜
- 两个角色都赢得他们的幸福
- 通过成长克服可信的障碍
- 页面上闪耀的化学反应
- 他们想要给自己的关系
- 所有关系线索的结尾

**让言情读者沮丧的是什么**：
- 可以轻易解决的人为冲突
- 一个角色做所有情感工作
- 没有适当解决的仓促结局
- 未解决的不平等权力动态
- 没有后果的出轨或背叛
- 为了情节便利而牺牲角色成长

---

**记住**：言情是关于两个人在一起变得比分开时更好的旅程。障碍应该迫使成长，化学反应应该感觉不可避免，结局应该感觉是赢得的。
