---
name: next-test-analyzer
description: Review test coverage quality and completeness. Use after creating a PR or adding new functionality to ensure tests adequately cover new code and edge cases.
---

This skill analyzes test coverage quality for PRs to ensure critical functionality is covered without insisting on 100% coverage.

## Context to Gather

Before analyzing, read:
- `~/.agents/docs/development/testing-directives.md` - Testing standards
- All test files for changed modules
- The source code being tested
- Existing test patterns in the project

## Core Responsibilities

1. **Analyze Test Coverage Quality**: Focus on behavioral coverage rather than line coverage. Identify critical code paths, edge cases, and error conditions that must be tested to prevent regressions.

2. **Identify Critical Gaps**: Look for:
   - Untested error handling paths that could cause silent failures
   - Missing edge case coverage for boundary conditions
   - Uncovered critical business logic branches
   - Absent negative test cases for validation logic
   - Missing tests for concurrent or async behavior where relevant

3. **Evaluate Test Quality**: Assess whether tests:
   - Test behavior and contracts rather than implementation details
   - Would catch meaningful regressions from future code changes
   - Are resilient to reasonable refactoring
   - Follow DAMP principles (Descriptive and Meaningful Phrases) for clarity

4. **Prioritize Recommendations**: For each suggested test or modification:
   - Provide specific examples of failures it would catch
   - Rate criticality from 1-10 (10 being absolutely essential)
   - Explain the specific regression or bug it prevents
   - Consider whether existing tests might already cover the scenario

## Analysis Process

1. Examine the PR's changes to understand new functionality and modifications
2. Review the accompanying tests to map coverage to functionality
3. Identify critical paths that could cause production issues if broken
4. Check for tests that are too tightly coupled to implementation
5. Look for missing negative cases and error scenarios
6. Consider integration points and their test coverage

## Rating Guidelines

- **9-10**: Critical functionality that could cause data loss, security issues, or system failures
- **7-8**: Important business logic that could cause user-facing errors
- **5-6**: Edge cases that could cause confusion or minor issues
- **3-4**: Nice-to-have coverage for completeness
- **1-2**: Minor improvements that are optional

## Output Format

Structure your analysis as:

1. **Summary**: Brief overview of test coverage quality
2. **Critical Gaps** (if any): Tests rated 8-10 that must be added
3. **Important Improvements** (if any): Tests rated 5-7 that should be considered
4. **Test Quality Issues** (if any): Tests that are brittle or overfit to implementation
5. **Positive Observations**: What's well-tested and follows best practices

## Important Considerations

- Focus on tests that prevent real bugs, not academic completeness
- Consider the project's testing standards from guidelines if available
- Remember that some code paths may be covered by existing integration tests
- Avoid suggesting tests for trivial getters/setters unless they contain logic
- Consider the cost/benefit of each suggested test
- Be specific about what each test should verify and why it matters
- Note when tests are testing implementation rather than behavior

Be thorough but pragmatic, focusing on tests that provide real value in catching bugs and preventing regressions rather than achieving metrics.
