---
name: bilibili-chapter-generator
description: |
  为 B站视频生成章节列表。
  触发场景：
  (1) 需要为视频创建 B站章节
  (2) 用户说"转成B站格式"、"生成章节"、"生成B站章节"
  (3) 需要从字幕生成视频分段
  (4) 处理视频进度条分段标记
metadata:
  author: nanmi
  version: "1.0.0"
---

# B站视频章节生成器

根据字幕内容为 B站视频生成章节列表，用户可直接复制到 B站视频编辑页面。

## B站章节格式规范

```
00:00 引言
01:23 第一部分标题
05:30 第二部分标题
```

**格式要求（B站硬性限制）：**
- **第一个章节必须从 `00:00` 开始**（这是强制要求）
- **章节数量：3-10 个**（必须 > 2 且 ≤ 10）
- **章节标题不能包含特殊符号**（禁止使用 `：` `:` `、` `，` `。` `！` `？` `【】` `()` 等）
- 时间格式：`MM:SS`（分:秒）或 `HH:MM:SS`（时:分:秒）
- 每行一个章节：`时间戳 章节标题`
- 章节间隔必须 ≥ 5 秒

## 工作流程

### Step 1: 获取 SRT 文件

询问用户 SRT 字幕文件路径，或从上下文中获取。

### Step 2: 解析字幕内容

调用 `srt-to-structured-data` skill 解析字幕：

```bash
python3 ~/.claude/skills/srt-to-structured-data/scripts/parse_srt.py "<srt_file_path>" --stats
```

这会输出：
- 字幕的 JSON 结构（包含时间码和文本）
- 统计信息（总时长、字幕数量等）

### Step 3: 分析字幕内容

阅读字幕内容，理解视频的：
- 主题和结构
- 内容转折点
- 关键话题变化

### Step 4: 生成章节列表

根据用户的描述意图（如果有）或自动分析，生成章节列表：

1. **识别内容转折点**：找出话题变化、新段落开始的位置
2. **确定章节标题**：简洁描述该段内容（建议 2-8 个字）
3. **校验时间间隔**：确保相邻章节间隔 ≥ 5 秒
4. **格式化输出**：使用 `MM:SS 标题` 格式

### Step 5: 输出结果

输出纯文本格式的章节列表，用户可直接复制：

```
00:00 开场介绍
02:15 核心概念讲解
08:30 实战演示
15:00 总结回顾
```

## 使用示例

**用户输入：**
```
帮我把 ./视频字幕.srt 转成B站章节
```

**或更详细的需求：**
```
帮我生成B站章节，要求：
- 字幕文件：./demo.srt
- 大概分成 5-6 个章节
- 重点突出实战部分
```

## 章节划分建议

**B站限制：3-10 个章节（必须 > 2 且 ≤ 10）**

- **短视频（< 5 分钟）**：3-4 个章节
- **中等视频（5-15 分钟）**：4-7 个章节
- **长视频（> 15 分钟）**：7-10 个章节

## 注意事项

1. **第一个章节必须是 `00:00`**，命名为"开场"、"引言"或直接点题
2. **章节标题禁止特殊符号**：不能使用冒号、顿号、逗号、括号等，只用纯中文/英文/数字
3. 章节标题要简洁有力，便于观众快速定位（建议 2-8 个字，纯文字）
4. 最后一个章节可以是"总结"、"结语"或"彩蛋"
5. 避免章节过于密集（间隔太短会显得杂乱）
6. 时间戳取字幕段落开始时间，向下取整到秒
7. **章节总数必须 > 2 且 ≤ 10**，否则B站会拒绝

## 章节标题示例

**正确示例：**
- `00:00 开场介绍`
- `03:35 Agent演示加载skill流程`
- `05:39 环境配置`
- `08:38 源码解析`

**错误示例（包含特殊符号）：**
- ~~`03:35 Agent演示：加载skill的流程`~~ （包含冒号）
- ~~`05:39 环境准备、安装依赖`~~ （包含顿号）
- ~~`08:38 代码解析（核心逻辑）`~~ （包含括号）
