# 配色方案库

> 共 76 个配色方案，按风格分类

---

## 文件结构索引（AI 分层读取指南）

> **重要**：AI 应按需分层读取，避免一次性读取全文。

| 内容 | 行号范围 | 说明 |
|------|----------|------|
| 快速查询索引 | 32-111 | 76个配色的ID/名称/标签/场景 |
| AI 使用指南 | 115-138 | 色值映射和推导规则 |
| 深色/暗黑主题 | 143-365 | 18个配色详情 |
| 浅色/极简主题 | 366-432 | 6个配色详情 |
| 霓虹/赛博朋克 | 433-486 | 5个配色详情 |
| 自然风景 | 487-579 | 9个配色详情 |
| 季节主题 | 580-620 | 3个配色详情 |
| 金属色系 | 621-661 | 3个配色详情 |
| 品牌/科技 | 662-715 | 5个配色详情 |
| 食物灵感 | 716-795 | 8个配色详情 |
| 天气/氛围 | 796-823 | 2个配色详情 |
| 复古/怀旧 | 824-864 | 3个配色详情 |
| 双色对比 | 865-996 | 10个配色详情 |
| 单色系 | 997-1076 | 6个配色详情 |
| 专业/商务 | 1077-1143 | 5个配色详情 |
| 地域/文化 | 1144-1158 | 1个配色详情 |
| 其他配色 | 1159-1240 | 8个配色详情 |

---

## 快速查询索引

| ID | 名称 | 标签 | 推荐场景 | 风格 | 跳转 |
|----|------|------|----------|------|------|
| 01 | Dark Sapphire Blue | 深色,蓝色,专业,科技 | 科技产品,暗黑模式 | glass | [→](#dark-sapphire-blue) |
| 02 | dark-blue-green-red | 深色,多彩,对比强烈 | 视觉冲击 | glass | [→](#dark-blue-green-red) |
| 03 | dark-blue-red-blush | 深色,蓝色,红色点缀 | 深色科技 | glass | [→](#dark-blue-red-blush) |
| 04 | Dark Sage Green | 深色,绿色,自然 | 自然/环保 | glass | [→](#dark-sage-green) |
| 05 | purple-dark-black-blue | 深色,紫色,霓虹 | 赛博朋克 | glass | [→](#purple-dark-black-blue) |
| 06 | gold-dark | 深色,金色,奢华 | 奢侈品牌 | glass | [→](#gold-dark) |
| 07 | dark-dull-peach | 深色,桃色,温暖 | 温暖深色 | glass | [→](#dark-dull-peach) |
| 08 | dark-brick-mustard | 深色,黄色,红色 | 活力深色 | glass | [→](#dark-brick-mustard) |
| 09 | dark-chartreuse | 深色,黄绿色,自然 | 自然科技 | glass | [→](#dark-chartreuse) |
| 10 | dark-lavendar | 深色,紫色,浪漫 | 浪漫深色 | glass | [→](#dark-lavendar) |
| 11 | moody-intense-red | 深色,红色,强烈,热情 | 热情展示 | glass | [→](#moody-intense-red) |
| 12 | maroon-dull-browns | 深色,栗色,棕色,复古 | 复古风格 | flat | [→](#maroon-dull-browns) |
| 13 | space | 深色,太空,星空,金色点缀 | 科幻太空 | glass | [→](#space) |
| 14 | starry-night | 深色,星空,艺术,梵高风格 | 艺术展示 | glass | [→](#starry-night) |
| 15 | moon-and-mars | 深色,太空,火星色 | 太空主题 | glass | [→](#moon-and-mars) |
| 16 | Electric City Nights | 深色,蓝色,城市,科技 | 科技产品 | glass | [→](#electric-city-nights) |
| 17 | hacker-news | 深色,橙色,科技,极客 | 极客/开发者 | glass | [→](#hacker-news) |
| 18 | minimal-modern-light | 浅色,极简,蓝色,现代 | 企业官网 | flat | [→](#minimal-modern-light) |
| 19 | white-with-blue | 浅色,蓝色,清新 | 清新产品 | flat | [→](#white-with-blue) |
| 20 | black-and-white | 极简,黑白,经典 | 极简设计 | flat | [→](#black-and-white) |
| 21 | blueberry-contrast | 浅色,柔和,对比 | 柔和展示 | flat | [→](#blueberry-contrast) |
| 22 | orange-flat-shadow | 浅色,橙色,扁平,现代 | 现代扁平 | flat | [→](#orange-flat-shadow) |
| 23 | neon | 霓虹,紫色,夜店,科幻 | 夜店/科幻 | glass | [→](#neon) |
| 24 | cyberpunk | 赛博朋克,霓虹,科幻,未来 | 赛博朋克 | glass | [→](#cyberpunk) |
| 25 | neon-downtown-lights | 霓虹,城市,夜晚,炫彩 | 城市夜景 | glass | [→](#neon-downtown-lights) |
| 26 | dance-network | 霓虹,粉色,青色,活力 | 活力展示 | glass | [→](#dance-network) |
| 27 | summer-meadow | 自然,夏季,草地,绿色 | 自然/夏季 | flat | [→](#summer-meadow) |
| 28 | rustic-mountain-cabin | 自然,山林,木屋,棕色 | 自然/山野 | flat | [→](#rustic-mountain-cabin) |
| 29 | ocean-sunset | 自然,海洋,日落,温暖 | 日落/海洋 | flat | [→](#ocean-sunset) |
| 30 | deserted-island | 自然,岛屿,沙滩,热带 | 热带/旅游 | flat | [→](#deserted-island) |
| 31 | dull-green-forest | 自然,森林,绿色,沉稳 | 森林/沉稳 | flat | [→](#dull-green-forest) |
| 32 | deep-green | 自然,深绿,森林,活力 | 环保/活力 | flat | [→](#deep-green) |
| 33 | marigold-forest-green | 自然,金盏花,森林绿,秋季 | 秋季/自然 | flat | [→](#marigold-forest-green) |
| 34 | halloween-warm | 季节,万圣节,温暖,橙色 | 万圣节 | flat | [→](#halloween-warm) |
| 35 | spring | 季节,春季,清新,柔和 | 春季/清新 | flat | [→](#spring) |
| 36 | autumn | 季节,秋季,落叶,温暖 | 秋季/温暖 | flat | [→](#autumn) |
| 37 | gold-and-silver | 金属,金色,银色,奢华 | 奢侈品 | glass | [→](#gold-and-silver) |
| 38 | mahogany-and-gold | 金属,桃花心木,金色,高端 | 高端产品 | glass | [→](#mahogany-and-gold) |
| 39 | vermilion-and-gold | 金属,朱红,金色,中国风 | 中国风 | flat | [→](#vermilion-and-gold) |
| 40 | react | 品牌,React,科技,前端 | 前端/技术 | glass | [→](#react) |
| 41 | facebook | 品牌,社交媒体,蓝色 | 社交媒体 | flat | [→](#facebook) |
| 42 | tiktok | 品牌,社交媒体,红色 | 社交媒体 | glass | [→](#tiktok) |
| 43 | fc-barcelona | 品牌,足球,体育 | 体育/运动 | flat | [→](#fc-barcelona) |
| 44 | almonds | 食物,杏仁,棕色,自然 | 食品/自然 | flat | [→](#almonds) |
| 45 | tomatoes-cucumbers | 食物,番茄,黄瓜,新鲜 | 食品/新鲜 | flat | [→](#tomatoes-cucumbers) |
| 46 | ruby | 食物,红宝石,红色,热情 | 热情展示 | glass | [→](#ruby) |
| 47 | chocolate-mint | 食物,巧克力,薄荷,清新 | 食品/清新 | flat | [→](#chocolate-mint) |
| 48 | caramel-sage-green | 食物,焦糖,鼠尾草,温暖 | 温暖/自然 | flat | [→](#caramel-sage-green) |
| 49 | dull-peach | 食物,桃子,柔和,温暖 | 柔和温暖 | flat | [→](#dull-peach) |
| 50 | sunny-day | 天气,阳光,明亮,温暖 | 阳光/明亮 | flat | [→](#sunny-day) |
| 51 | rainy-morning | 天气,雨天,清晨,宁静 | 宁静/平和 | flat | [→](#rainy-morning) |
| 52 | vintage-cyan-coral | 复古,青色,珊瑚,怀旧 | 复古风格 | flat | [→](#vintage-cyan-coral) |
| 53 | vintage-jewelry-shop | 复古,珠宝店,优雅,中性色 | 优雅复古 | flat | [→](#vintage-jewelry-shop) |
| 54 | pantone-2023 | 潮流,2023,粉色,柔和 | 潮流/时尚 | flat | [→](#pantone-2023) |
| 55 | blush-and-slate | 双色,腮红,石板灰,柔和 | 柔和双色 | flat | [→](#blush-and-slate) |
| 56 | olive-and-coral | 双色,橄榄绿,珊瑚,自然 | 自然双色 | flat | [→](#olive-and-coral) |
| 57 | navy-and-blush | 双色,海军蓝,腮红,优雅 | 优雅双色 | flat | [→](#navy-and-blush) |
| 58 | turquoise-and-rust | 双色,绿松石,铁锈,对比 | 对比双色 | flat | [→](#turquoise-and-rust) |
| 59 | fuscia-and-turquoise | 双色,紫红,绿松石,活力 | 活力双色 | glass | [→](#fuscia-and-turquoise) |
| 60 | aubergine-burnt-orange | 双色,茄紫,焦橙,大胆 | 大胆双色 | flat | [→](#aubergine-burnt-orange) |
| 61 | celadon-and-lilac | 双色,青瓷,丁香,柔和 | 柔和双色 | flat | [→](#celadon-and-lilac) |
| 62 | periwinkle-and-coral | 双色,长春花,珊瑚,浪漫 | 浪漫双色 | flat | [→](#periwinkle-and-coral) |
| 63 | jade-and-coral | 双色,翡翠,珊瑚,对比 | 对比双色 | flat | [→](#jade-and-coral) |
| 64 | tangerine-and-beige | 双色,橘红,米色,温暖 | 温暖双色 | flat | [→](#tangerine-and-beige) |
| 65 | lavendar | 单色,薰衣草,紫色,浪漫 | 浪漫/柔和 | flat | [→](#lavendar) |
| 66 | cerulean | 单色,天蓝,明亮,清新 | 清新/明亮 | flat | [→](#cerulean) |
| 67 | turquoise | 单色,绿松石,清新,自然 | 清新自然 | flat | [→](#turquoise) |
| 68 | chartreuse | 单色,黄绿,活力,清新 | 活力清新 | flat | [→](#chartreuse) |
| 69 | gray-blue-modern | 单色,灰蓝,专业,现代 | 专业现代 | flat | [→](#gray-blue-modern) |
| 70 | deep-purple-gray | 单色,深紫灰,优雅,复古 | 优雅复古 | flat | [→](#deep-purple-gray) |
| 71 | banking-website | 专业,银行,金融,信任 | 金融/企业 | flat | [→](#banking-website) |
| 72 | crimson-light-gray | 专业,深红,正式,强调 | 正式/强调 | flat | [→](#crimson-light-gray) |
| 73 | kelly-green-primary | 专业,绿色,环保,成功 | 环保/成功 | flat | [→](#kelly-green-primary) |
| 74 | slate-maroon-pink | 专业,灰色,栗色,正式 | 正式场合 | flat | [→](#slate-maroon-pink) |
| 75 | dull-grays-orange | 专业,灰色,橙色,现代 | 现代专业 | flat | [→](#dull-grays-orange) |
| 76 | sweden | 地域,瑞典,国旗,北欧 | 北欧风格 | flat | [→](#sweden) |

---

## AI 使用指南

### 检索流程
1. 解析用户需求关键词（如"科技感"、"活力"、"专业"）
2. 在索引表的"标签"列匹配关键词
3. 读取"风格"列确定视觉风格（glass/flat）
4. 通过锚点跳转读取完整配色
5. 根据5色值智能推导完整10色

### 风格说明
每个配色主题有默认视觉风格，用户可覆盖：

| 风格 | 说明 | 视觉特征 |
|------|------|----------|
| glass | 玻璃态 | `bg-white/10 backdrop-blur-md border-white/20`，适合科技/产品演示 |
| flat | 扁平极简 | `bg-white shadow-sm border-gray-200`，适合数据报告/正式场合 |

### 色值映射规则
每个配色提供5个核心色值，映射如下：
- **色值1** → `bg-100` (主背景)
- **色值2** → `primary-100` (主强调色)
- **色值3** → `primary-200` (次强调色)
- **色值4** → `accent-100` (对比强调色)
- **色值5** → 辅助色（根据明暗推导其他）

### AI 推导其余变量
- `primary-300`: 从 primary-100 提亮 30%
- `accent-200`: 从 accent-100 加深 20%
- `text-100`: 深色背景用浅色文字，浅色背景用深色文字
- `text-200`: 比 text-100 略浅/淡
- `bg-200`: 从 bg-100 微调 ±5%
- `bg-300`: 边框色，介于 bg-100 和 text-200 之间

---

## 配色详情

### 深色/暗黑主题

#### dark-sapphire-blue
**标签:** 深色, 蓝色, 专业, 科技

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#0f1c2e` | bg-100 (主背景) |
| 2 | `#1f3a5f` | primary-100 (主强调) |
| 3 | `#4d648d` | primary-200 (次强调) |
| 4 | `#3d5a80` | accent-100 (对比强调) |
| 5 | `#cee8ff` | 浅色文字/装饰 |

---

#### dark-blue-green-red
**标签:** 深色, 多彩, 对比强烈

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#0d1f2d` | bg-100 |
| 2 | `#0d6e6e` | primary-100 |
| 3 | `#4a9d9c` | primary-200 |
| 4 | `#ff3d3d` | accent-100 |
| 5 | `#ffe0c8` | 浅色装饰 |

---

#### dark-blue-red-blush
**标签:** 深色, 蓝色, 红色点缀

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#1a1f2b` | bg-100 |
| 2 | `#2c3a4f` | primary-100 |
| 3 | `#56647b` | primary-200 |
| 4 | `#ff4d4d` | accent-100 |
| 5 | `#ffecda` | 浅色装饰 |

---

#### dark-sage-green
**标签:** 深色, 绿色, 自然

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#1e1e1e` | bg-100 |
| 2 | `#2e8b57` | primary-100 |
| 3 | `#61bc84` | primary-200 |
| 4 | `#8fbc8f` | accent-100 |
| 5 | `#345e37` | 深色装饰 |

---

#### purple-dark-black-blue
**标签:** 深色, 紫色, 霓虹

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#1a1a1a` | bg-100 |
| 2 | `#6a00ff` | primary-100 |
| 3 | `#a64aff` | primary-200 |
| 4 | `#00e5ff` | accent-100 |
| 5 | `#00829b` | accent-200 |

---

#### gold-dark
**标签:** 深色, 金色, 奢华

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#1e1e1e` | bg-100 |
| 2 | `#ffd700` | primary-100 |
| 3 | `#ddb900` | primary-200 |
| 4 | `#c49216` | accent-100 |
| 5 | `#5e3b00` | 深色装饰 |

---

#### dark-dull-peach
**标签:** 深色, 桃色, 温暖

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#3c2f2f` | bg-100 |
| 2 | `#e6b8a2` | primary-100 |
| 3 | `#c79b86` | primary-200 |
| 4 | `#c96a4e` | accent-100 |
| 5 | `#ffffdc` | 浅色装饰 |

---

#### dark-brick-mustard
**标签:** 深色, 黄色, 红色

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#2b2b2b` | bg-100 |
| 2 | `#ffc857` | primary-100 |
| 3 | `#deab3a` | primary-200 |
| 4 | `#d90429` | accent-100 |
| 5 | `#ffbfaf` | 浅色装饰 |

---

#### dark-chartreuse
**标签:** 深色, 黄绿色, 自然

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#3b3f36` | bg-100 |
| 2 | `#8cc63f` | primary-100 |
| 3 | `#628d2a` | primary-200 |
| 4 | `#f2c94c` | accent-100 |
| 5 | `#d0a00f` | accent-200 |

---

#### dark-lavendar
**标签:** 深色, 紫色, 浪漫

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#3b2d4d` | bg-100 |
| 2 | `#7b4f8e` | primary-100 |
| 3 | `#563763` | primary-200 |
| 4 | `#b794c0` | accent-100 |
| 5 | `#895896` | accent-200 |

---

#### moody-intense-red
**标签:** 深色, 红色, 强烈, 热情

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#4c0000` | bg-100 |
| 2 | `#ff5733` | primary-100 |
| 3 | `#ff8a5f` | primary-200 |
| 4 | `#ffc300` | accent-100 |
| 5 | `#916600` | accent-200 |

---

#### maroon-dull-browns
**标签:** 深色, 栗色, 棕色, 复古

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#5c0e0e` | bg-100 |
| 2 | `#8b3626` | primary-100 |
| 3 | `#61261b` | primary-200 |
| 4 | `#b5651d` | accent-100 |
| 5 | `#7f4714` | accent-200 |

---

#### space
**标签:** 深色, 太空, 星空, 金色点缀

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#0f1626` | bg-100 |
| 2 | `#ffffff` | primary-100 |
| 3 | `#e0e0e0` | primary-200 |
| 4 | `#ffd700` | accent-100 |
| 5 | `#917800` | accent-200 |

---

#### starry-night
**标签:** 深色, 星空, 艺术, 梵高风格

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#0b0f2b` | bg-100 |
| 2 | `#ffc107` | primary-100 |
| 3 | `#dda400` | primary-200 |
| 4 | `#00bcd4` | accent-100 |
| 5 | `#005e74` | accent-200 |

---

#### moon-and-mars
**标签:** 深色, 太空, 火星色

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#1c1c1c` | bg-100 |
| 2 | `#ff5733` | primary-100 |
| 3 | `#ff8a5f` | primary-200 |
| 4 | `#ffc300` | accent-100 |
| 5 | `#916600` | accent-200 |

---

#### electric-city-nights
**标签:** 深色, 蓝色, 城市, 科技

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#1e1e1e` | bg-100 |
| 2 | `#0085ff` | primary-100 |
| 3 | `#69b4ff` | primary-200 |
| 4 | `#006fff` | accent-100 |
| 5 | `#e1ffff` | 浅色装饰 |

---

#### hacker-news
**标签:** 深色, 橙色, 科技, 极客

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#1d1f21` | bg-100 |
| 2 | `#ff6600` | primary-100 |
| 3 | `#ff983f` | primary-200 |
| 4 | `#f5f5f5` | accent-100 |
| 5 | `#929292` | accent-200 |

---

### 浅色/极简主题

#### minimal-modern-light
**标签:** 浅色, 极简, 蓝色, 现代

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#ffffff` | bg-100 |
| 2 | `#3f51b5` | primary-100 |
| 3 | `#757de8` | primary-200 |
| 4 | `#2196f3` | accent-100 |
| 5 | `#003f8f` | text-100 |

---

#### white-with-blue
**标签:** 浅色, 蓝色, 清新

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#ffffff` | bg-100 |
| 2 | `#0077c2` | primary-100 |
| 3 | `#59a5f5` | primary-200 |
| 4 | `#00bfff` | accent-100 |
| 5 | `#00619a` | text-100 |

---

#### black-and-white
**标签:** 极简, 黑白, 经典

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#000000` | bg-100 |
| 2 | `#ffffff` | primary-100 |
| 3 | `#e0e0e0` | primary-200 |
| 4 | `#7f7f7f` | accent-100 |
| 5 | `#ffffff` | text-100 |

---

#### blueberry-contrast
**标签:** 浅色, 柔和, 对比

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#fffff3` | bg-100 |
| 2 | `#f7cac9` | primary-100 |
| 3 | `#5c5c5c` | primary-200 |
| 4 | `#ebebeb` | accent-100 |
| 5 | `#333333` | text-100 |

---

#### orange-flat-shadow
**标签:** 浅色, 橙色, 扁平, 现代

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#ffffff` | bg-100 |
| 2 | `#ff6600` | primary-100 |
| 3 | `#ff983f` | primary-200 |
| 4 | `#f5f5f5` | accent-100 |
| 5 | `#929292` | text-200 |

---

### 霓虹/赛博朋克

#### neon
**标签:** 霓虹, 紫色, 夜店, 科幻

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#241b35` | bg-100 |
| 2 | `#6c35de` | primary-100 |
| 3 | `#a364ff` | primary-200 |
| 4 | `#cb80ff` | accent-100 |
| 5 | `#373737` | bg-200 |

---

#### cyberpunk
**标签:** 赛博朋克, 霓虹, 科幻, 未来

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#0f0f0f` | bg-100 |
| 2 | `#ff6b6b` | primary-100 |
| 3 | `#dd4d51` | primary-200 |
| 4 | `#00ffff` | accent-100 |
| 5 | `#00999b` | accent-200 |

---

#### neon-downtown-lights
**标签:** 霓虹, 城市, 夜晚, 炫彩

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#141414` | bg-100 |
| 2 | `#ff00ff` | primary-100 |
| 3 | `#b300b2` | primary-200 |
| 4 | `#00ffff` | accent-100 |
| 5 | `#00b2b3` | accent-200 |

---

#### dance-network
**标签:** 霓虹, 粉色, 青色, 活力

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#f5f5f5` | bg-100 |
| 2 | `#ff4081` | primary-100 |
| 3 | `#ff79b0` | primary-200 |
| 4 | `#00e5ff` | accent-100 |
| 5 | `#00829b` | accent-200 |

---

### 自然风景

#### summer-meadow
**标签:** 自然, 夏季, 草地, 绿色

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#f5ecd7` | bg-100 |
| 2 | `#8fbf9f` | primary-100 |
| 3 | `#68a67d` | primary-200 |
| 4 | `#f18f01` | accent-100 |
| 5 | `#833500` | accent-200 |

---

#### rustic-mountain-cabin
**标签:** 自然, 山林, 木屋, 棕色

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#e5e5e5` | bg-100 |
| 2 | `#8b5d33` | primary-100 |
| 3 | `#be8a5e` | primary-200 |
| 4 | `#bfbfbf` | accent-100 |
| 5 | `#616161` | text-200 |

---

#### ocean-sunset
**标签:** 自然, 海洋, 日落, 温暖

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#f9afaf` | bg-100 |
| 2 | `#ffdab9` | primary-100 |
| 3 | `#dfb28a` | primary-200 |
| 4 | `#ffbda3` | accent-100 |
| 5 | `#975f48` | text-100 |

---

#### deserted-island
**标签:** 自然, 岛屿, 沙滩, 热带

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#f5ecd7` | bg-100 |
| 2 | `#8b6b61` | primary-100 |
| 3 | `#bc998e` | primary-200 |
| 4 | `#f2a900` | accent-100 |
| 5 | `#854e00` | accent-200 |

---

#### dull-green-forest
**标签:** 自然, 森林, 绿色, 沉稳

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#4b5320` | bg-100 |
| 2 | `#8f9779` | primary-100 |
| 3 | `#656b53` | primary-200 |
| 4 | `#b5c99e` | accent-100 |
| 5 | `#80a15a` | accent-200 |

---

#### deep-green
**标签:** 自然, 深绿, 森林, 活力

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#0b4f30` | bg-100 |
| 2 | `#1db954` | primary-100 |
| 3 | `#14823b` | primary-200 |
| 4 | `#ffd700` | accent-100 |
| 5 | `#b39600` | accent-200 |

---

#### marigold-forest-green
**标签:** 自然, 金盏花, 森林绿, 秋季

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#f5deb3` | bg-100 |
| 2 | `#228b22` | primary-100 |
| 3 | `#5bbc51` | primary-200 |
| 4 | `#8f9779` | accent-100 |
| 5 | `#373f25` | text-100 |

---

### 季节主题

#### halloween-warm
**标签:** 季节, 万圣节, 温暖, 橙色

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#f7eedd` | bg-100 |
| 2 | `#ff7f50` | primary-100 |
| 3 | `#dd6236` | primary-200 |
| 4 | `#8b4513` | accent-100 |
| 5 | `#ffd299` | primary-300 |

---

#### spring
**标签:** 季节, 春季, 清新, 柔和

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#f5f5dc` | bg-100 |
| 2 | `#7fb3d5` | primary-100 |
| 3 | `#6296b7` | primary-200 |
| 4 | `#f7cac9` | accent-100 |
| 5 | `#926b6a` | accent-200 |

---

#### autumn
**标签:** 季节, 秋季, 落叶, 温暖

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#f7e1b8` | bg-100 |
| 2 | `#8b4513` | primary-100 |
| 3 | `#61300d` | primary-200 |
| 4 | `#ff672a` | accent-100 |
| 5 | `#ff7a45` | accent-200 |

---

### 金属色系

#### gold-and-silver
**标签:** 金属, 金色, 银色, 奢华

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#f7f7f7` | bg-100 |
| 2 | `#ffd700` | primary-100 |
| 3 | `#ddb900` | primary-200 |
| 4 | `#c0c0c0` | accent-100 |
| 5 | `#626262` | text-200 |

---

#### mahogany-and-gold
**标签:** 金属, 桃花心木, 金色, 高端

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#6b3e26` | bg-100 |
| 2 | `#dca10f` | primary-100 |
| 3 | `#b98900` | primary-200 |
| 4 | `#c85a17` | accent-100 |
| 5 | `#ffeea4` | text-100 |

---

#### vermilion-and-gold
**标签:** 金属, 朱红, 金色, 中国风

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#efd8bb` | bg-100 |
| 2 | `#c74331` | primary-100 |
| 3 | `#8b2f22` | primary-200 |
| 4 | `#f2c335` | accent-100 |
| 5 | `#c2950c` | accent-200 |

---

### 品牌/科技

#### react
**标签:** 品牌, React, 科技, 前端

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#282c34` | bg-100 |
| 2 | `#61dafb` | primary-100 |
| 3 | `#39bcdc` | primary-200 |
| 4 | `#ff4081` | accent-100 |
| 5 | `#ffe4ff` | primary-300 |

---

#### facebook
**标签:** 品牌, 社交媒体, 蓝色

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#3b5998` | bg-100 |
| 2 | `#ffffff` | primary-100 |
| 3 | `#e0e0e0` | primary-200 |
| 4 | `#ff7f00` | accent-100 |
| 5 | `#d2d2d2` | bg-200 |

---

#### tiktok
**标签:** 品牌, 社交媒体, 红色

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#f7f7f7` | bg-100 |
| 2 | `#ee1d52` | primary-100 |
| 3 | `#ff607e` | primary-200 |
| 4 | `#ffc107` | accent-100 |
| 5 | `#916400` | accent-200 |

---

#### fc-barcelona
**标签:** 品牌, 足球, 体育

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#004d98` | bg-100 |
| 2 | `#a50044` | primary-100 |
| 3 | `#dc486f` | primary-200 |
| 4 | `#ffc400` | accent-100 |
| 5 | `#916700` | accent-200 |

---

### 食物灵感

#### almonds
**标签:** 食物, 杏仁, 棕色, 自然

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#f5f5dc` | bg-100 |
| 2 | `#8b5a2b` | primary-100 |
| 3 | `#be8756` | primary-200 |
| 4 | `#ffebcd` | accent-100 |
| 5 | `#9a896e` | text-200 |

---

#### tomatoes-cucumbers
**标签:** 食物, 番茄, 黄瓜, 新鲜

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#f7f7f7` | bg-100 |
| 2 | `#ff6347` | primary-100 |
| 3 | `#dc442e` | primary-200 |
| 4 | `#7fff00` | accent-100 |
| 5 | `#009900` | accent-200 |

---

#### ruby
**标签:** 食物, 红宝石, 红色, 热情

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#f7cac9` | bg-100 |
| 2 | `#9b111e` | primary-100 |
| 3 | `#d24a46` | primary-200 |
| 4 | `#ff5733` | accent-100 |
| 5 | `#fff3bf` | primary-300 |

---

#### chocolate-mint
**标签:** 食物, 巧克力, 薄荷, 清新

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#f5ecd7` | bg-100 |
| 2 | `#8b5f3d` | primary-100 |
| 3 | `#bd8c68` | primary-200 |
| 4 | `#a8dadc` | accent-100 |
| 5 | `#4a797b` | accent-200 |

---

#### caramel-sage-green
**标签:** 食物, 焦糖, 鼠尾草, 温暖

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#f5efe7` | bg-100 |
| 2 | `#c7b299` | primary-100 |
| 3 | `#a9957d` | primary-200 |
| 4 | `#a68b5b` | accent-100 |
| 5 | `#483507` | text-100 |

---

#### dull-peach
**标签:** 食物, 桃子, 柔和, 温暖

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#f5d7b5` | bg-100 |
| 2 | `#e89e6d` | primary-100 |
| 3 | `#c88252` | primary-200 |
| 4 | `#c96a41` | accent-100 |
| 5 | `#ffffcd` | primary-300 |

---

### 天气/氛围

#### sunny-day
**标签:** 天气, 阳光, 明亮, 温暖

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#f9d9b7` | bg-100 |
| 2 | `#ffc300` | primary-100 |
| 3 | `#dda600` | primary-200 |
| 4 | `#ff5733` | accent-100 |
| 5 | `#fff3bf` | primary-300 |

---

#### rainy-morning
**标签:** 天气, 雨天, 清晨, 宁静

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#b7c9d3` | bg-100 |
| 2 | `#5e7d7e` | primary-100 |
| 3 | `#8cacad` | primary-200 |
| 4 | `#a7a37e` | accent-100 |
| 5 | `#4b4928` | text-100 |

---

### 复古/怀旧

#### vintage-cyan-coral
**标签:** 复古, 青色, 珊瑚, 怀旧

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#e0e7e9` | bg-100 |
| 2 | `#5da399` | primary-100 |
| 3 | `#40867d` | primary-200 |
| 4 | `#ff6b6b` | accent-100 |
| 5 | `#8f001a` | accent-200 |

---

#### vintage-jewelry-shop
**标签:** 复古, 珠宝店, 优雅, 中性色

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#f5efe8` | bg-100 |
| 2 | `#bfae9f` | primary-100 |
| 3 | `#937962` | primary-200 |
| 4 | `#c9beb9` | accent-100 |
| 5 | `#978178` | text-200 |

---

#### pantone-2023
**标签:** 潮流, 2023, 粉色, 柔和

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#ffffff` | bg-100 |
| 2 | `#bb2649` | primary-100 |
| 3 | `#f35d74` | primary-200 |
| 4 | `#ffadad` | accent-100 |
| 5 | `#ffd6a5` | accent-200 |

---

### 双色对比

#### blush-and-slate
**标签:** 双色, 腮红, 石板灰, 柔和

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#f5ecec` | bg-100 |
| 2 | `#bfbfbf` | primary-100 |
| 3 | `#a2a2a2` | primary-200 |
| 4 | `#f2bac9` | accent-100 |
| 5 | `#8e5c6a` | accent-200 |

---

#### olive-and-coral
**标签:** 双色, 橄榄绿, 珊瑚, 自然

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#f2efe9` | bg-100 |
| 2 | `#8f9779` | primary-100 |
| 3 | `#737b5e` | primary-200 |
| 4 | `#ffb6b9` | accent-100 |
| 5 | `#98585c` | accent-200 |

---

#### navy-and-blush
**标签:** 双色, 海军蓝, 腮红, 优雅

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#f2f2f2` | bg-100 |
| 2 | `#2c3e50` | primary-100 |
| 3 | `#57687c` | primary-200 |
| 4 | `#f7cac9` | accent-100 |
| 5 | `#926b6a` | accent-200 |

---

#### turquoise-and-rust
**标签:** 双色, 绿松石, 铁锈, 对比

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#b2dfdb` | bg-100 |
| 2 | `#795548` | primary-100 |
| 3 | `#a98274` | primary-200 |
| 4 | `#ffc107` | accent-100 |
| 5 | `#916400` | accent-200 |

---

#### fuscia-and-turquoise
**标签:** 双色, 紫红, 绿松石, 活力

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#fce4ec` | bg-100 |
| 2 | `#00bcd4` | primary-100 |
| 3 | `#009fb6` | primary-200 |
| 4 | `#ff4081` | accent-100 |
| 5 | `#ffe4ff` | primary-300 |

---

#### aubergine-burnt-orange
**标签:** 双色, 茄紫, 焦橙, 大胆

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#5b2c6f` | bg-100 |
| 2 | `#ff6f61` | primary-100 |
| 3 | `#df4e43` | primary-200 |
| 4 | `#ffb347` | accent-100 |
| 5 | `#925700` | accent-200 |

---

#### celadon-and-lilac
**标签:** 双色, 青瓷, 丁香, 柔和

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#e6f2ea` | bg-100 |
| 2 | `#b0c5d1` | primary-100 |
| 3 | `#93a8b3` | primary-200 |
| 4 | `#d1b0c5` | accent-100 |
| 5 | `#715467` | accent-200 |

---

#### periwinkle-and-coral
**标签:** 双色, 长春花, 珊瑚, 浪漫

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#f0e8ee` | bg-100 |
| 2 | `#b5d3d2` | primary-100 |
| 3 | `#98b5b4` | primary-200 |
| 4 | `#ffb6c1` | accent-100 |
| 5 | `#985863` | accent-200 |

---

#### jade-and-coral
**标签:** 双色, 翡翠, 珊瑚, 对比

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#f2efe9` | bg-100 |
| 2 | `#00a896` | primary-100 |
| 3 | `#008b7a` | primary-200 |
| 4 | `#ff6b6b` | accent-100 |
| 5 | `#8f001a` | accent-200 |

---

#### tangerine-and-beige
**标签:** 双色, 橘红, 米色, 温暖

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#f5e6cc` | bg-100 |
| 2 | `#ffa07a` | primary-100 |
| 3 | `#de835f` | primary-200 |
| 4 | `#ffc0cb` | accent-100 |
| 5 | `#99616c` | accent-200 |

---

### 单色系

#### lavendar
**标签:** 单色, 薰衣草, 紫色, 浪漫

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#f5f3f7` | bg-100 |
| 2 | `#8b5fbf` | primary-100 |
| 3 | `#61398f` | primary-200 |
| 4 | `#d6c6e1` | accent-100 |
| 5 | `#9a73b5` | accent-200 |

---

#### cerulean
**标签:** 单色, 天蓝, 明亮, 清新

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#007ba7` | bg-100 |
| 2 | `#00a8e8` | primary-100 |
| 3 | `#0076a2` | primary-200 |
| 4 | `#ffb400` | accent-100 |
| 5 | `#b37e00` | accent-200 |

---

#### turquoise
**标签:** 单色, 绿松石, 清新, 自然

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#e0f2f1` | bg-100 |
| 2 | `#26a69a` | primary-100 |
| 3 | `#408d86` | primary-200 |
| 4 | `#80cbc4` | accent-100 |
| 5 | `#43a49b` | accent-200 |

---

#### chartreuse
**标签:** 单色, 黄绿, 活力, 清新

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#dfff00` | bg-100 |
| 2 | `#7fff00` | primary-100 |
| 3 | `#aaff70` | primary-200 |
| 4 | `#00ff7f` | accent-100 |
| 5 | `#00971f` | accent-200 |

---

#### gray-blue-modern
**标签:** 单色, 灰蓝, 专业, 现代

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#b7c4cf` | bg-100 |
| 2 | `#2e4057` | primary-100 |
| 3 | `#596b84` | primary-200 |
| 4 | `#f73859` | accent-100 |
| 5 | `#a3a3a3` | bg-200 |

---

#### deep-purple-gray
**标签:** 单色, 深紫灰, 优雅, 复古

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#44496b` | bg-100 |
| 2 | `#c9ada7` | primary-100 |
| 3 | `#ab908b` | primary-200 |
| 4 | `#f2ccb8` | accent-100 |
| 5 | `#8e6d5b` | accent-200 |

---

### 专业/商务

#### banking-website
**标签:** 专业, 银行, 金融, 信任

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#f5f5f5` | bg-100 |
| 2 | `#0070c0` | primary-100 |
| 3 | `#004e86` | primary-200 |
| 4 | `#ffc000` | accent-100 |
| 5 | `#b38600` | accent-200 |

---

#### crimson-light-gray
**标签:** 专业, 深红, 正式, 强调

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#e9e9e9` | bg-100 |
| 2 | `#8b0000` | primary-100 |
| 3 | `#c2402a` | primary-200 |
| 4 | `#ff6347` | accent-100 |
| 5 | `#8d0000` | accent-200 |

---

#### kelly-green-primary
**标签:** 专业, 绿色, 环保, 成功

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#e6fbe3` | bg-100 |
| 2 | `#4caf50` | primary-100 |
| 3 | `#2a9235` | primary-200 |
| 4 | `#ffc107` | accent-100 |
| 5 | `#916400` | accent-200 |

---

#### slate-maroon-pink
**标签:** 专业, 灰色, 栗色, 正式

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#4a4e4d` | bg-100 |
| 2 | `#b33a3a` | primary-100 |
| 3 | `#ea6a64` | primary-200 |
| 4 | `#f2bac9` | accent-100 |
| 5 | `#8e5c6a` | accent-200 |

---

#### dull-grays-orange
**标签:** 专业, 灰色, 橙色, 现代

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#efefef` | bg-100 |
| 2 | `#ffa500` | primary-100 |
| 3 | `#dd8900` | primary-200 |
| 4 | `#808080` | accent-100 |
| 5 | `#2b2b2b` | text-100 |

---

### 地域/文化

#### sweden
**标签:** 地域, 瑞典, 国旗, 北欧

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#f5f5f5` | bg-100 |
| 2 | `#005b99` | primary-100 |
| 3 | `#4e88ca` | primary-200 |
| 4 | `#ffd700` | accent-100 |
| 5 | `#e9aa2b` | accent-200 |

---

### 其他配色

#### mystery-purple-gray
**标签:** 神秘, 深色, 紫灰, 优雅

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#151931` | bg-100 |
| 2 | `#e7d1bb` | primary-100 |
| 3 | `#c8b39e` | primary-200 |
| 4 | `#a096a5` | accent-100 |
| 5 | `#463e4b` | bg-200 |

---

#### red-cyan-contrast
**标签:** 红色, 青色, 对比, 活力

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#ffffff` | bg-100 |
| 2 | `#de283b` | primary-100 |
| 3 | `#ff6366` | primary-200 |
| 4 | `#25b1bf` | accent-100 |
| 5 | `#005461` | accent-200 |

---

#### red-gray-modern
**标签:** 红色, 灰色, 现代, 专业

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#fbfbfb` | bg-100 |
| 2 | `#c21d03` | primary-100 |
| 3 | `#fd5732` | primary-200 |
| 4 | `#393939` | accent-100 |
| 5 | `#bebebe` | bg-200 |

---

#### orange-cyan-fresh
**标签:** 橙色, 青色, 清新, 活力

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#f4fdfd` | bg-100 |
| 2 | `#ee6c4d` | primary-100 |
| 3 | `#cc4f34` | primary-200 |
| 4 | `#f7d1b3` | accent-100 |
| 5 | `#927156` | accent-200 |

---

#### playful
**标签:** 粉色, 活泼, 可爱, 女性化

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#f9d5e5` | bg-100 |
| 2 | `#ffc2d0` | primary-100 |
| 3 | `#e0a4b2` | primary-200 |
| 4 | `#ff9aa2` | accent-100 |
| 5 | `#963c48` | accent-200 |

---

#### dull-blue-pink
**标签:** 蓝色, 粉色, 对比, 柔和

| 色值 | Hex | 用途 |
|------|-----|------|
| 1 | `#e6e6fa` | bg-100 |
| 2 | `#6b5b95` | primary-100 |
| 3 | `#4b4068` | primary-200 |
| 4 | `#ff7f11` | accent-100 |
| 5 | `#be5800` | accent-200 |

---

## 使用建议

### 按场景推荐

| 场景 | 推荐配色 |
|------|----------|
| 企业官网 | minimal-modern-light, banking-website |
| 科技产品 | react, cyberpunk, electric-city-nights, dark-sapphire-blue |
| 电商平台 | playful, pantone-2023, fuscia-and-turquoise |
| 社交媒体 | tiktok, facebook, dance-network |
| 自然/环保 | summer-meadow, deep-green, marigold-forest-green |
| 奢侈品牌 | gold-dark, mahogany-and-gold, gold-and-silver |
| 暗黑模式 | dark-sapphire-blue, space, starry-night |

### 按情绪推荐

| 情绪 | 推荐配色 |
|------|----------|
| 活力/热情 | neon, cyberpunk, tomatoes-cucumbers |
| 宁静/平和 | rainy-morning, cerulean, turquoise |
| 温暖/舒适 | autumn, halloween-warm, caramel-sage-green |
| 专业/信任 | banking-website, navy-and-blush, slate-maroon-pink |
| 浪漫/柔和 | lavendar, periwinkle-and-coral, blush-and-slate |
