# Test Gap Report: HuntingPage

**Audit date:** 2026-02-09
**Source files audited:** `ui/src/pages/__tests__/HuntingPage.test.tsx` (source is test-only; component contract inferred from mocks and test interactions)
**Test files audited:** `ui/src/pages/__tests__/HuntingPage.test.tsx`
**Current test count:** 7 tests
**Estimated coverage:** ~40% of inferred behaviors (manual audit)

---

## Summary

HuntingPage tests cover the core happy paths — mount bootstrap, admin vs. non-admin visibility, query execution, save modal lifecycle, example query parsing, and error banners. However, significant behavioral gaps exist around failure handling, loading states, saved query management (run/delete), the fingerprint pivot callback, and edge cases in the modal and query flows. The tests mock child components appropriately to isolate page-level orchestration logic, but several hook return values and callbacks exposed by the mock are never exercised.

Total behaviors identified: 22
- ✅ Covered: 7
- ⚠️ Shallow: 2
- ❌ Missing: 13

---

## Behavior Inventory

| # | Behavior | Coverage | Notes |
|---|----------|----------|-------|
| 1 | Calls `getStatus` and `getSavedQueries` on mount | ✅ Covered | `bootstraps data on mount` |
| 2 | Hides admin panels when `isFleetAdmin: false` | ✅ Covered | Checks `low-slow-panel` absent and admin-only message present |
| 3 | Shows admin panels when `isFleetAdmin: true` | ✅ Covered | Checks `low-slow-panel` present |
| 4 | Executes query via `queryTimeline` and displays results | ✅ Covered | Clicks Run Query, asserts `Results: 42` |
| 5 | Parses example queries and passes as `externalQuery` | ⚠️ Shallow | Only tests first example button; no coverage of other examples |
| 6 | Save query modal: open → fill name → submit → close | ✅ Covered | Full lifecycle tested |
| 7 | Error banner display and dismiss via `clearError` | ✅ Covered | Shows error text, clicks Dismiss, asserts clearError called |
| 8 | Loading state (`isLoading: true`) shows loading indicator | ❌ Missing | `isLoading` is in mock but never set to `true` |
| 9 | Query failure (queryTimeline rejects) shows error | ❌ Missing | Only happy path tested |
| 10 | Save query failure (saveQuery rejects) shows error / keeps modal open | ❌ Missing | |
| 11 | Saved queries list rendered and `runSavedQuery` callback works | ❌ Missing | `SavedQueries` mock exists but no test populates or clicks saved queries |
| 12 | Delete saved query flow | ❌ Missing | `deleteSavedQuery` in mock, never called |
| 13 | FleetIntelligencePanel `onPivotFingerprint` callback | ❌ Missing | Mock exposes "Pivot FP" button but no test clicks it |
| 14 | Anomalies panel renders | ⚠️ Shallow | Panel is in mock but no test asserts its presence |
| 15 | Sigma leads panel renders and `ackSigmaLead` works | ❌ Missing | |
| 16 | Sigma rules panel renders and CRUD operations | ❌ Missing | `createSigmaRule`, `getSigmaRules`, `updateSigmaRule`, `deleteSigmaRule` never exercised |
| 17 | `status.historical: false` disables query features | ❌ Missing | Always set to `true` |
| 18 | Save query with description (third arg to `saveQuery`) | ❌ Missing | Current test asserts `undefined` for description |
| 19 | Multiple example queries produce correct `externalQuery` shapes | ❌ Missing | Only first example tested |
| 20 | Bootstrap failure (getStatus rejects) shows error | ❌ Missing | |
| 21 | Tab/section navigation between hunting panels | ❌ Missing | No tab switching tested |
| 22 | `useDocumentTitle` sets correct page title | ❌ Missing | Hook is mocked but never asserted |

---

## Gaps by Priority

### P0 — Security / Correctness Critical

| # | Behavior | Current State | Why P0 | Suggested Test |
|---|----------|---------------|--------|----------------|
| 1 | Admin panel visibility is comprehensive (all admin-only panels hidden) | ⚠️ Shallow | Only checks `low-slow-panel`; other admin-gated panels (fleet intel, sigma rules/leads) might leak to non-admins | Assert ALL admin-only panels are absent when `isFleetAdmin: false`, not just one |
| 2 | Sigma rules CRUD operations respect authorization | ❌ Missing | Sigma rules affect detection logic; untested CRUD could silently fail or allow unauthorized changes | Test `createSigmaRule`, `updateSigmaRule`, `deleteSigmaRule` are called with correct args |

### P1 — Reliability / Edge Cases

| # | Behavior | Current State | Why P1 | Suggested Test |
|---|----------|---------------|--------|----------------|
| 1 | Query failure handling (`queryTimeline` rejects) | ❌ Missing | Failed queries with no error display = silent data loss for threat hunters | Mock `queryTimeline` to reject, verify error banner appears |
| 2 | Loading state renders indicator | ❌ Missing | No loading indicator = users re-submit queries, causing duplicate requests | Set `isLoading: true`, assert loading UI is present and query button is disabled |
| 3 | Save query failure keeps modal open with error | ❌ Missing | Users lose typed query names on silent save failures | Mock `saveQuery` to reject, assert modal stays open with error message |
| 4 | Bootstrap failure (`getStatus` rejects) | ❌ Missing | Page may render in broken state with no feedback | Mock `getStatus` to reject, verify error state shown |
| 5 | Saved queries: populate list and run a saved query | ❌ Missing | Core feature path — saved queries are useless if run doesn't work | Provide saved queries array from `getSavedQueries`, click one, assert `runSavedQuery` called with correct ID |
| 6 | Delete saved query flow | ❌ Missing | Orphaned saved queries clutter the UI | Render with saved queries, trigger delete, assert `deleteSavedQuery` called |
| 7 | FleetIntelligencePanel `onPivotFingerprint` updates query | ❌ Missing | Pivoting from fleet intel to hunting query is a key workflow | Click "Pivot FP" button, assert `externalQuery` updates with fingerprint filter |
| 8 | `status.historical: false` disables or alters query UI | ❌ Missing | Querying without historical data backend would produce confusing empty results | Set `historical: false`, assert query features are disabled or show warning |

### P2 — Completeness / Confidence

| # | Behavior | Current State | Why P2 | Suggested Test |
|---|----------|---------------|--------|----------------|
| 1 | All example queries parse correctly (not just first) | ❌ Missing | Regression risk if example query definitions change | Click each "Run →" button, assert each produces expected `externalQuery` shape |
| 2 | Save query with description field | ❌ Missing | Feature exists but third arg always `undefined` in test | Fill description field in modal, assert `saveQuery` called with description string |
| 3 | Anomalies panel renders for admin users | ⚠️ Shallow | Panel mock exists but no test asserts presence | Add `expect(screen.getByTestId('anomalies-panel'))` to admin panel test |
| 4 | Sigma leads panel renders and ack flow | ❌ Missing | Completeness of hunting workflow | Render page, assert sigma-leads-panel present, trigger ack, assert `ackSigmaLead` called |
| 5 | `useDocumentTitle` called with correct title | ❌ Missing | Minor UX but easy to verify | Assert `useDocumentTitle` was called with expected page title string |
| 6 | Tab/section navigation between panels | ❌ Missing | If tabs exist, navigation regression would hide entire panels | Click each tab, assert corresponding panel becomes visible |

---

## Shallow Test Details

### Example query parsing (`handles example query parsing correctly`)
**Current test:** Clicks the first "Run →" button and checks `externalQuery.sourceIps` contains `'185.228.'`.
**Problem:** Only tests one of potentially several example queries. If other examples have different parsing logic (domain filters, fingerprint filters, time ranges), those paths are untested.
**Recommended fix:** Add parameterized tests for each example query button, asserting the specific `externalQuery` shape each should produce.

### Admin panel visibility (`hides admin panels for non-admin users`)
**Current test:** Asserts `low-slow-panel` is not in the document and an "admin-only" message is shown.
**Problem:** Only checks one panel. Fleet intelligence, sigma leads, and sigma rules panels may also be admin-gated but aren't verified as hidden. If a future change accidentally removes the gate on one of those panels, this test won't catch it.
**Recommended fix:** Assert absence of ALL admin-only panels: `fleet-intel-panel`, `sigma-leads-panel`, `sigma-rules-panel`, and `low-slow-panel`.

---

## Notes

- **Source code not provided separately.** The audit was performed against the test file itself, inferring the component's contract from mock shapes, callback signatures, and rendered child components. A follow-up audit with the actual `HuntingPage.tsx` source would likely reveal additional behaviors not visible from tests alone.
- **Mock granularity is good.** Child components are appropriately mocked to isolate page orchestration logic. The mock shapes expose callbacks (`onPivotFingerprint`, `onRun`, `onQuery`, `onSave`) that are ready for testing but not yet exercised.
- **Test helper opportunity.** A `renderHuntingPage(overrides?)` helper that wraps `MemoryRouter` + `useHunt` mock setup would reduce boilerplate across tests. Several tests repeat the same `act(() => render(...))` pattern with minor mock variations.
- **`vi.clearAllMocks()` in `beforeEach` is correct** — prevents state leakage between tests.
