---
name: documentation-production
description: Use when generating, updating, or organizing documentation (component/API docs, project indexes, diagrams, tutorials, learning paths) - provides structured workflows and references for docs generation, indexing, diagrams, and teaching.
---

# Documentation Production

## Overview
Provide a consistent, low-friction workflow for producing documentation across formats: focused docs, indexes, diagrams, tutorials, and learning paths. Keep outputs structured and aligned with the repo's docs conventions.

## When to Use
- Generating or updating documentation for components, APIs, or features
- Building a project index or knowledge base
- Creating Mermaid diagrams for system behavior or architecture
- Writing tutorials, workshops, or learning paths
- Explaining concepts for onboarding or education

Avoid when:
- The request is primarily a code change (use implementation workflows)
- The doc type is a one-off note that doesn't need structure

## Quick Reference

| Task | Load reference |
| --- | --- |
| Generate focused docs | `skills/documentation-production/references/generate.md` |
| Project index/knowledge base | `skills/documentation-production/references/index.md` |
| Mermaid diagrams | `skills/documentation-production/references/diagrams.md` |
| Teach concepts / learning paths | `skills/documentation-production/references/teacher.md` |
| Tutorials / workshops | `skills/documentation-production/references/tutorials.md` |
| Writing process & style | `skills/documentation-production/references/writing-process.md` |

## Workflow
1. Identify doc type and target audience.
2. Load the relevant reference file(s) for structure and patterns.
3. Gather source material from code or existing docs.
4. Produce the artifact using the required format.
5. Validate accuracy and consistency with repo conventions.
6. Summarize changes and next steps.

## Output
- The documentation artifact(s)
- Brief change summary and any follow-up gaps

## Common Mistakes
- Skipping source review and guessing behavior
- Mixing tutorial/guide formats without clear intent
- Creating diagrams without labels or accessibility notes
- Updating docs without adjusting indexes or nav links
