---
name: product-strategy
description: Product vision, roadmap development, and go-to-market execution with structured prioritization frameworks. Use when evaluating features, planning product direction, or assessing market fit.
keywords:
  - product strategy
  - roadmap
  - prioritization
  - feature planning
  - OKRs
  - product-market fit
triggers:
  - product strategy
  - roadmap planning
  - feature prioritization
  - go-to-market
  - OKR definition
---

# Product Strategy

Strategic product planning covering vision articulation, roadmap development, prioritization frameworks, and go-to-market execution. Evaluates features through customer value, business impact, and strategic alignment lenses.

## When to Use This Skill

- Evaluating and prioritizing a feature backlog
- Defining product vision or strategic direction
- Planning roadmaps for releases or product launches
- Assessing product-market fit for new concepts
- Setting OKRs and success metrics for product goals
- Analyzing competitive positioning and market opportunities
- Balancing technical debt against feature delivery

## Quick Reference

| Task | Load reference |
| --- | --- |
| Prioritization frameworks | `skills/product-strategy/references/prioritization-frameworks.md` |

## Workflow

1. **Understand the goal**: What outcome are we seeking?
2. **Assess alignment**: Does this fit the product vision?
3. **Select a framework**: Choose the right prioritization method for the context.
4. **Evaluate trade-offs**: What are we not building instead? What is the opportunity cost?
5. **Define success**: How will we measure impact? Identify the north star metric.
6. **Plan execution**: What is the MVP and iteration path?

## Domain Vocabulary

**product vision**, **roadmap**, **prioritization**, **OKRs**, **value proposition**, **product-market fit**, **MVP**, **feature backlog**, **user stories**, **RICE scoring**, **jobs-to-be-done**, **north star metric**, **opportunity cost**, **technical debt**

## Guiding Questions

Ask these at every decision point:

1. "What customer problem does this solve?"
2. "What's the opportunity cost of building this?"
3. "How does this align with our product vision?"

## Capabilities

### Vision and Strategy
- Product vision articulation and communication
- Strategic roadmap development
- Competitive landscape analysis
- Market opportunity identification
- Product positioning and differentiation

### Prioritization and Planning
- RICE, MoSCoW, and Kano model prioritization
- Jobs-to-be-done framework application
- OKR definition and tracking
- Sprint planning and capacity management
- Technical debt prioritization

### Stakeholder Management
- Cross-functional alignment facilitation
- Executive communication and buy-in
- Customer feedback synthesis
- Engineering partnership optimization
- Go-to-market coordination

### Metrics and Analytics
- North star metric identification
- Product analytics interpretation
- Funnel analysis and optimization
- Cohort analysis for retention
- A/B test result interpretation

## Response Approach

1. **Understand the goal**: What outcome are we seeking?
2. **Assess alignment**: Does this fit our product vision?
3. **Evaluate trade-offs**: What are we not building instead?
4. **Define success**: How will we measure impact?
5. **Plan execution**: What is the MVP and iteration path?

## Example Interactions

- "Prioritize this feature backlog for Q1"
- "Define OKRs for user engagement improvement"
- "Evaluate market fit for this new product concept"
- "Create a roadmap for mobile app launch"
- "Analyze competitive positioning against market leaders"
