---
name: requirements-discovery
description: Stakeholder interviews, PRD structure, and scope definition for software requirements elicitation. Use when gathering requirements, defining project scope, or structuring product requirement documents.
---

# Requirements Discovery

Systematic requirements elicitation through structured questioning, stakeholder analysis, and specification development. Transforms ambiguous project ideas into concrete, measurable specifications.

## When to Use This Skill

- Gathering requirements for a new project or feature from vague descriptions
- Conducting stakeholder interviews to uncover needs and constraints
- Writing or structuring a Product Requirements Document (PRD)
- Defining project scope with clear boundaries and priorities
- Creating user stories with well-defined acceptance criteria
- Identifying non-functional requirements (performance, security, scalability)
- Resolving conflicting stakeholder priorities
- Validating requirement completeness before handing off to implementation

## Quick Reference

| Task | Load reference |
| --- | --- |
| Interview patterns, PRD structure, scope definition, user story mapping | `skills/requirements-discovery/references/elicitation-techniques.md` |

## Core Principles

- **Ask "why" before "how"**: Uncover true user needs, not assumed solutions
- **Socratic questioning**: Guide discovery through questions rather than assumptions
- **Progressive refinement**: Move from broad goals to specific, testable criteria
- **Stakeholder balance**: Integrate diverse perspectives without letting any single voice dominate

## Workflow

### 1. Discovery

Understand the problem space before defining solutions.

- Identify all stakeholders and their roles
- Conduct structured interviews with open and closed questions
- Map user personas and their pain points
- Capture constraints (technical, budget, timeline, regulatory)

### 2. Specification

Transform raw input into structured requirements.

- Draft PRD with functional and non-functional requirements
- Write user stories with acceptance criteria
- Prioritize using MoSCoW or similar framework
- Define scope boundaries (what is explicitly out of scope)

### 3. Validation

Verify completeness and alignment before implementation.

- Review specifications with stakeholders
- Confirm acceptance criteria are testable and measurable
- Baseline success metrics and KPIs
- Log open questions and follow-up actions
- Prepare implementation handoff document

## Common Mistakes

- Jumping to solutions before understanding the problem
- Treating requirements as fixed rather than iteratively refined
- Missing non-functional requirements (performance, security, accessibility)
- Failing to define what is out of scope
- Writing acceptance criteria that cannot be objectively tested
- Skipping validation with actual users or stakeholders
