---
name: session-management
description: Use when loading, saving, or reflecting on session context - provides structured workflows for session lifecycle management and reflection outputs.
---

# Session Management

## Overview
Manage session lifecycle: load context, save checkpoints, and reflect on progress with consistent reporting.

## When to Use
- Loading project context or checkpoints
- Saving session context or learnings
- Reflecting on task completion and validation

Avoid when:
- The task is not session-related

## Quick Reference

| Task | Load reference |
| --- | --- |
| Load session | `skills/session-management/references/load.md` |
| Save session | `skills/session-management/references/save.md` |
| Reflect on session | `skills/session-management/references/reflect.md` |

## Workflow
1. Select the session operation.
2. Load the matching reference.
3. Execute the operation and capture outputs.
4. Provide a summary and next steps.

## Output
- Session status summary
- Saved context or reflection notes

## Common Mistakes
- Saving without capturing key changes
- Reflecting without validation evidence
