---
name: system-design
description: Use when designing system architecture, APIs, components, or data models - provides a structured design workflow with validation and documentation outputs.
---

# System Design

## Overview
Create clear system, API, component, or data model designs with explicit requirements, constraints, and validation steps.

## When to Use
- Designing system architecture or components
- Specifying APIs or data models
- Producing design docs or diagrams

Avoid when:
- You only need implementation tasks (use implementation-workflow)

## Quick Reference

| Task | Load reference |
| --- | --- |
| System design workflow | `skills/system-design/references/system.md` |

## Workflow
1. Gather requirements and constraints.
2. Load the system design reference.
3. Define structure, interfaces, and data flows.
4. Validate against constraints and best practices.
5. Deliver spec/diagram/code artifacts.

## Output
- Design spec or diagram
- Validation notes and follow-ups

## Common Mistakes
- Designing without constraints
- Mixing implementation details with spec scope
