---
name: test-generation
description: Use when generating tests for new or existing code to improve coverage - provides a structured workflow for analyzing code, creating tests, and validating coverage goals.
---

# Test Generation

## Overview
Generate tests systematically by analyzing code paths, covering edge cases, and validating coverage targets.

## When to Use
- Creating tests for new features
- Improving coverage in weak areas
- Building regression or integration test suites

Avoid when:
- The task is only running existing tests (use dev-workflows)

## Quick Reference

| Task | Load reference |
| --- | --- |
| Test generation workflow | `skills/test-generation/references/generate-tests.md` |

## Workflow
1. Identify target scope and test type.
2. Load the test generation reference.
3. Analyze code paths and edge cases.
4. Generate tests and validate coverage.
5. Summarize results and gaps.

## Output
- Generated tests
- Coverage report and follow-ups

## Common Mistakes
- Writing tests without understanding code paths
- Ignoring edge cases or failure modes
