---
name: visual-modes
description: Use when activating visual showcase modes (supersaiyan, kamehameha, over9000) for UI or interaction design - provides mode-specific enhancement checklists.
---

# Visual Modes

## Overview
Apply the appropriate visual enhancement mode and follow its checklist for UI and interaction design.

## When to Use
- Activating Super Saiyan, Kamehameha, or Over 9000 visual modes
- Designing high-impact UI showcases

Avoid when:
- The target is non-visual or text-only output

## Quick Reference

| Mode | Load reference |
| --- | --- |
| Super Saiyan | `skills/visual-modes/references/supersaiyan.md` |
| Kamehameha | `skills/visual-modes/references/kamehameha.md` |
| Over 9000 | `skills/visual-modes/references/over9000.md` |

## Workflow
1. Select the visual mode.
2. Load the matching reference.
3. Apply the required enhancements and safeguards.
4. Validate performance and accessibility.

## Output
- Mode activation summary
- Key enhancements applied

## Common Mistakes
- Ignoring performance/accessibility constraints
- Mixing modes without documenting rationale
