---
name: development-estimation
description: Use when estimating time, effort, or complexity for features or projects - provides structured estimation workflows with breakdowns, risks, and confidence intervals.
---

# Development Estimation

## Overview
Create consistent, defensible estimates by breaking scope into components, identifying risks, and providing confidence intervals.

## When to Use
- Estimating feature or project scope
- Providing effort or complexity estimates
- Delivering risk-aware breakdowns

Avoid when:
- The task is trivial or a rough gut-check is sufficient
- Requirements are unknown and need discovery first

## Quick Reference

| Task | Load reference |
| --- | --- |
| Estimation workflow | `skills/development-estimation/references/estimate.md` |

## Workflow
1. Define scope and estimation type (time/effort/complexity).
2. Load the estimation reference for structure.
3. Break into components and dependencies.
4. Add risks and confidence intervals.
5. Deliver estimate with assumptions.

## Output
- Estimate with breakdown and confidence interval
- Assumptions, risks, and validation notes

## Common Mistakes
- Estimating without clear scope
- Ignoring risk and dependency factors
- Overstating precision beyond available data
